/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchIHasPatches;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchPatch;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OipczPatchesChecks {
    private OipczPatchesChecks() {
    }

    public static OipcrIResult checkPatches(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block14: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchIHasPatches oRefOS;
                    OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchIHasPatches oOS = (OipchIHasPatches)((Object)oHost.getOS());
                    OipchVersion oVer = ((OipchOS)((Object)oOS)).getOSVersion();
                    OipchIHasPatches oipchIHasPatches = oRefOS = oVer == null ? null : (OipchIHasPatches)((Object)oRefhost.getOSForVersion(oVer));
                    if (oRefOS != null) {
                        Iterator oExpectedPatches = oRefOS.getPatches();
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                        if (oExpectedPatches != null) {
                            while (oExpectedPatches.hasNext()) {
                                OipchPatch oExpectedPatch = (OipchPatch)oExpectedPatches.next();
                                String sExpectedPatch = oExpectedPatch.getDisplayName();
                                Iterator oActualPatches = oOS.getPatches();
                                String sActualPatch = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ002");
                                OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                                OipchPatch oLastFoundPatch = null;
                                if (oActualPatches != null) {
                                    while (oActualPatches.hasNext()) {
                                        OipchPatch oActualPatch = (OipchPatch)oActualPatches.next();
                                        int iCompare = oActualPatch.compare(oExpectedPatch);
                                        if (iCompare == 1 || iCompare == 4) {
                                            oRes = OipcrResult.PASSED_RESULT;
                                            if (oLastFoundPatch != null && oActualPatch.compare(oLastFoundPatch) != 4) continue;
                                            oLastFoundPatch = oActualPatch;
                                            sActualPatch = oActualPatch.getDisplayName();
                                            continue;
                                        }
                                        if (oRes == OipcrResult.PASSED_RESULT || iCompare != 2) continue;
                                        oRes = OipcrResult.FAILED_RESULT;
                                        if (oLastFoundPatch != null && oActualPatch.compare(oLastFoundPatch) != 4) continue;
                                        oLastFoundPatch = oActualPatch;
                                        sActualPatch = oActualPatch.getDisplayName();
                                    }
                                }
                                oResDetails.add(new OipcrResultDetails((Object)sActualPatch, (Object)sExpectedPatch, oRes));
                            }
                            oResult = new OipcrResult(oResDetails);
                        } else {
                            OipcrIResult oRes = OipcrResult.PASSED_RESULT;
                            ArrayList<OipcrResultDetails> oResDetails1 = new ArrayList<OipcrResultDetails>();
                            String sActualMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_CHECK_PATCHES_NOTFOUND");
                            String sExpectedMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_CHECK_PATCHES_REQUIRED");
                            oResDetails1.add(new OipcrResultDetails((Object)sActualMsg, (Object)sExpectedMsg, oRes));
                            oResult = new OipcrResult(oResDetails1);
                        }
                        break block14;
                    }
                    Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : ((OipchOS)((Object)oOS)).getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName()};
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }
}

