/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchClusterDetails;
import oracle.sysman.oip.oipc.oipch.OipchDevice;
import oracle.sysman.oip.oipc.oipch.OipchDisplay;
import oracle.sysman.oip.oipc.oipch.OipchEnvironmentDetails;
import oracle.sysman.oip.oipc.oipch.OipchGroup;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchMemoryDetails;
import oracle.sysman.oip.oipc.oipch.OipchNetworkDetails;
import oracle.sysman.oip.oipc.oipch.OipchPartition;
import oracle.sysman.oip.oipc.oipch.OipchShell;
import oracle.sysman.oip.oipc.oipch.OipchSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchUser;

public class OipchSystem {
    private OipchDisplay m_oDisplay;
    private List m_oCPUDetails;
    private OipchNetworkDetails m_oNetworkDetails;
    private OipchMemoryDetails m_oMemoryDetails = new OipchMemoryDetails();
    private OipchEnvironmentDetails m_oEnvDetails;
    private OipchClusterDetails m_oClusterDetails;
    private List m_oUsers;
    private List m_oGroups;
    private Map m_oDeviceDetails;
    private List m_oPartitionDetails;
    private String m_sCurrentRunlevel = "-1";
    private String m_sDefaultRunlevel = "-1";
    private HashMap m_oShellDetails;

    public OipchSystem() {
        this.m_oCPUDetails = new ArrayList(1);
        this.m_oEnvDetails = new OipchEnvironmentDetails();
        this.m_oUsers = new ArrayList(1);
        this.m_oGroups = new ArrayList(1);
        this.m_oDeviceDetails = new HashMap();
        this.m_oPartitionDetails = new ArrayList(1);
    }

    public OipchClusterDetails getClusterDetails() {
        return this.m_oClusterDetails;
    }

    void setClusterDetails(OipchClusterDetails oClusterDetails) {
        this.m_oClusterDetails = oClusterDetails;
    }

    public OipchNetworkDetails getNetworkDetails() {
        return this.m_oNetworkDetails;
    }

    void setNetworkDetails(OipchNetworkDetails oNetworkDetails) {
        this.m_oNetworkDetails = oNetworkDetails;
    }

    public OipchMemory getAvailableMemory() {
        return this.m_oMemoryDetails.getAvailableMemory();
    }

    void setAvailableMemory(OipchMemory oMemory) {
        this.m_oMemoryDetails.setAvailableMemory(oMemory);
    }

    public OipchMemory getPhysicalMemory() {
        return this.m_oMemoryDetails.getPhysicalMemory();
    }

    void setPhysicalMemory(OipchMemory oMemory) {
        this.m_oMemoryDetails.setPhysicalMemory(oMemory);
    }

    public OipchMemory getSwapSpace() {
        return this.m_oMemoryDetails.getSwapSpace();
    }

    void setSwapSpace(OipchMemory oSwapSpace) {
        this.m_oMemoryDetails.setSwapSpace(oSwapSpace);
    }

    public OipchDisplay getDisplay() {
        return this.m_oDisplay;
    }

    void setDisplay(OipchDisplay oDisplay) {
        this.m_oDisplay = oDisplay;
    }

    public Iterator getCPUs() {
        return this.m_oCPUDetails.iterator();
    }

    public Iterator getUsers() {
        return this.m_oUsers.iterator();
    }

    public OipchUser getUser(String userName) {
        OipchUser oUser = null;
        Iterator oUsers = this.getUsers();
        while (oUsers.hasNext()) {
            OipchUser oCurUsr = (OipchUser)oUsers.next();
            if (!userName.equals(oCurUsr.getUserName(null))) continue;
            oUser = oCurUsr;
        }
        if (oUser == null && System.getProperty("oracle.knowledgesource.host") == null) {
            OipchSystemCreator oSysCtr = OipchSystemCreator.getCreator();
            oUser = oSysCtr.updateUserAndGroup(this, userName);
        }
        return oUser;
    }

    public Map getDeviceDetails() {
        return this.m_oDeviceDetails;
    }

    public Iterator getPartitionDetails() {
        return this.m_oPartitionDetails.iterator();
    }

    public Iterator getGroups() {
        return this.m_oGroups.iterator();
    }

    void addCPU(OipchCPU oCPU) {
        this.m_oCPUDetails.add(oCPU);
    }

    void addDevice(OipchDevice oDev) {
        this.m_oDeviceDetails.put(oDev.getName(), oDev);
    }

    void addPartition(OipchPartition oPartition) {
        this.m_oPartitionDetails.add(oPartition);
    }

    void addUser(OipchUser oUser) {
        this.m_oUsers.add(oUser);
    }

    void addGroup(OipchGroup oGroup) {
        this.m_oGroups.add(oGroup);
    }

    public OipchEnvironmentDetails getEnvironmentDetails() {
        return this.m_oEnvDetails;
    }

    void setEnvironmentDetails(OipchEnvironmentDetails oEnvDetails) {
        this.m_oEnvDetails = oEnvDetails;
    }

    public String getDefaultRunlevel() {
        return this.m_sDefaultRunlevel;
    }

    public boolean setDefaultRunlevel(String defaultRunlevel) {
        if (this.verifyRunlevelString(defaultRunlevel)) {
            this.m_sDefaultRunlevel = defaultRunlevel;
            return true;
        }
        return false;
    }

    public String getCurrentRunlevel() {
        return this.m_sCurrentRunlevel;
    }

    public boolean setCurrentRunlevel(String currentRunlevel) {
        if (this.verifyRunlevelString(currentRunlevel)) {
            this.m_sCurrentRunlevel = currentRunlevel;
            return true;
        }
        return false;
    }

    public boolean areRunlevelsInitialized() {
        return this.isRunlevelInitialized(this.m_sCurrentRunlevel) || this.isRunlevelInitialized(this.m_sDefaultRunlevel);
    }

    public boolean isRunlevelInitialized(String runlevel) {
        return !runlevel.substring(0, Math.min(runlevel.length(), 2)).equals("-1");
    }

    private boolean verifyRunlevelString(String runlevel) {
        StringTokenizer st = new StringTokenizer(runlevel, ",");
        if (runlevel == null || runlevel.equals("")) {
            return false;
        }
        try {
            while (st.hasMoreTokens()) {
                int number = Integer.parseInt(st.nextToken());
                if (number >= -1 || number <= 8) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public OipchShell getShell(String shellName) {
        return (OipchShell)this.m_oShellDetails.get(shellName);
    }

    void addShell(String shellName, OipchShell oShell) {
        if (this.m_oShellDetails == null) {
            this.m_oShellDetails = new HashMap();
        }
        this.m_oShellDetails.put(shellName, oShell);
    }
}

