/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIComparable;
import oracle.sysman.oip.oipc.oipch.OipchICompatComparable;
import oracle.sysman.oip.oipc.oipch.OipchIDisplayable;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

public class OipchSolarisPackageVersion
implements OipchIDisplayable,
OipchIComparable,
OipchICompatComparable {
    private OipchVersion m_oVersion = null;
    private OipchVersion m_oRevision = null;

    OipchSolarisPackageVersion(OipchVersion version, OipchVersion rev) {
        this.m_oVersion = version;
        this.m_oRevision = rev;
    }

    OipchSolarisPackageVersion(String version, String rev) {
        this.m_oVersion = new OipchVersion(version);
        if (rev != null) {
            this.m_oRevision = new OipchVersion(rev);
        }
    }

    OipchVersion getVersion() {
        return this.m_oVersion;
    }

    OipchVersion getRevision() {
        return this.m_oRevision;
    }

    @Override
    public String getDisplayName() {
        if (this.m_oRevision != null) {
            Object[] args = new String[]{this.m_oVersion.getVersion(), this.m_oRevision.getVersion()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OIPCH0001", (Object[])args);
        }
        return this.m_oVersion.getVersion();
    }

    public boolean equals(Object obj) {
        return this.compare(obj) == 1;
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (other == this) {
                iResult = 1;
            } else if (other instanceof OipchSolarisPackageVersion) {
                OipchSolarisPackageVersion spv = (OipchSolarisPackageVersion)other;
                int iCompare = this.m_oVersion.compare((Object)spv.getVersion());
                if (iCompare == 1) {
                    OipchVersion rev = spv.getRevision();
                    iResult = this.m_oRevision != null && rev != null ? this.m_oRevision.compare((Object)rev) : 1;
                } else {
                    iResult = 8;
                }
            }
        }
        return iResult;
    }

    @Override
    public boolean isCompatible(Object other) {
        int iCompare = this.compare(other);
        return iCompare == 1 || iCompare == 4;
    }

    @Override
    public void setParameter(String sParam) {
        this.m_oVersion.setParameter(sParam);
    }
}

