/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIHasKernel;
import oracle.sysman.oip.oipc.oipch.OipchIHasPackages;
import oracle.sysman.oip.oipc.oipch.OipchIHasPatches;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPatchFormatException;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSReader;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchRefHostReader;
import oracle.sysman.oip.oipc.oipch.OipchRunCommand;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPatch;
import oracle.sysman.oip.oipc.oipch.OipchSolarisVersion;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVerKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipchSolarisOSReader
extends OipchOSReader {
    private OipchSolarisOS m_oSolarisOS = null;

    protected OipchSolarisOSReader(Node oNode, int iPlatID) {
        super(oNode, iPlatID);
    }

    @Override
    protected OipchOS createOS() throws OixdInvalidDocumentException {
        this.m_oSolarisOS = new OipchSolarisOS();
        this.m_oSolarisOS.setPlatformID(this.m_iPlatID);
        NodeList oOSNodes = this.m_oNode.getChildNodes();
        if (oOSNodes != null) {
            int nOSNodes = oOSNodes.getLength();
            Node oAttrib = null;
            NamedNodeMap oOSNodeAttribs = null;
            for (int i = 0; i < nOSNodes; ++i) {
                Object[] args;
                Node oOSNode = oOSNodes.item(i);
                if (oOSNode.getNodeType() != 1) continue;
                if (oOSNode.getNodeName().equalsIgnoreCase("VERSION")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VERSION", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    OipchVersion ver = new OipchVersion(oAttrib.getNodeValue());
                    this.m_oSolarisOS.setOSVersion(ver);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("VENDOR")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VENDOR", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    OipchVendor vendor = new OipchVendor(oAttrib.getNodeValue());
                    this.m_oSolarisOS.setOSVendor(vendor);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("UPDATE_VERSION")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"UPDATE_VERSION", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    String updateVersion = oAttrib.getNodeValue();
                    this.m_oSolarisOS.setOSUpdateVersion(updateVersion);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("NAME")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"NAME", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oSolarisOS.setOSName(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("ARCHITECTURE")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"ARCHITECTURE", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oSolarisOS.setOSArch(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("PACKAGES")) {
                    this.addPackageDetails(this.m_oSolarisOS, oOSNode);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("PATCHES")) {
                    this.addPatchDetails(this.m_oSolarisOS, oOSNode);
                    continue;
                }
                if (!oOSNode.getNodeName().equalsIgnoreCase("KERNEL") || Boolean.getBoolean(OipchRefHostReader.S_IF_REFHOST)) continue;
                NodeList oKernelProps = oOSNode.getChildNodes();
                this.addKernelDetails(this.m_oSolarisOS, oKernelProps);
            }
        }
        return this.m_oSolarisOS;
    }

    private void addPatchDetails(OipchIHasPatches oOS, Node oPatches) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oPatches.getAttributes();
        Node oAttrib = oNodeAttribs.getNamedItem("VALUE");
        if (oAttrib != null) {
            String sPatches = oAttrib.getNodeValue();
            String[] asPatches = OiixFunctionOps.explodeString((String)sPatches, (String)",");
            for (int i = 0; i < asPatches.length; ++i) {
                try {
                    OipchSolarisPatch oPatch = new OipchSolarisPatch(asPatches[i]);
                    oOS.addPatch(oPatch);
                    continue;
                }
                catch (OipchIncorrectPatchFormatException e) {
                    throw new OixdInvalidDocumentException((Throwable)((Object)e));
                }
            }
        } else {
            NodeList oPatchesNodeList = oPatches.getChildNodes();
            int nPatches = oPatchesNodeList.getLength();
            HashMap oPatchesEncountered = new HashMap();
            HashMap oPackagesPatched = new HashMap();
            OipchSolarisPatch oPatch = null;
            for (int j = 0; j < nPatches; ++j) {
                OipchSolarisPatch patch;
                int i;
                List oPatchesList;
                Node oPatchNode = oPatchesNodeList.item(j);
                if (oPatchNode.getNodeType() != 1 || !oPatchNode.getNodeName().equalsIgnoreCase("PATCH") || (oNodeAttribs = oPatchNode.getAttributes()) == null) continue;
                oAttrib = oNodeAttribs.getNamedItem("VERSION");
                if (oAttrib == null) {
                    Object[] args = new String[]{"VERSION"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                try {
                    oPatch = new OipchSolarisPatch(oAttrib.getNodeValue());
                }
                catch (OipchIncorrectPatchFormatException e) {
                    throw new OixdInvalidDocumentException((Throwable)((Object)e));
                }
                oAttrib = oNodeAttribs.getNamedItem("OBSOLETES");
                if (oAttrib != null) {
                    try {
                        oPatchesList = this.parsePatches(oPatchesEncountered, oAttrib.getNodeValue());
                        for (i = 0; i < oPatchesList.size(); ++i) {
                            patch = (OipchSolarisPatch)oPatchesList.get(i);
                            oPatch.addObsoletePatch(patch);
                        }
                    }
                    catch (OipchIncorrectPatchFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if ((oAttrib = oNodeAttribs.getNamedItem("REQUIRES")) != null) {
                    try {
                        oPatchesList = this.parsePatches(oPatchesEncountered, oAttrib.getNodeValue());
                        for (i = 0; i < oPatchesList.size(); ++i) {
                            patch = (OipchSolarisPatch)oPatchesList.get(i);
                            oPatch.addRequiredPatch(patch);
                        }
                    }
                    catch (OipchIncorrectPatchFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if ((oAttrib = oNodeAttribs.getNamedItem("INCOMPAT")) != null) {
                    try {
                        oPatchesList = this.parsePatches(oPatchesEncountered, oAttrib.getNodeValue());
                        for (i = 0; i < oPatchesList.size(); ++i) {
                            patch = (OipchSolarisPatch)oPatchesList.get(i);
                            oPatch.addIncompatiblePatch(patch);
                        }
                    }
                    catch (OipchIncorrectPatchFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if ((oAttrib = oNodeAttribs.getNamedItem("PACKAGES")) != null) {
                    StringTokenizer st = new StringTokenizer(oAttrib.getNodeValue(), ",", false);
                    while (st.hasMoreTokens()) {
                        String pkg = st.nextToken();
                        oPatch.addPackage(pkg);
                    }
                }
                oOS.addPatch(oPatch);
            }
        }
    }

    private List parsePatches(HashMap oPatchesEncountered, String sPatches) throws OipchIncorrectPatchFormatException {
        ArrayList<OipchSolarisPatch> oPatches = new ArrayList<OipchSolarisPatch>();
        StringTokenizer st = new StringTokenizer(sPatches, ",", false);
        while (st.hasMoreTokens()) {
            String sPatch = st.nextToken();
            OipchSolarisPatch patch = (OipchSolarisPatch)oPatchesEncountered.get(sPatch);
            if (patch == null) {
                try {
                    patch = new OipchSolarisPatch(sPatch);
                }
                catch (OipchIncorrectPatchFormatException e) {
                    OiixAssert.assertion((boolean)true, (String)e.getMessage());
                }
                oPatchesEncountered.put(sPatch, patch);
            }
            oPatches.add(patch);
        }
        return oPatches;
    }

    private void addPackageDetails(OipchIHasPackages oOS, Node oPackages) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oPackages.getAttributes();
        Node oAttrib = oNodeAttribs.getNamedItem("VALUE");
        if (oAttrib != null) {
            String sPkgs = oAttrib.getNodeValue();
            String[] asPkgs = OiixFunctionOps.explodeString((String)sPkgs, (String)",");
            for (int i = 0; i < asPkgs.length; ++i) {
                OipchPackage oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                oPkg.setName(asPkgs[i]);
                oOS.addPackage(oPkg);
            }
        } else {
            NodeList oPackagesNodeList = oPackages.getChildNodes();
            int nPackages = oPackagesNodeList.getLength();
            for (int j = 0; j < nPackages; ++j) {
                Node oPkgNode = oPackagesNodeList.item(j);
                oAttrib = null;
                if (oPkgNode.getNodeType() != 1 || !oPkgNode.getNodeName().equalsIgnoreCase("PACKAGE") || (oNodeAttribs = oPkgNode.getAttributes()) == null) continue;
                OipchPackage oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                for (int i = 0; i < oNodeAttribs.getLength(); ++i) {
                    oAttrib = oNodeAttribs.item(i);
                    if (oAttrib.getNodeName().equals("VAR")) {
                        if (oAttrib.getNodeValue().indexOf("%") != -1) {
                            String[] kernelVer = new String[1];
                            try {
                                kernelVer = OipchRunCommand.runLocalUnixCommand("uname -r");
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                kernelVer[0] = "";
                            }
                            String verToAppend = kernelVer[0];
                            String[] arg = new String[1];
                            String[] arg1 = new String[1];
                            arg[0] = new String("%KERNEL_RELEASE%");
                            verToAppend = verToAppend.trim();
                            arg1[0] = new String(verToAppend);
                            String tempPkgName = null;
                            tempPkgName = OiixInstantiateString.processString((String)oAttrib.getNodeValue(), (String[])arg, (String[])arg1);
                            try {
                                oPkg.setProperty(oAttrib.getNodeName(), tempPkgName);
                                continue;
                            }
                            catch (OipchIncorrectPackageFormatException e) {
                                throw new OixdInvalidDocumentException((Throwable)((Object)e));
                            }
                        }
                        try {
                            oPkg.setProperty(oAttrib.getNodeName(), oAttrib.getNodeValue());
                            continue;
                        }
                        catch (OipchIncorrectPackageFormatException e) {
                            throw new OixdInvalidDocumentException((Throwable)((Object)e));
                        }
                    }
                    try {
                        oPkg.setProperty(oAttrib.getNodeName(), oAttrib.getNodeValue());
                        continue;
                    }
                    catch (OipchIncorrectPackageFormatException e) {
                        throw new OixdInvalidDocumentException((Throwable)((Object)e));
                    }
                }
                if (oPkg.getName() == null) {
                    Object[] args = new String[]{"NAME", "VALUE"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                oOS.addPackage(oPkg);
            }
        }
    }

    private void addKernelDetails(OipchIHasKernel oOS, NodeList oKernelProps) throws OixdInvalidDocumentException {
        OipchKernelInfo oKernelInfo = oOS.getKernel();
        int nKernelProps = oKernelProps.getLength();
        for (int i = 0; i < nKernelProps; ++i) {
            Object[] args;
            Node oKernelPropNode = oKernelProps.item(i);
            String sName = null;
            String sValue = null;
            if (oKernelPropNode.getNodeType() != 1 || !oKernelPropNode.getNodeName().equals("PROPERTY")) continue;
            NamedNodeMap oNodeAttribs = oKernelPropNode.getAttributes();
            OipchKernelProperty oKernelProp = null;
            int nNodeAttribs = oNodeAttribs.getLength();
            Node oAttrib = oNodeAttribs.getNamedItem("NAME");
            if (oAttrib == null) {
                args = new String[]{"PROPERTY", "NAME"};
                throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
            }
            sName = oAttrib.getNodeValue();
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            if (oAttrib == null) {
                args = new String[]{"PROPERTY", "VALUE"};
                throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
            }
            sValue = oAttrib.getNodeValue();
            if (sName.equals("VERSION")) {
                try {
                    OipchSolarisVersion oVer = new OipchSolarisVersion(sValue);
                    oKernelProp = new OipchVerKernelProperty(sName, oVer);
                }
                catch (OipchIncorrectVersionFormatException e) {
                    throw new OixdInvalidDocumentException((Throwable)((Object)e));
                }
            }
            try {
                Long lValue = new Long(sValue);
                oKernelProp = new OipchNumKernelProperty(sName, lValue);
            }
            catch (NumberFormatException e) {
                oKernelProp = new OipchStrKernelProperty(sName, sValue);
            }
            oKernelInfo.addProperty(oKernelProp);
        }
    }
}

