/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchPatch;
import oracle.sysman.oip.oipc.oipch.OipchSolarisKernelReader;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPatchReader;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

class OipchSolarisOSCreator
extends OipchOSCreator {
    private static final String OSINFO_FILE = "osinfo.txt";
    private static final String OSINFO_FILE2 = "osupdateinfo.txt";
    private static final String OSINFO_SCRIPT = "cat /etc/release | grep _u. | cut -d'_' -f2";
    private static final String PKGINFO_FILE = "pkginfo.txt";
    private static final String PKGINFO_DETAIL_SCRIPT = "pkginfo -x | cut -f1 -d' ' | xargs pkginfo -l";
    private static final String PKGINFO_SCRIPT = "pkginfo";
    private static final String PKGINFO_TYPE_PROPERTY = "oracle.installer.solaris.package";
    private static final String PKGINFO_TYPE_DETAILED = "detailed";
    private static final String PATCHINFO_FILE = "patchinfo.txt";
    private static final String PATCHINFO_SCRIPT = "showrev -p";
    private static final String PATCHINFO_SCRIPT_INTEL_SOLARIS = "/usr/sbin/patchadd -p";
    private static final String KERNELINFO_FILE = "/etc/system";
    private static final String KERNELINFO_FILE2 = "isainfo.txt";
    private static final String KERNELINFO_SCRIPT2 = "isainfo -b";
    private static final String KERNELINFO_FILE3 = "kernelarchver.txt";
    private static final String KERNELINFO_SCRIPT3_1 = "uname -m";
    private static final String KERNELINFO_SCRIPT3_2 = "uname -s -r -v";
    private static final String KERNELINFO_FILE4 = "sysdef.txt";
    private static final String KERNELINFO_SCRIPT4 = "/usr/sbin/sysdef";
    private OipchSolarisOS m_oSolarisOS;

    protected OipchSolarisOSCreator(int iPlatID) {
        super(iPlatID);
    }

    @Override
    protected OipchOS createOS() {
        this.m_oSolarisOS = new OipchSolarisOS();
        this.updateOSInfo(this.m_oSolarisOS);
        this.updateKernelInfo();
        this.updateKernelInfo2();
        this.updateKernelInfo3();
        this.updateKernelInfo4();
        this.updatePackageInfo();
        this.updatePatchInfo();
        return this.m_oSolarisOS;
    }

    private void updateOSInfo(OipchSolarisOS m_oSolarisOS) {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)OSINFO_FILE2);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            super.updateOSInfo(m_oSolarisOS);
            String sCommand = "cat /etc/release | grep _u. | cut -d'_' -f2>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                return;
            }
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(oFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String updateVersion = null;
        try {
            updateVersion = in.readLine();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            in.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        m_oSolarisOS.setOSUpdateVersion(updateVersion);
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateKernelInfo() {
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.readKernelInfo(KERNELINFO_FILE);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateKernelInfo2() {
        Object sCommand;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE2);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            sCommand = "isainfo -b>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                return;
            }
        }
        OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
        try {
            oOSKernelInfo.addProperty(OipchSolarisKernelReader.getKernelBitSize(sFile));
            sCommand = oOSKernelInfo.getProperty("BIT_SIZE");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateKernelInfo3() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE3);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand1 = "uname -m>" + sFile;
            String sCommand2 = "uname -s -r -v>>" + sFile;
            int result1 = 0;
            int result2 = 0;
            try {
                result1 = OiipuUnixOps.sysFunctionEnglish((String)sCommand1);
                result2 = OiipuUnixOps.sysFunctionEnglish((String)sCommand2);
            }
            catch (OiilNativeException oiilNativeException) {
                // empty catch block
            }
            if (result1 != 0 || result2 != 0) {
                return;
            }
        }
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.getKernelArchVerInfo(sFile);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException oKernelInfo) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateKernelInfo4() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE4);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "/usr/sbin/sysdef>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                return;
            }
        }
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.readSysdefKernelInfo(sFile);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException oKernelInfo) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePackageInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PKGINFO_FILE);
        File oFile = new File(sFile);
        boolean bDetailedPkgInfo = System.getProperty(PKGINFO_TYPE_PROPERTY, "").equalsIgnoreCase(PKGINFO_TYPE_DETAILED);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = bDetailedPkgInfo ? "pkginfo -x | cut -f1 -d' ' | xargs pkginfo -l>" + sFile : "pkginfo>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException oiilNativeException) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        try {
            Collection oPackages = null;
            oPackages = bDetailedPkgInfo ? OipchSolarisPackageReader.readAllPackageDetails(sFile) : OipchSolarisPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                this.m_oSolarisOS.addPackage((OipchPackage)iter.next());
            }
        }
        catch (IOException oPackages) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePatchInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PATCHINFO_FILE);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            boolean doPatchesExistInVersion;
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            int iPlat = OiixPlatform.getCurrentPlatform();
            OipchVersion actualVer = this.m_oSolarisOS.getOSVersion();
            OipchVersion testVer = new OipchVersion("5.11");
            String sCommand = null;
            boolean bl = doPatchesExistInVersion = testVer.compare((Object)actualVer) == 4;
            if (iPlat == 453 && doPatchesExistInVersion) {
                sCommand = "showrev -p>" + sFile;
            } else if (iPlat == 173 && doPatchesExistInVersion) {
                sCommand = "/usr/sbin/patchadd -p>" + sFile;
            } else {
                return;
            }
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException oiilNativeException) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        try {
            Collection oPatches = null;
            oPatches = OipchSolarisPatchReader.readPatchDetails(sFile);
            Iterator iter = oPatches.iterator();
            while (iter.hasNext()) {
                this.m_oSolarisOS.addPatch((OipchPatch)iter.next());
            }
        }
        catch (IOException oPatches) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

