/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSReader;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchRefHostBuilder;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchSystemReader;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class OipchRefHostReader
extends OipchRefHostBuilder {
    protected OipchSystemReader m_oSystemReader;
    private OipchOSReader m_oOSReader;
    private String m_sFileName;
    protected static String S_IF_REFHOST = "oracle.installer.ifrefhost";

    OipchRefHostReader(String sFile) {
        this.m_sFileName = sFile;
    }

    @Override
    public Object build() throws OipckKnowledgeSourceException {
        try {
            Document oDoc = OixdDOMReader.getDocument((String)this.m_sFileName);
            OipchRefHost refhost = this.build(oDoc, this.m_sFileName);
            return refhost;
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11001", (Object[])args), (Throwable)e);
        }
        catch (SAXException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11002", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11002", (Object[])args), (Throwable)e);
        }
        catch (OixdInvalidDocumentException e) {
            String[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11003", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11003", (Object[])args), (Throwable)e);
        }
    }

    private OipchRefHost build(Document oDoc, String sFileName) throws OixdInvalidDocumentException {
        OipchRefHost refhost = null;
        if (oDoc != null) {
            String sPlatID;
            Element root = oDoc.getDocumentElement();
            if (!root.getTagName().equalsIgnoreCase("HOST")) {
                Object[] args = new String[]{sFileName};
                throw new OixdInvalidDocumentException("OUI-11021", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11021", (Object[])args));
            }
            refhost = new OipchRefHost();
            NodeList oHostDetailNodes = root.getChildNodes();
            Node oAttrib = null;
            NamedNodeMap oHostDetailAttributes = root.getAttributes();
            oAttrib = oHostDetailAttributes.getNamedItem("PLATID");
            int iPlatID = OiixPlatform.getCurrentPlatform();
            if (oAttrib != null && (sPlatID = oAttrib.getNodeValue()) != null) {
                iPlatID = Integer.parseInt(sPlatID);
            }
            String sIfRefhost = System.getProperty(S_IF_REFHOST);
            System.setProperty(S_IF_REFHOST, "true");
            if (oHostDetailNodes != null) {
                int nHostDetailNodes = oHostDetailNodes.getLength();
                for (int i = 0; i < nHostDetailNodes; ++i) {
                    Node oHostDetailNode = oHostDetailNodes.item(i);
                    if (oHostDetailNode.getNodeType() != 1) continue;
                    if (oHostDetailNode.getNodeName().equalsIgnoreCase("SYSTEM")) {
                        OipchSystemReader oSystemRdr = OipchSystemReader.getReader(oHostDetailNode, iPlatID);
                        OipchSystem oSystem = oSystemRdr.createSystem();
                        refhost.setSystem(oSystem);
                        continue;
                    }
                    if (!oHostDetailNode.getNodeName().equalsIgnoreCase("CERTIFIED_SYSTEMS")) continue;
                    NodeList oOSList = oHostDetailNode.getChildNodes();
                    int nCnt = oOSList.getLength();
                    for (int j = 0; j < nCnt; ++j) {
                        Node oOSNode = oOSList.item(j);
                        if (oOSNode.getNodeType() != 1 || !oOSNode.getNodeName().equalsIgnoreCase("OPERATING_SYSTEM")) continue;
                        OipchOSReader oOSRdr = OipchOSReader.getReader(oOSNode, iPlatID);
                        OipchOS oOS = oOSRdr.createOS();
                        refhost.addOS(oOS);
                    }
                }
            }
            if (sIfRefhost != null) {
                System.setProperty(S_IF_REFHOST, sIfRefhost);
            } else {
                System.setProperty(S_IF_REFHOST, "false");
            }
        }
        return refhost;
    }
}

