/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oip.oipc.oipch.OipchAIXOSReader;
import oracle.sysman.oip.oipc.oipch.OipchDECOSReader;
import oracle.sysman.oip.oipc.oipch.OipchHPOSReader;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSReader;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOSReader;
import oracle.sysman.oip.oipc.oipch.OipchWindowsOSReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Node;

abstract class OipchOSReader {
    private OipchOS m_oOS = null;
    protected int m_iPlatID = 0;
    protected Node m_oNode = null;

    final OipchOS getOS() throws OixdInvalidDocumentException {
        if (this.m_oOS == null) {
            this.m_oOS = this.createOS();
        }
        return this.m_oOS;
    }

    protected abstract OipchOS createOS() throws OixdInvalidDocumentException;

    protected OipchOSReader(Node oNode, int iPlatID) {
        this.m_oNode = oNode;
        this.m_iPlatID = iPlatID;
    }

    static OipchOSReader getReader(Node oNode, int iPlat) {
        OipchOSReader oOSReader = null;
        switch (iPlat) {
            case 173: 
            case 453: {
                oOSReader = new OipchSolarisOSReader(oNode, iPlat);
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oOSReader = new OipchWindowsOSReader(oNode, iPlat);
                break;
            }
            case 2: 
            case 197: {
                oOSReader = new OipchHPOSReader(oNode, iPlat);
                break;
            }
            case 46: 
            case 110: 
            case 211: 
            case 227: 
            case 525: {
                oOSReader = new OipchLinuxOSReader(oNode, iPlat);
                break;
            }
            case 610: {
                oOSReader = new OipchAIXOSReader(oNode, iPlat);
                break;
            }
            case 87: {
                oOSReader = new OipchDECOSReader(oNode, iPlat);
            }
        }
        return oOSReader;
    }
}

