/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

public class OipchLinuxVersion
extends OipchVersion {
    private String m_sEpoch = null;
    private String m_sRelease = null;
    protected static final int EPOCH_IDX = 0;
    protected static final int VERSION_IDX = 1;
    protected static final int RELEASE_IDX = 2;
    private static final int MAX_VERSION_PARTS = 3;
    public static final String EPOCH_SEPARATOR = ":";
    public static final String RELEASE_SEPARATOR = "-";
    public static final String NO_EPOCH = "(none)";

    public OipchLinuxVersion(String sVer) throws OipchIncorrectVersionFormatException {
        super(sVer);
        String[] asVersionParts = this.getVersionParts(sVer);
        if (asVersionParts[1] == null || asVersionParts[1].length() <= 0) {
            throw new OipchIncorrectVersionFormatException("OUI-11034", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11034"));
        }
        this.m_sEpoch = asVersionParts[0];
        super.setVersion(asVersionParts[1]);
        this.m_sRelease = asVersionParts[2];
    }

    public OipchLinuxVersion(String epoch, String sVer, String release) throws OipchIncorrectVersionFormatException {
        super(sVer);
        if (sVer == null || sVer.length() == 0) {
            throw new OipchIncorrectVersionFormatException("OUI-11034", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11034"));
        }
        this.m_sEpoch = epoch;
        this.m_sRelease = release;
    }

    @Override
    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (this == other) {
                iResult = 1;
            } else {
                if (!(other instanceof OipchLinuxVersion)) {
                    iResult = 8;
                    return iResult;
                }
                OipchLinuxVersion oOtherVer = (OipchLinuxVersion)other;
                iResult = this.compare(oOtherVer);
            }
        }
        return iResult;
    }

    public int compare(OipchLinuxVersion other) {
        int iResult = 8;
        String sOtherEpoch = other.getEpoch();
        String sOtherVersion = other.getVersion();
        String sOtherRelease = other.getRelease();
        if (this.getDisplayName().equals(other.getDisplayName())) {
            return 1;
        }
        if (this.m_sEpoch != null && this.m_sEpoch.length() > 0 && sOtherEpoch == null) {
            iResult = 4;
        } else if (this.m_sEpoch == null && sOtherEpoch != null && sOtherEpoch.length() > 0) {
            iResult = 2;
        } else if (this.m_sEpoch != null && sOtherEpoch != null) {
            int i = this.m_sEpoch.compareTo(sOtherEpoch);
            iResult = i > 0 ? 4 : (i < 0 ? 2 : 1);
        }
        if (!(iResult != 1 && iResult != 8 || (iResult = this.versionCompare(this.getVersion(), sOtherVersion)) != 1 || this.m_sRelease == null && sOtherRelease == null)) {
            iResult = this.versionCompare(this.m_sRelease, sOtherRelease);
        }
        return iResult;
    }

    private int versionCompare(String s1, String s2) {
        int result = 0;
        boolean isRelNull = false;
        if (s1 == null || s2 == null) {
            isRelNull = true;
        }
        if (!isRelNull && s1.compareTo(s2) == 0) {
            return 1;
        }
        if (isRelNull) {
            if (s1 == null) {
                return 2;
            }
            return 4;
        }
        int start1 = 0;
        int start2 = 0;
        int length1 = s1.length();
        int length2 = s2.length();
        while (start1 != -1 && start2 != -1) {
            boolean isNum;
            int end1;
            while (start1 != -1 && !Character.isLetterOrDigit(s1.charAt(start1))) {
                if (start1 == length1 - 1) {
                    start1 = -1;
                    continue;
                }
                ++start1;
            }
            while (start2 != -1 && !Character.isLetterOrDigit(s2.charAt(start2))) {
                if (start2 == length2 - 1) {
                    start2 = -1;
                    continue;
                }
                ++start2;
            }
            if (start1 == -1 && start2 != -1) {
                return 2;
            }
            if (start1 != -1 && start2 == -1) {
                return 4;
            }
            int end2 = start2;
            if (start1 != -1 && Character.isDigit(s1.charAt(start1))) {
                for (end1 = start1; end1 < length1 && Character.isDigit(s1.charAt(end1)); ++end1) {
                }
                while (end2 < length2 && Character.isDigit(s2.charAt(end2))) {
                    ++end2;
                }
                isNum = true;
            } else {
                while (end1 < length1 && Character.isLetter(s1.charAt(end1))) {
                    ++end1;
                }
                while (end2 < length2 && Character.isLetter(s2.charAt(end2))) {
                    ++end2;
                }
                isNum = false;
            }
            String segment1 = start1 == end1 ? null : s1.substring(start1, end1);
            String segment2 = start2 == end2 ? null : s2.substring(start2, end2);
            start1 = end1 >= length1 ? -1 : end1;
            start2 = end2 >= length2 ? -1 : end2;
            if (segment1 == null) {
                return 2;
            }
            if (segment2 == null) {
                return isNum ? 4 : 2;
            }
            boolean zeroSegment = false;
            if (isNum) {
                boolean zerosRemoved1 = false;
                boolean zerosRemoved2 = false;
                end2 = 0;
                for (end1 = 0; end1 < segment1.length() && segment1.charAt(end1) == '0'; ++end1) {
                    zerosRemoved1 = true;
                }
                while (end2 < segment2.length() && segment2.charAt(end2) == '0') {
                    ++end2;
                    zerosRemoved2 = true;
                }
                if (zerosRemoved1) {
                    segment1 = end1 >= segment1.length() ? null : segment1.substring(end1);
                }
                if (zerosRemoved2) {
                    segment2 = end2 >= segment2.length() ? null : segment2.substring(end2);
                }
                if (segment1 == null && segment2 == null) {
                    zeroSegment = true;
                }
                if (segment1 == null && segment2 != null) {
                    return 2;
                }
                if (segment1 != null && segment2 == null) {
                    return 4;
                }
                if (!zeroSegment) {
                    if (segment1.length() > segment2.length()) {
                        return 4;
                    }
                    if (segment2.length() > segment1.length()) {
                        return 2;
                    }
                }
            }
            if (!zeroSegment) {
                result = segment1.compareTo(segment2);
            }
            if (zeroSegment) {
                result = 0;
            }
            if (result > 0) {
                return 4;
            }
            if (result >= 0) continue;
            return 2;
        }
        if (start1 == -1 && start2 == -1) {
            return 1;
        }
        if (start1 == -1) {
            return 2;
        }
        return 4;
    }

    public String getEpoch() {
        return this.m_sEpoch;
    }

    public String getRelease() {
        return this.m_sRelease;
    }

    @Override
    public String getDisplayName() {
        boolean bAddRelease;
        String sDisplayName = "";
        String sVersion = this.getVersion();
        boolean bAddEpoch = this.m_sEpoch != null && this.m_sEpoch.length() > 0;
        boolean bAddVersion = sVersion != null && sVersion.length() > 0;
        boolean bl = bAddRelease = this.m_sRelease != null && this.m_sRelease.length() > 0;
        if (bAddVersion) {
            if (bAddEpoch) {
                sDisplayName = sDisplayName + this.m_sEpoch + EPOCH_SEPARATOR;
            }
            sDisplayName = sDisplayName + sVersion;
            if (bAddRelease) {
                sDisplayName = sDisplayName + RELEASE_SEPARATOR + this.m_sRelease;
            }
        }
        return sDisplayName;
    }

    protected String[] getVersionParts(String version) {
        String[] asVersionParts = new String[3];
        int iVerIdx = version.lastIndexOf(EPOCH_SEPARATOR);
        String string = asVersionParts[0] = iVerIdx != -1 ? version.substring(0, iVerIdx) : null;
        if (asVersionParts[0] != null && asVersionParts[0].equalsIgnoreCase(NO_EPOCH)) {
            asVersionParts[0] = null;
        }
        String shortVersion = iVerIdx != -1 ? version.substring(iVerIdx + 1) : version;
        int iRelIdx = shortVersion.indexOf(RELEASE_SEPARATOR);
        asVersionParts[2] = iRelIdx != -1 ? shortVersion.substring(iRelIdx + 1) : null;
        asVersionParts[1] = iRelIdx != -1 ? shortVersion.substring(0, iRelIdx) : shortVersion;
        return asVersionParts;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    protected void setEpoch(String sEpoch) {
        this.m_sEpoch = sEpoch;
    }

    protected void setRelease(String sRelease) {
        this.m_sRelease = sRelease;
    }
}

