/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.Codecs;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ntlm.NtlmCore;
import HTTPClient.ntlm.NtlmSupportFlags;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NtlmType2Message {
    private static Logger logger = HttpClientLoggerFactory.getLogger(NtlmType2Message.class.getName());
    private NtlmSupportFlags flags = null;
    private byte[] nonce = null;

    public NtlmType2Message(NtlmSupportFlags flags, byte[] nonce) throws IllegalArgumentException {
        if (null == flags) {
            throw new IllegalArgumentException("Non-null NtlmSupportFlags object expected.");
        }
        if (null == nonce || nonce.length != 8) {
            throw new IllegalArgumentException("Nonce is null or not 8 bytes long.");
        }
        this.flags = flags;
        this.nonce = nonce;
    }

    public NtlmSupportFlags getFlags() {
        return this.flags;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public String formatType2Message() {
        int INITIAL_FORMAT_BUFFER_SIZE = 64;
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(64);
        DataOutputStream dataOS = new DataOutputStream(baOS);
        String output = "";
        try {
            dataOS.write(NtlmCore.NTLMSSP_BYTES);
            dataOS.writeByte(0);
            dataOS.writeByte(2);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeShort(0);
            dataOS.writeShort(0);
            dataOS.writeInt(0);
            dataOS.write(this.flags.getNtlmBytes());
            dataOS.write(this.nonce);
            dataOS.flush();
            byte[] outputBytes = baOS.toByteArray();
            byte[] encodedOutputBytes = Codecs.base64Encode(outputBytes);
            output = new String(encodedOutputBytes, "US-ASCII");
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Trying to format an NTLM Type 2 message.", e);
        }
        return output;
    }
}

