/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.HttpClientLoggerFactory;
import java.util.logging.Logger;

public final class NtlmSupportFlags {
    private static Logger logger = HttpClientLoggerFactory.getLogger(NtlmSupportFlags.class.getName());
    private int flagData = 0;

    public NtlmSupportFlags(int initialFlags) {
        this.replaceFlags(initialFlags);
    }

    public NtlmSupportFlags(byte[] initialNtlmFlags) throws IllegalArgumentException {
        this.replaceFlags(initialNtlmFlags);
    }

    public int getFlags() {
        return this.flagData;
    }

    public boolean anyFlagsOn(int flagMask) {
        return (flagMask & this.flagData) > 0;
    }

    public int replaceFlags(int newFlags) {
        int oldFlags = this.flagData;
        this.flagData = newFlags;
        return oldFlags;
    }

    public int replaceFlags(byte[] newNtlmFlags) throws IllegalArgumentException {
        if (null == newNtlmFlags || newNtlmFlags.length != 4) {
            throw new IllegalArgumentException("Given flag array was null or not exactly 4 bytes.");
        }
        int newFlags = 0;
        newFlags |= newNtlmFlags[3] << 24 & 0xFF000000;
        newFlags |= newNtlmFlags[2] << 16 & 0xFF0000;
        newFlags |= newNtlmFlags[1] << 8 & 0xFF00;
        return this.replaceFlags(newFlags |= newNtlmFlags[0] & 0xFF);
    }

    public byte[] getNtlmBytes() {
        byte byte3 = (byte)(this.flagData >>> 24 & 0xFF);
        byte byte2 = (byte)(this.flagData >>> 16 & 0xFF);
        byte byte1 = (byte)(this.flagData >>> 8 & 0xFF);
        byte byte0 = (byte)(this.flagData & 0xFF);
        byte[] output = new byte[]{byte0, byte1, byte2, byte3};
        return output;
    }

    public int setFlags(int flags) {
        int oldFlags = this.flagData;
        this.flagData = oldFlags | flags;
        return oldFlags;
    }

    public int clearFlags(int flags) {
        int oldFlags = this.flagData;
        this.flagData = oldFlags & ~flags;
        return oldFlags;
    }

    public static interface Flags {
        public static final int NTLM2 = 524288;
        public static final int ALWAYS_SIGN = 32768;
        public static final int WORKSTATION_SUPPLIED = 8192;
        public static final int DOMAIN_SUPPLIED = 4096;
        public static final int NTLM = 512;
        public static final int OEM_CHARSET = 2;
        public static final int UNICODE_CHARSET = 1;
    }
}

