/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.Codecs;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ntlm.NtlmSupportFlags;
import HTTPClient.ntlm.NtlmType2Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class NtlmCore {
    private static Logger logger = HttpClientLoggerFactory.getLogger(NtlmCore.class.getName());
    public static final String OEM_CHARSET = "ISO-8859-1";
    public static final String UNICODE_CHARSET = "UTF-16LE";
    public static final String ASCII_CHARSET = "US-ASCII";
    static final boolean USE_OEM = true;
    static final boolean SILENTLY = true;
    public static final byte[] NTLMSSP_BYTES = NtlmCore.toNtlmBytes("NTLMSSP", true);
    private static final int INITIAL_FORMAT_BUFFER_SIZE = 1024;
    private static final byte[] MAGIC = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    static final short LM_RESPONSE_LENGTH = 24;
    static final short NTLM_RESPONSE_LENGTH = 24;
    static final short LM_HASH_LENGTH = 16;
    static final short NTLM_HASH_LENGTH = 16;
    public static final String MD4_CLASS_NAME = "com.phaos.crypto.MD4";
    private static Class md4Class = null;
    private static ThreadLocal md4_threadLocal;
    private static boolean isMD4Enabled;

    private static URLClassLoader newPrivilegedURLClassLoader(final URL[] urls) {
        if (null == urls || 0 == urls.length) {
            throw new IllegalArgumentException("Non-null and non-empty URL[] expected.");
        }
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls);
            }
        });
    }

    static boolean loadMd4Class(URL md4Url, boolean silently) throws RuntimeException {
        if (null != md4Class) {
            return true;
        }
        try {
            ClassLoader loader = null;
            loader = null == md4Url ? NtlmCore.class.getClassLoader() : NtlmCore.newPrivilegedURLClassLoader(new URL[]{md4Url});
            if (null == loader) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> c = loader.loadClass(MD4_CLASS_NAME);
            Object o = c.newInstance();
            if (null == md4Class) {
                md4Class = c;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Unable to load or instantiate MD4 class 'com.phaos.crypto.MD4'. NTLM version 1 response is not supported.", e);
            }
            if (!silently) {
                throw new RuntimeException("Unable to load or instantiate com.phaos.crypto.MD4.", e);
            }
            return false;
        }
        return true;
    }

    private static byte[] toNtlmBytes(short input) {
        byte byte1 = (byte)(input >>> 8);
        byte byte0 = (byte)input;
        byte[] output = new byte[]{byte0, byte1};
        return output;
    }

    private static byte[] toNtlmBytes(String input, boolean useOemEncoding) {
        byte[] NULL_OUTPUT;
        byte[] output = NULL_OUTPUT = new byte[0];
        if (null == input || "".equals(input)) {
            return output;
        }
        if (useOemEncoding) {
            try {
                output = input.getBytes(OEM_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINER, "The OEM character set ''ISO-8859-1' is not supported.", e);
            }
        } else {
            try {
                output = input.getBytes(UNICODE_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINER, "The Unicode character set ''UTF-16LE' is not supported.", e);
            }
        }
        return output;
    }

    private static void applyOddParity(byte[] input) {
        if (null == input) {
            throw new IllegalArgumentException("Non-null input expected.");
        }
        for (int i = 0; i < input.length; ++i) {
            boolean needsParity;
            byte inputByte = input[i];
            boolean bl = needsParity = ((inputByte >>> 7 ^ inputByte >>> 6 ^ inputByte >>> 5 ^ inputByte >>> 4 ^ inputByte >>> 3 ^ inputByte >>> 2 ^ inputByte >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                input[n] = (byte)(input[n] | 1);
                continue;
            }
            int n = i;
            input[n] = (byte)(input[n] & 0xFFFFFFFE);
        }
    }

    private static Key generateDESKey(byte[] keySource, int offset) {
        if (null == keySource || keySource.length < 7) {
            throw new IllegalArgumentException("Expected keySource array to be non-null and at least 7 bytes long.");
        }
        if (offset < 0 || offset > keySource.length - 7) {
            throw new IllegalArgumentException("Offset expected to be >= 0 and <= (keySource.length-7): offset=" + offset + ", keySource.length=" + keySource.length + ".");
        }
        byte[] inputBytes = new byte[7];
        System.arraycopy(keySource, offset, inputBytes, 0, 7);
        byte[] keyMaterial = new byte[]{inputBytes[0], (byte)(inputBytes[0] << 7 | (inputBytes[1] & 0xFF) >>> 1), (byte)(inputBytes[1] << 6 | (inputBytes[2] & 0xFF) >>> 2), (byte)(inputBytes[2] << 5 | (inputBytes[3] & 0xFF) >>> 3), (byte)(inputBytes[3] << 4 | (inputBytes[4] & 0xFF) >>> 4), (byte)(inputBytes[4] << 3 | (inputBytes[5] & 0xFF) >>> 5), (byte)(inputBytes[5] << 2 | (inputBytes[6] & 0xFF) >>> 6), (byte)(inputBytes[6] << 1)};
        NtlmCore.applyOddParity(keyMaterial);
        return new SecretKeySpec(keyMaterial, "DES");
    }

    public static byte[] generateLmV1Hash(String password) throws Exception {
        if (null == password) {
            password = "";
        }
        password = password.toUpperCase();
        byte[] passwordBytes = NtlmCore.toNtlmBytes(password, true);
        byte[] fixedPassword = new byte[14];
        int minLength = Math.min(passwordBytes.length, 14);
        System.arraycopy(passwordBytes, 0, fixedPassword, 0, minLength);
        Key lowKey = NtlmCore.generateDESKey(fixedPassword, 0);
        Key highKey = NtlmCore.generateDESKey(fixedPassword, 7);
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, lowKey);
        byte[] lowHash = des.doFinal(MAGIC);
        des.init(1, highKey);
        byte[] highHash = des.doFinal(MAGIC);
        byte[] output = new byte[16];
        System.arraycopy(lowHash, 0, output, 0, 8);
        System.arraycopy(highHash, 0, output, 8, 8);
        return output;
    }

    private static Object getMd4Instance() {
        if (NtlmCore.isMD4Enabled()) {
            return md4_threadLocal.get();
        }
        return null;
    }

    private static byte[] generateMd4Hash(byte[] input) throws Exception {
        if (null == input) {
            throw new IllegalArgumentException("Non-null input expected.");
        }
        Object md4Object = NtlmCore.getMd4Instance();
        if (null == md4Object) {
            throw new IllegalStateException("MD4 is unavailable.");
        }
        Object hashedObject = null;
        try {
            Method initMethod = md4Class.getMethod("init", null);
            if (null == initMethod) {
                throw new IllegalStateException("Expected class 'com.phaos.crypto.MD4' to have method 'public void init()'.");
            }
            initMethod.invoke(md4Object, null);
            Method updateMethod = md4Class.getMethod("update", input.getClass());
            if (null == updateMethod) {
                throw new IllegalStateException("Expected class 'com.phaos.crypto.MD4' to have method 'public void update(byte[] input)'.");
            }
            updateMethod.invoke(md4Object, new Object[]{input});
            Method computeCurrentMethod = md4Class.getMethod("computeCurrent", null);
            if (null == computeCurrentMethod) {
                throw new IllegalStateException("Expected class 'com.phaos.crypto.MD4' to have method 'public void computeCurrent()'.");
            }
            computeCurrentMethod.invoke(md4Object, null);
            Method getDigestBitsMethod = md4Class.getMethod("getDigestBits", null);
            if (null == getDigestBitsMethod) {
                throw new IllegalStateException("Expected class 'com.phaos.crypto.MD4' to have method 'public byte[] getDigestBits()'.");
            }
            hashedObject = getDigestBitsMethod.invoke(md4Object, null);
        }
        catch (Exception e) {
            throw new Exception("Unable to compute MD4 digest using reflection.", e);
        }
        return (byte[])hashedObject;
    }

    public static byte[] generateNtlmV1Hash(String password) throws Exception {
        if (!NtlmCore.isNtlmV1ResponseSupported()) {
            logger.log(Level.FINEST, "NTLM version 1 is not supported.");
            return null;
        }
        if (null == password) {
            password = "";
        }
        byte[] passwordBytes = NtlmCore.toNtlmBytes(password, false);
        return NtlmCore.generateMd4Hash(passwordBytes);
    }

    private static byte[] generateLmV1Response(byte[] passwordHash, byte[] nonce) throws Exception {
        if (null == passwordHash || 16 != passwordHash.length) {
            throw new IllegalArgumentException("Expected non-null, 16 byte passwordHash.");
        }
        if (null == nonce || 8 != nonce.length) {
            throw new IllegalArgumentException("Expected non-null, 8 byte nonce.");
        }
        byte[] extendedHash = new byte[21];
        System.arraycopy(passwordHash, 0, extendedHash, 0, 16);
        Key key0 = NtlmCore.generateDESKey(extendedHash, 0);
        Key key1 = NtlmCore.generateDESKey(extendedHash, 7);
        Key key2 = NtlmCore.generateDESKey(extendedHash, 14);
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, key0);
        byte[] response0 = des.doFinal(nonce);
        des.init(1, key1);
        byte[] response1 = des.doFinal(nonce);
        des.init(1, key2);
        byte[] response2 = des.doFinal(nonce);
        byte[] output = new byte[24];
        System.arraycopy(response0, 0, output, 0, 8);
        System.arraycopy(response1, 0, output, 8, 8);
        System.arraycopy(response2, 0, output, 16, 8);
        return output;
    }

    public static boolean isNtlmV1ResponseSupported() {
        return NtlmCore.isMD4Enabled() && null != md4Class;
    }

    static void setMD4Enabled(boolean isMD4Enabled) {
        NtlmCore.isMD4Enabled = isMD4Enabled;
    }

    static boolean isMD4Enabled() {
        return isMD4Enabled;
    }

    public static boolean isNtlmV2ResponseSupported() {
        return false;
    }

    public static boolean isLmV1ResponseSupported() {
        return true;
    }

    public static String formatType1Message(String clientHostName, String clientHostDomain) {
        if (null == clientHostName) {
            clientHostName = "";
        }
        if (null == clientHostDomain) {
            clientHostDomain = "";
        }
        clientHostName = clientHostName.toUpperCase();
        clientHostDomain = clientHostDomain.toUpperCase();
        byte[] clientHostNameBytes = NtlmCore.toNtlmBytes(clientHostName, true);
        byte[] clientHostDomainBytes = NtlmCore.toNtlmBytes(clientHostDomain, true);
        short clientHostDomainLength = (short)clientHostDomainBytes.length;
        short clientHostNameLength = (short)clientHostNameBytes.length;
        int clientHostNameOffset = 32;
        short clientHostDomainOffset = (short)(32 + clientHostNameLength);
        NtlmSupportFlags supportFlags = new NtlmSupportFlags(0x8000 | (clientHostNameLength > 0 ? 8192 : 0) | (clientHostDomainLength > 0 ? 4096 : 0) | 0x200 | 2 | 1);
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(1024);
        DataOutputStream dataOS = new DataOutputStream(baOS);
        String output = "";
        try {
            dataOS.write(NTLMSSP_BYTES);
            dataOS.writeByte(0);
            dataOS.writeByte(1);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(supportFlags.getNtlmBytes());
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes((short)32));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(clientHostNameBytes);
            dataOS.write(clientHostDomainBytes);
            dataOS.flush();
            byte[] outputBytes = baOS.toByteArray();
            byte[] encodedOutputBytes = Codecs.base64Encode(outputBytes);
            output = new String(encodedOutputBytes, ASCII_CHARSET);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Trying to format an NTLM Type 1 message.", e);
        }
        return output;
    }

    public static NtlmType2Message parseType2Message(String messageStr) {
        byte[] messageBytes = null;
        try {
            messageBytes = messageStr.getBytes(ASCII_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINER, "Ntlm is not supported, since ASCII ('US-ASCII') is not supported.", e);
            return null;
        }
        byte[] decodedMessageBytes = null;
        try {
            decodedMessageBytes = Codecs.base64Decode(messageBytes);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Corrupt type 2 message given, unable to base-64 decode, '" + messageStr + "'.", e);
            return null;
        }
        if (decodedMessageBytes.length < 32) {
            logger.log(Level.FINER, "NTLM Type 2 message expected to be at least 32 bytes long, was {0} bytes long. Base64Encoded Message ''{1}''", new Object[]{new Integer(decodedMessageBytes.length), messageStr});
            return null;
        }
        for (int i = 0; i < NTLMSSP_BYTES.length; ++i) {
            if (decodedMessageBytes[i] == NTLMSSP_BYTES[i]) continue;
            logger.log(Level.FINER, "NTLM Type 2 message expected to start with ''NTLMSSP''. Base64Encoded Message ''{0}''", new Object[]{messageStr});
            return null;
        }
        byte[] TYPE_2_MESSAGE_TYPE = new byte[]{2, 0, 0, 0};
        for (int i = 0; i < TYPE_2_MESSAGE_TYPE.length; ++i) {
            if (decodedMessageBytes[i + 8] == TYPE_2_MESSAGE_TYPE[i]) continue;
            logger.log(Level.FINER, "NTLM Type 2 message expected to indicate Type 2. Base64Encoded Message ''{0}''", new Object[]{messageStr});
            return null;
        }
        byte[] flagNtlmBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            flagNtlmBytes[i] = decodedMessageBytes[i + 20];
        }
        NtlmSupportFlags flags = new NtlmSupportFlags(flagNtlmBytes);
        byte[] nonce = new byte[8];
        for (int i = 0; i < 8; ++i) {
            nonce[i] = decodedMessageBytes[i + 24];
        }
        NtlmType2Message output = new NtlmType2Message(flags, nonce);
        return output;
    }

    public static String formatType3Message(String clientHostName, String userDomain, String username, byte[] lmPasswordHash, byte[] ntlmPasswordHash, NtlmType2Message challenge) {
        boolean useOem;
        if (null == challenge) {
            throw new IllegalArgumentException("Non-null NtlmType2Message object expected.");
        }
        if (null == clientHostName) {
            clientHostName = "";
        }
        if (null == userDomain) {
            userDomain = "";
        }
        if (null == username) {
            username = "";
        }
        boolean bl = useOem = !challenge.getFlags().anyFlagsOn(1);
        if (useOem) {
            clientHostName = clientHostName.toUpperCase();
            userDomain = userDomain.toUpperCase();
            username = username.toUpperCase();
        }
        byte[] clientHostNameBytes = NtlmCore.toNtlmBytes(clientHostName, useOem);
        byte[] userDomainBytes = NtlmCore.toNtlmBytes(userDomain, useOem);
        byte[] usernameBytes = NtlmCore.toNtlmBytes(username, useOem);
        byte[] nonce = challenge.getNonce();
        byte[] ntlmResponseBytes = new byte[]{};
        byte[] lmResponseBytes = new byte[]{};
        try {
            lmResponseBytes = NtlmCore.generateLmV1Response(lmPasswordHash, nonce);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Unable to generate LmV1 response.", e);
        }
        if (null != ntlmPasswordHash && NtlmCore.isNtlmV1ResponseSupported()) {
            try {
                ntlmResponseBytes = NtlmCore.generateLmV1Response(ntlmPasswordHash, nonce);
            }
            catch (Exception e) {
                logger.log(Level.FINER, "Unable to generate NtlmV1 response.", e);
            }
        }
        short clientHostNameLength = (short)clientHostNameBytes.length;
        short userDomainLength = (short)userDomainBytes.length;
        short usernameLength = (short)usernameBytes.length;
        short lmResponseLength = (short)lmResponseBytes.length;
        short ntlmResponseLength = (short)ntlmResponseBytes.length;
        short userDomainOffset = 64;
        short usernameOffset = (short)(userDomainOffset + userDomainLength);
        short clientHostNameOffset = (short)(usernameOffset + usernameLength);
        short lmResponseOffset = (short)(clientHostNameOffset + clientHostNameLength);
        short ntlmResponseOffset = (short)(lmResponseOffset + lmResponseLength);
        short sessionKeyOffset = (short)(ntlmResponseOffset + ntlmResponseLength);
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(1024);
        DataOutputStream dataOS = new DataOutputStream(baOS);
        String output = "";
        try {
            dataOS.write(NTLMSSP_BYTES);
            dataOS.writeByte(0);
            dataOS.writeByte(3);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(userDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(userDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(userDomainOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(usernameLength));
            dataOS.write(NtlmCore.toNtlmBytes(usernameLength));
            dataOS.write(NtlmCore.toNtlmBytes(usernameOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeShort(0);
            dataOS.writeShort(0);
            dataOS.write(NtlmCore.toNtlmBytes(sessionKeyOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(challenge.getFlags().getNtlmBytes());
            dataOS.write(userDomainBytes);
            dataOS.write(usernameBytes);
            dataOS.write(clientHostNameBytes);
            dataOS.write(lmResponseBytes);
            dataOS.write(ntlmResponseBytes);
            dataOS.flush();
            byte[] outputBytes = baOS.toByteArray();
            byte[] encodedOutputBytes = Codecs.base64Encode(outputBytes);
            output = new String(encodedOutputBytes, ASCII_CHARSET);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Trying to format an NTLM Type 3 message.", e);
        }
        return output;
    }

    static {
        NtlmCore.loadMd4Class(null, true);
        md4_threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                Object output = null;
                if (null != md4Class) {
                    try {
                        output = md4Class.newInstance();
                    }
                    catch (Exception e) {
                        logger.log(Level.FINER, "Unable to instantiate MD4 class '" + md4Class.getName() + "'.", e);
                    }
                }
                return output;
            }
        };
        isMD4Enabled = true;
    }
}

