/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BufferedInputStream;
import HTTPClient.ChunkedTransferEncoder;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import HTTPClient.SocketTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private BufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private static Object cleanup;
    private List RespHandlerList;
    private long chunk_len;
    private int cur_timeout = 0;
    private static final Logger logger;

    StreamDemultiplexor(int protocol, Socket sock, HTTPConnection connection) throws IOException {
        this.Protocol = protocol;
        this.Connection = connection;
        this.RespHandlerList = Collections.synchronizedList(new LinkedList());
        this.init(sock);
    }

    private void init(final Socket sock) throws IOException {
        logger.log(Level.FINER, "Demux: Initializing Stream Demultiplexor ( hashcode={0} )", Integer.toString(this.hashCode()));
        this.Sock = sock;
        try {
            this.Stream = (BufferedInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new BufferedInputStream(sock.getInputStream());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        this.MarkedForClose = null;
        this.chunk_len = -1L;
        this.Timer = TimerThread.setTimeout(this, HttpClientConfiguration.getSocketIdleTimeout());
        this.Timer.hyber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Response resp_handler, Request req) throws RetryException {
        List list = this.RespHandlerList;
        synchronized (list) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.add(new ResponseHandler(resp_handler, req, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RespInputStream getStream(Response resp) {
        ResponseHandler resph = null;
        List list = this.RespHandlerList;
        synchronized (list) {
            Iterator iterator = this.RespHandlerList.iterator();
            while (iterator.hasNext()) {
                resph = (ResponseHandler)iterator.next();
                if (resph.resp != resp) continue;
            }
            if (resph != null) {
                return resph.stream;
            }
            return null;
        }
    }

    BufferedInputStream getStream() {
        return this.Stream;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    void setIdle(int idle) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Demux: setIdle, seconds={0}, Timer={1}, ( demux hashcode={2} )", new Object[]{Integer.toString(idle), this.Timer, Integer.toString(this.hashCode())});
        }
        if (this.Timer != null) {
            this.Timer.setIdle(idle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] b, int off, int len, ResponseHandler resph, int timeout) throws IOException {
        if (resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph.eof) {
            return -1;
        }
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            List list = this.RespHandlerList;
            synchronized (list) {
                if (this.RespHandlerList.size() > 0) {
                    ResponseHandler head;
                    while (this.RespHandlerList.size() > 0 && (head = (ResponseHandler)this.RespHandlerList.get(0)) != null && head != resph) {
                        try {
                            head.stream.readAll(timeout);
                        }
                        catch (IOException ioe) {
                            if (ioe instanceof InterruptedIOException) {
                                throw ioe;
                            }
                            resph.exception.fillInStackTrace();
                            throw resph.exception;
                        }
                    }
                }
            }
        }
        streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            if (resph.exception != null) {
                resph.exception.fillInStackTrace();
                throw resph.exception;
            }
            if (resph.resp.cd_type != 1) {
                logger.log(Level.FINER, "Demux: Reading for stream with hashcode={0}", Integer.toString(resph.stream.hashCode()));
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                int rcvd = -1;
                if (timeout != this.cur_timeout) {
                    logger.log(Level.FINER, "Demux: Setting timeout to {0} ms", Integer.toString(timeout));
                    this.Sock.setSoTimeout(timeout);
                    this.cur_timeout = timeout;
                }
                switch (resph.resp.cd_type) {
                    case 1: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        rcvd = -1;
                        this.close(resph);
                        break;
                    }
                    case 3: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        this.close(resph);
                        break;
                    }
                    case 4: {
                        int cl = resph.resp.ContentLength;
                        if (len > cl - resph.stream.count) {
                            len = cl - resph.stream.count;
                        }
                        if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (resph.stream.count + rcvd != cl) break;
                        this.close(resph);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1L) {
                            this.chunk_len = ChunkedTransferEncoder.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0L) {
                            if ((long)len > this.chunk_len) {
                                len = (int)this.chunk_len;
                            }
                            if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= (long)rcvd;
                            if (this.chunk_len != 0L) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1L;
                            break;
                        }
                        if (resph.resp.getHeader("Trailer") != null) {
                            resph.resp.readTrailers(this.Stream);
                        }
                        rcvd = -1;
                        this.close(resph);
                        this.chunk_len = -1L;
                        break;
                    }
                    case 6: {
                        byte[] endbndry = resph.getEndBoundary(this.Stream);
                        int[] end_cmp = resph.getEndCompiled(this.Stream);
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        int ovf = this.Stream.pastEnd(endbndry, end_cmp);
                        if (ovf == -1) break;
                        rcvd -= ovf;
                        this.close(resph);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
                    }
                }
                this.restartTimer();
                return rcvd;
            }
            catch (InterruptedIOException ie) {
                this.restartTimer();
                throw ie;
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "Demux: " + ioe.getMessage(), ioe);
                this.close(ioe, true);
                throw resph.exception;
            }
            catch (ParseException pe) {
                logger.log(Level.FINEST, "Demux: ", pe);
                this.close(new IOException(pe.toString()), true);
                throw resph.exception;
            }
        }
    }

    public synchronized void unread(byte[] b, int off, int len) throws IOException {
        this.Stream.unread(b, off, len);
    }

    synchronized long skip(long num, ResponseHandler resph) throws IOException {
        if (resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph.eof) {
            return 0L;
        }
        byte[] dummy = new byte[(int)num];
        int rcvd = this.read(dummy, 0, (int)num, resph, 0);
        if (rcvd == -1) {
            return 0L;
        }
        return rcvd;
    }

    synchronized int available(ResponseHandler resph) throws IOException {
        if (resph != null && resph.exception != null) {
            resph.exception.fillInStackTrace();
            throw resph.exception;
        }
        if (resph != null && resph.eof) {
            return 0;
        }
        int avail = this.Stream.available();
        if (resph == null) {
            return avail;
        }
        switch (resph.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return avail > 0 ? 1 : 0;
            }
            case 3: {
                return avail;
            }
            case 4: {
                int cl = resph.resp.ContentLength;
                return avail < (cl -= resph.stream.count) ? avail : cl;
            }
            case 5: {
                return avail;
            }
            case 6: {
                return avail;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(IOException exception, boolean was_reset) {
        if (this.Sock == null) {
            return;
        }
        logger.log(Level.FINER, "Demux: Closing all streams and socket (demux hashcode={0})", Integer.toString(this.hashCode()));
        try {
            this.Stream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.Sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (exception != null) {
            List list = this.RespHandlerList;
            synchronized (list) {
                this.retry_requests(exception, was_reset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry_requests(IOException exception, boolean was_reset) {
        List list = this.RespHandlerList;
        synchronized (list) {
            RetryException first = null;
            RetryException prev = null;
            Iterator iterator = this.RespHandlerList.iterator();
            while (iterator.hasNext()) {
                ResponseHandler resph = (ResponseHandler)iterator.next();
                if (resph.resp.got_headers) {
                    resph.exception = exception;
                } else {
                    RetryException tmp = new RetryException(exception.getMessage());
                    if (first == null) {
                        first = tmp;
                    }
                    tmp.request = resph.request;
                    tmp.response = resph.resp;
                    tmp.exception = exception;
                    tmp.conn_reset = was_reset;
                    tmp.firstByte = resph.stream.count == 0;
                    tmp.first = first;
                    tmp.addToListAfter(prev);
                    prev = tmp;
                    resph.exception = tmp;
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ResponseHandler resph) {
        List list = this.RespHandlerList;
        synchronized (list) {
            if (resph != (ResponseHandler)this.RespHandlerList.get(0)) {
                return;
            }
            logger.log(Level.FINER, "Demux: Closing stream with hashcode={0}", Integer.toString(resph.stream.hashCode()));
            resph.eof = true;
            this.RespHandlerList.remove(resph);
        }
        if (resph == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeSocketIfAllStreamsClosed() {
        List list = this.RespHandlerList;
        synchronized (list) {
            int closedIndex;
            if (this.MarkedForClose != null && (closedIndex = this.RespHandlerList.indexOf(this.MarkedForClose)) > -1) {
                Iterator iterator = this.RespHandlerList.iterator();
                boolean openStreamsExist = false;
                for (int index = 0; iterator.hasNext() && index <= closedIndex; ++index) {
                    ResponseHandler resph = (ResponseHandler)iterator.next();
                    if (!resph.stream.closed) {
                        openStreamsExist = true;
                        break;
                    }
                    iterator.remove();
                }
                if (!openStreamsExist) {
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                }
                return;
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void markForClose(Response resp) {
        boolean foundMatchingResponse = false;
        ResponseHandler lasth = null;
        List list = this.RespHandlerList;
        synchronized (list) {
            if (this.RespHandlerList.size() == 0) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
            if (this.Timer != null) {
                this.Timer.kill();
                this.Timer = null;
            }
            if (resp == null) {
                this.MarkedForClose = (ResponseHandler)this.RespHandlerList.get(0);
                this.closeSocketIfAllStreamsClosed();
                return;
            }
            Iterator iterator = this.RespHandlerList.iterator();
            while (iterator.hasNext()) {
                ResponseHandler resph = (ResponseHandler)iterator.next();
                if (resph.resp == resp) {
                    this.MarkedForClose = resph;
                    foundMatchingResponse = true;
                    logger.log(Level.FINER, "Demux: stream with hashcode={0} marked for close", Integer.toString(resp.inp_stream.hashCode()));
                    break;
                }
                if (this.MarkedForClose == resph) {
                    return;
                }
                lasth = resph;
            }
            if (lasth != null) {
                this.MarkedForClose = lasth;
                foundMatchingResponse = true;
            }
        }
        if (foundMatchingResponse) {
            this.closeSocketIfAllStreamsClosed();
            return;
        }
        logger.log(Level.FINER, "Demux: stream with hashcode={0} marked for close", Integer.toString(lasth.stream.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        logger.log(Level.FINER, "Demux: Aborting socket (demux hashcode={0})", Integer.toString(this.hashCode()));
        List list = this.RespHandlerList;
        synchronized (list) {
            Iterator iterator = this.RespHandlerList.iterator();
            while (iterator.hasNext()) {
                ResponseHandler resph = (ResponseHandler)iterator.next();
                if (resph.resp.http_resp != null) {
                    resph.resp.http_resp.markAborted();
                }
                if (resph.exception != null) continue;
                resph.exception = new IOException("Request aborted by user");
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (SocketException se) {
                        // empty catch block
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this.Sock.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        switch (this.Protocol) {
            case 0: {
                String prot = "HTTP";
                break;
            }
            case 1: {
                String prot = "HTTPS";
                break;
            }
            case 2: {
                String prot = "SHTTP";
                break;
            }
            case 3: {
                String prot = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + (String)var1_1 + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSocketClosedByServer() {
        boolean closedByServer;
        String socketStr;
        block16: {
            Socket s = null;
            socketStr = "Socket[null]";
            closedByServer = true;
            try {
                s = this.getSocket();
                if (s == null) break block16;
                socketStr = s.toString();
                boolean isConnected = s.isConnected();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "StaleCheck: Socket.isConnected=" + isConnected + ", " + socketStr);
                }
                if (!isConnected) break block16;
                closedByServer = false;
                StreamDemultiplexor streamDemultiplexor = this;
                synchronized (streamDemultiplexor) {
                    BufferedInputStream bis;
                    block17: {
                        bis = this.getStream();
                        if (null != bis) break block17;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "StaleCheck: Null BufferedInputStream, " + socketStr);
                        }
                        break block16;
                    }
                    int currentTimeout = s.getSoTimeout();
                    s.setSoTimeout(1);
                    try {
                        bis.topOffBuff();
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        try {
                            s.setSoTimeout(currentTimeout);
                        }
                        catch (SocketException se) {
                            logger.log(Level.FINE, "StaleCheck: Problem resetting read timeout on socket: " + socketStr, se);
                        }
                        throw throwable;
                    }
                    try {
                        s.setSoTimeout(currentTimeout);
                    }
                    catch (SocketException se) {
                        logger.log(Level.FINE, "StaleCheck: Problem resetting read timeout on socket: " + socketStr, se);
                    }
                    int bytesRead = bis.getLastReadByteCount();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "StaleCheck: bytesRead=" + bytesRead + ", " + socketStr);
                    }
                    if (-1 == bytesRead) {
                        closedByServer = true;
                    }
                }
            }
            catch (SocketTimeoutException ste) {
                closedByServer = false;
                logger.log(Level.FINEST, "StaleCheck: Socket still alive (timeout): " + socketStr);
            }
            catch (IOException ioe) {
                closedByServer = true;
                logger.log(Level.FINE, "StaleCheck: IO Error on socket: " + socketStr, ioe);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "StaleCheck: closedByServer=" + closedByServer + ", " + socketStr);
        }
        return closedByServer;
    }

    static /* synthetic */ SocketTimeout access$000() {
        return TimerThread;
    }

    static {
        logger = HttpClientLoggerFactory.getLogger(StreamDemultiplexor.class.getName());
        TimerThread = new SocketTimeout();
        TimerThread.start();
        cleanup = new Object(){
            private final SocketTimeout timer = StreamDemultiplexor.access$000();

            protected void finalize() {
                this.timer.kill();
            }
        };
    }
}

