/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientLoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class StandardHostnameVerifier
implements HostnameVerifier {
    private static Logger logger = HttpClientLoggerFactory.getLogger(StandardHostnameVerifier.class.getName());
    private boolean recognizeWildcardCNs = true;
    private static final Pattern CN_START_PATTERN = Pattern.compile("[Cc][Nn] *?= *?");
    private static final Pattern CN_END_PATTERN = Pattern.compile("[^\\\\],");

    public StandardHostnameVerifier() {
    }

    public StandardHostnameVerifier(boolean recognizeWildcardCNs) {
        this.setRecognizeWildcardCNs(recognizeWildcardCNs);
    }

    public boolean isRecognizeWildcardCNs() {
        return this.recognizeWildcardCNs;
    }

    public boolean setRecognizeWildcardCNs(boolean recognizeWildcardCNs) {
        boolean prev = this.recognizeWildcardCNs;
        this.recognizeWildcardCNs = recognizeWildcardCNs;
        return prev;
    }

    public boolean verify(String hostname, SSLSession sslSession) {
        String string = hostname = null == hostname ? "" : hostname.trim();
        if (null == sslSession) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Expected non-null SSLSession for host ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        if ("".equals(hostname)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Expected non-null, non-empty hostname.");
            }
            return false;
        }
        X509Certificate[] peerCertificateChain = null;
        try {
            peerCertificateChain = sslSession.getPeerCertificateChain();
            if (null == peerCertificateChain || 0 == peerCertificateChain.length) {
                throw new SSLPeerUnverifiedException("Found no server certificates.");
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unable to obtain SSL session peer certificate chain for host '" + hostname + "'.", e);
            }
            return false;
        }
        StandardHostnameVerifier.dumpCertDNsToLog(peerCertificateChain, hostname);
        X509Certificate peerCertificate = peerCertificateChain[0];
        if (null == peerCertificate) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "First SSL certificate is null for hostname ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        Principal principal = peerCertificate.getSubjectDN();
        if (null == principal) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Principal in first SSL certificate is null for hostname ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        String dn = principal.getName();
        if (null == dn || "".equals(dn)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "First SSL certificate has null or empty Distinguished Name (DN) for hostname ''{0}''", new Object[]{hostname});
            }
            return false;
        }
        if (!this.isMatchesCN(hostname, dn)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SSL certificate Distinguished Name (DN) ''{0}'' does not have a Common Name (CN) which matches hostname ''{1}''.", new Object[]{dn, hostname});
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Successfully verified hostname ''{0}'' with SSL certificate Common Name (CN).", new Object[]{hostname});
        }
        return true;
    }

    private boolean isMatchesCN(String hostname, String dn) {
        String cnValue = StandardHostnameVerifier.parseDNforCN(hostname, dn);
        if (null == cnValue) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unable to find CN in DN '" + dn + "' for hostname '" + hostname + "'.");
            }
            return false;
        }
        if (cnValue.equalsIgnoreCase(hostname)) {
            return true;
        }
        if (this.recognizeWildcardCNs && cnValue.startsWith("*.")) {
            if (-1 == cnValue.indexOf(46, 2)) {
                return false;
            }
            if (-1 != cnValue.indexOf(42, 2)) {
                return false;
            }
            int START_AT_INDEX = hostname.length() - (cnValue.length() - 1);
            if (START_AT_INDEX < 0) {
                return false;
            }
            String hostnameTail = hostname.substring(START_AT_INDEX);
            if (cnValue.substring(1).equalsIgnoreCase(hostnameTail)) {
                return true;
            }
        }
        try {
            InetAddress ia_2;
            InetAddress ia_1;
            if (HTTPConnection.isStringAnIPv6(hostname) && HTTPConnection.isStringAnIPv6(cnValue) && (ia_1 = InetAddress.getByName(hostname)).equals(ia_2 = InetAddress.getByName(cnValue))) {
                return true;
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        return false;
    }

    static String parseDNforCN(String hostname, String dn) {
        String cnValue;
        block16: {
            cnValue = null;
            try {
                Matcher startMatcher = CN_START_PATTERN.matcher(dn);
                if (startMatcher.find()) {
                    int startIndex = startMatcher.end();
                    Matcher endMatcher = CN_END_PATTERN.matcher(dn);
                    if (endMatcher.find(startIndex - 1)) {
                        int endIndex = endMatcher.start() + 1;
                        cnValue = dn.substring(startIndex, endIndex);
                    } else {
                        cnValue = dn.substring(startIndex);
                    }
                }
                if (null != cnValue) {
                    cnValue = cnValue.trim();
                }
                int BACKSLASH = 92;
                if (null == cnValue || -1 == cnValue.indexOf(92)) break block16;
                StringBuffer cnValueBuff = new StringBuffer(256);
                int len = cnValue.length();
                boolean isEscapeMode = false;
                for (int i = 0; i < len; ++i) {
                    char currChar = cnValue.charAt(i);
                    if (!isEscapeMode) {
                        if (currChar == '\\') {
                            isEscapeMode = true;
                            continue;
                        }
                        cnValueBuff.append(currChar);
                        continue;
                    }
                    isEscapeMode = false;
                    int currDigit = Character.digit(currChar, 16);
                    if (-1 == currDigit) {
                        cnValueBuff.append(currChar);
                        continue;
                    }
                    if (i + 1 < len) {
                        String hexCharStr;
                        block17: {
                            char nextChar = cnValue.charAt(i + 1);
                            int nextDigit = Character.digit(nextChar, 16);
                            if (-1 == nextDigit) {
                                cnValueBuff.append(currChar);
                                continue;
                            }
                            hexCharStr = null;
                            String hexPair = "";
                            try {
                                hexPair = "0x" + currChar + nextChar;
                                byte[] charByteArr = new byte[]{Byte.decode(hexPair)};
                                hexCharStr = new String(charByteArr, "ISO-8859-1");
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.FINE)) break block17;
                                logger.log(Level.FINE, "Unable to parse hexPair '" + hexPair + "' of CN '" + cnValue + "' of DN '" + dn + "' for hostname '" + hostname + "'.", e);
                            }
                        }
                        if (null != hexCharStr) {
                            cnValueBuff.append(hexCharStr);
                            ++i;
                            continue;
                        }
                        cnValueBuff.append(currChar);
                        continue;
                    }
                    cnValueBuff.append(currChar);
                }
                if (isEscapeMode) {
                    cnValueBuff.append('\\');
                    isEscapeMode = false;
                }
                cnValue = cnValueBuff.toString();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block16;
                logger.log(Level.FINE, "Unable to parse CN for DN '" + dn + "' for hostname '" + hostname + "'.", e);
            }
        }
        return cnValue;
    }

    private static void dumpCertDNsToLog(X509Certificate[] peerCertificateChain, String hostname) {
        Level LEVEL = Level.FINEST;
        if (logger.isLoggable(LEVEL)) {
            String string = hostname = null == hostname ? "" : hostname;
            if (null == peerCertificateChain || 0 == peerCertificateChain.length) {
                logger.log(LEVEL, "Null or empty peer certificate chain given for hostname ''{0}''", new Object[]{hostname});
            } else {
                StringBuffer buff = new StringBuffer(256);
                buff.append("Dump of SSL certificate DN values for Host '");
                buff.append(hostname);
                buff.append("': \n");
                for (int i = 0; i < peerCertificateChain.length; ++i) {
                    X509Certificate cert = peerCertificateChain[i];
                    if (null == cert) continue;
                    buff.append(cert.getSubjectDN().getName());
                    buff.append('\n');
                }
                buff.append("done---------\n");
                logger.log(LEVEL, buff.toString());
            }
        }
    }
}

