/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.StreamDemultiplexor;
import java.util.logging.Level;
import java.util.logging.Logger;

class SocketTimeout
extends Thread {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(SocketTimeout.class.getName());
    private boolean alive = true;
    private TimeoutEntry[] time_list;
    private int current;
    private int defaultIdle;

    void writeTimeList() {
        for (int x = 0; x < this.time_list.length; ++x) {
            TimeoutEntry head = this.time_list[x];
            StreamDemultiplexor d = head.next != null ? head.next.demux : null;
            int h = d == null ? 0 : System.identityHashCode(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallocate(int max) {
        SocketTimeout socketTimeout = this;
        synchronized (socketTimeout) {
            if (this.time_list.length < max) {
                TimeoutEntry[] new_time_list = new TimeoutEntry[max];
                int left = this.current;
                int right = this.time_list.length - left;
                System.arraycopy(this.time_list, this.current, new_time_list, 0, right);
                System.arraycopy(this.time_list, 0, new_time_list, right, left);
                for (int idx = this.time_list.length; idx < max; ++idx) {
                    new_time_list[idx] = new TimeoutEntry(null, this.defaultIdle);
                    new_time_list[idx].next = new_time_list[idx].prev = new_time_list[idx];
                }
                this.time_list = new_time_list;
            }
        }
    }

    SocketTimeout() {
        super("SocketTimeout");
        int secs = HttpClientConfiguration.getSocketIdleTimeout();
        try {
            this.setDaemon(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.setPriority(10);
        this.defaultIdle = secs;
        this.time_list = new TimeoutEntry[secs];
        for (int idx = 0; idx < secs; ++idx) {
            this.time_list[idx] = new TimeoutEntry(null, this.defaultIdle);
            this.time_list[idx].next = this.time_list[idx].prev = this.time_list[idx];
        }
        this.current = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutEntry setTimeout(StreamDemultiplexor demux, int idle) {
        TimeoutEntry entry = new TimeoutEntry(demux, idle);
        SocketTimeout socketTimeout = this;
        synchronized (socketTimeout) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "idleTO: setTimeout: current={0}, idle={1}, time_list.length={2}, demuxHashcode={3}, this={4}", new Object[]{Integer.toString(this.current), Integer.toString(idle), Integer.toString(this.time_list.length), Integer.toString(entry.demuxHashcode), this});
            }
            entry.next = this.time_list[this.current];
            entry.prev = this.time_list[this.current].prev;
            entry.prev.next = entry;
            entry.next.prev = entry;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TimeoutEntry marked = null;
        while (this.alive) {
            try {
                SocketTimeout.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SocketTimeout socketTimeout = this;
            synchronized (socketTimeout) {
                TimeoutEntry entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    entry.restart = false;
                    entry = entry.next;
                }
                ++this.current;
                if (this.current >= this.time_list.length) {
                    this.current = 0;
                }
                entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    if (entry.alive && !entry.hyber) {
                        TimeoutEntry prev = entry.prev;
                        entry.kill();
                        entry.next = marked;
                        marked = entry;
                        entry = prev;
                    }
                    entry = entry.next;
                }
            }
            while (marked != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "idleTO: worker: idle time expired (demux hashcode={0})", Integer.toString(marked.demux.hashCode()));
                }
                marked.demux.markForClose(null);
                marked = marked.next;
            }
        }
    }

    public void kill() {
        this.alive = false;
    }

    class TimeoutEntry {
        boolean restart = false;
        boolean hyber = false;
        boolean alive = true;
        int idle;
        StreamDemultiplexor demux;
        TimeoutEntry next = null;
        TimeoutEntry prev = null;
        int demuxHashcode = -1;

        TimeoutEntry(StreamDemultiplexor demux, int idle) {
            this.demux = demux;
            this.idle = idle;
            if (demux != null) {
                this.demuxHashcode = demux.hashCode();
            }
        }

        void setIdle(int idle) {
            this.idle = idle;
            SocketTimeout.this.reallocate(idle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            this.hyber = false;
            if (this.restart) {
                return;
            }
            this.restart = true;
            SocketTimeout socketTimeout = SocketTimeout.this;
            synchronized (socketTimeout) {
                if (!this.alive) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                int addTo = (SocketTimeout.this.current + this.idle) % SocketTimeout.this.time_list.length;
                this.next = SocketTimeout.this.time_list[addTo];
                this.prev = ((SocketTimeout)SocketTimeout.this).time_list[addTo].prev;
                this.prev.next = this;
                this.next.prev = this;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "idleTO: reset: current={0}, idle={1}, time_list.length={2}, addTo={3}, demuxHashcode={4}, SocketTimeout.this={5}", new Object[]{Integer.toString(SocketTimeout.this.current), Integer.toString(this.idle), Integer.toString(SocketTimeout.this.time_list.length), Integer.toString(addTo), Integer.toString(this.demuxHashcode), SocketTimeout.this});
                }
            }
        }

        void hyber() {
            if (this.alive) {
                this.hyber = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            this.alive = false;
            this.restart = false;
            this.hyber = false;
            SocketTimeout socketTimeout = SocketTimeout.this;
            synchronized (socketTimeout) {
                if (this.prev == null) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = null;
            }
        }
    }
}

