/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BufferedInputStream;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResponseHandler {
    RespInputStream stream;
    Response resp;
    Request request;
    boolean eof = false;
    IOException exception = null;
    private static Logger logger = HttpClientLoggerFactory.getLogger();
    private byte[] endbndry = null;
    private int[] end_cmp = null;

    ResponseHandler(Response resp, Request request, StreamDemultiplexor demux) {
        this.resp = resp;
        this.request = request;
        this.stream = new RespInputStream(demux, this);
        logger.log(Level.FINER, "Demux: Opening stream {0}  for demux ({1})", new Object[]{Integer.toString(this.stream.hashCode()), Integer.toString(demux.hashCode())});
    }

    byte[] getEndBoundary(BufferedInputStream MasterStream) throws IOException, ParseException {
        if (this.endbndry == null) {
            this.setupBoundary(MasterStream);
        }
        return this.endbndry;
    }

    int[] getEndCompiled(BufferedInputStream MasterStream) throws IOException, ParseException {
        if (this.end_cmp == null) {
            this.setupBoundary(MasterStream);
        }
        return this.end_cmp;
    }

    void setupBoundary(BufferedInputStream MasterStream) throws IOException, ParseException {
        String endstr = "--" + Util.getParameter("boundary", this.resp.getHeader("Content-Type")) + "--\r\n";
        this.endbndry = endstr.getBytes("8859_1");
        this.end_cmp = Util.compile_search(this.endbndry);
        MasterStream.markForSearch();
    }
}

