/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthenticationSchemeRegistry;
import HTTPClient.AuthenticationSchemeRegistryHolder;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpHeaderElement;
import HTTPClient.IPushBackInputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.RoResponse;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Timeouts;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Response
implements RoResponse,
GlobalConstants,
Cloneable {
    private static final HashMap singleValueHeaders;
    private HTTPConnection connection;
    private StreamDemultiplexor stream_handler;
    HTTPResponse http_resp;
    Timeouts timeout = new Timeouts(0);
    public InputStream inp_stream;
    private RespInputStream resp_inp_stream = null;
    private String method;
    String resource;
    private boolean used_proxy;
    private boolean sent_entity;
    int StatusCode = 0;
    String ReasonLine;
    String Version;
    URI EffectiveURI = null;
    CIHashtable Headers = new CIHashtable();
    CIHashtable Trailers = new CIHashtable();
    int ContentLength = -1;
    int cd_type = 1;
    byte[] Data = null;
    boolean reading_headers = false;
    boolean got_headers = false;
    boolean got_trailers = false;
    private IOException exception = null;
    boolean final_resp = false;
    boolean retry = false;
    private byte[] headerBuffer = new byte[1024];
    private int numOfSocketConnections = 0;
    private static Logger logger;
    private byte[] buf = new byte[7];
    private int buf_pos = 0;
    private StringBuffer hdrs = new StringBuffer(400);
    private boolean reading_lines = false;
    private boolean bol = true;
    private boolean got_cr = false;
    boolean trailers_read = false;
    Request req = null;
    boolean isFirstResponse = false;

    Response(Request request, boolean used_proxy, StreamDemultiplexor stream_handler) throws IOException {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = used_proxy;
        this.stream_handler = stream_handler;
        this.sent_entity = request.getData() != null;
        stream_handler.register(this, request);
        this.resp_inp_stream = stream_handler.getStream(this);
        this.inp_stream = this.resp_inp_stream;
    }

    Response(Request request, InputStream is) throws IOException {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = false;
        this.stream_handler = null;
        this.sent_entity = request.getData() != null;
        this.inp_stream = is;
    }

    public Response(String version, int status, String reason, NVPair[] headers, byte[] data, InputStream is, int cont_len) {
        this.Version = version;
        this.StatusCode = status;
        this.ReasonLine = reason;
        if (headers != null) {
            for (int idx = 0; idx < headers.length; ++idx) {
                this.setHeader(headers[idx].getName(), headers[idx].getValue());
            }
        }
        if (data != null) {
            this.Data = data;
        } else if (is == null) {
            this.Data = new byte[0];
        } else {
            this.inp_stream = is;
            this.ContentLength = cont_len;
        }
        this.got_headers = true;
        this.got_trailers = true;
    }

    public final int getStatusCode() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.Version;
    }

    int getContinue() throws IOException {
        this.getHeaders(false);
        return this.StatusCode;
    }

    public int getPhysicalConnections() {
        return this.numOfSocketConnections;
    }

    void setPhysicalConnections(int numOfConnections) {
        this.numOfSocketConnections = numOfConnections;
    }

    public final URI getEffectiveURI() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.EffectiveURI;
    }

    public void setEffectiveURI(URI final_uri) {
        this.EffectiveURI = final_uri;
    }

    public final URL getEffectiveURL() throws IOException {
        return this.getEffectiveURI().toURL();
    }

    public void setEffectiveURL(URL final_url) {
        try {
            this.setEffectiveURI(new URI(final_url));
        }
        catch (ParseException pe) {
            throw new Error(pe.toString());
        }
    }

    public String getHeader(String hdr) throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return (String)this.Headers.get(hdr.trim());
    }

    public int getHeaderAsInt(String hdr) throws IOException, NumberFormatException {
        String val = this.getHeader(hdr);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getHeaderAsDate(String hdr) throws IOException, IllegalArgumentException {
        Date date;
        String raw_date = this.getHeader(hdr);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1 && raw_date.indexOf(32) > 0) {
            raw_date = raw_date + " GMT";
        }
        try {
            date = Util.parseHttpDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public void setHeader(String header, String value) {
        this.Headers.put(header.trim(), value.trim());
    }

    public void deleteHeader(String header) {
        this.Headers.remove(header.trim());
    }

    public String getTrailer(String trailer) throws IOException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(trailer.trim());
    }

    public int getTrailerAsInt(String trailer) throws IOException, NumberFormatException {
        String val = this.getTrailer(trailer);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getTrailerAsDate(String trailer) throws IOException, IllegalArgumentException {
        Date date;
        String raw_date = this.getTrailer(trailer);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1 && raw_date.indexOf(32) > 0) {
            raw_date = raw_date + " GMT";
        }
        try {
            date = Util.parseHttpDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public void setTrailer(String trailer, String value) {
        this.Trailers.put(trailer.trim(), value.trim());
    }

    public void deleteTrailer(String trailer) {
        this.Trailers.remove(trailer.trim());
    }

    public synchronized byte[] getData() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException ie) {
                throw ie;
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Resp:  ({0}) {1}", new Object[]{Integer.toString(this.inp_stream.hashCode()), ioe});
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        return new ByteArrayInputStream(this.Data);
    }

    public synchronized boolean hasEntity() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.cd_type != 2;
    }

    public void setRetryRequest(boolean flag) {
        this.retry = flag;
    }

    public boolean retryRequest() {
        return this.retry;
    }

    private synchronized void getHeaders(boolean skip_cont) throws IOException {
        if (this.got_headers) {
            return;
        }
        if (this.exception != null) {
            this.exception.fillInStackTrace();
            throw this.exception;
        }
        this.reading_headers = true;
        try {
            do {
                this.Headers.clear();
                String headers = this.readResponseHeaders(this.inp_stream);
                this.parseResponseHeaders(headers);
            } while (this.StatusCode == 100 && skip_cont || this.StatusCode > 101 && this.StatusCode < 200);
        }
        catch (IOException ioe) {
            if (!(ioe instanceof InterruptedIOException)) {
                this.exception = ioe;
            }
            if (ioe instanceof ProtocolException) {
                this.cd_type = 3;
                if (this.stream_handler != null) {
                    this.stream_handler.markForClose(this);
                }
            }
            throw ioe;
        }
        finally {
            this.reading_headers = false;
        }
        if (this.StatusCode == 100) {
            return;
        }
        int cont_len = -1;
        String cl_hdr = (String)this.Headers.get("Content-Length");
        if (cl_hdr != null) {
            try {
                cont_len = Integer.parseInt(cl_hdr);
                if (cont_len < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                cont_len = -1;
            }
        }
        boolean te_chunked = false;
        boolean te_is_identity = true;
        boolean ct_mpbr = false;
        Vector te_hdr = null;
        try {
            te_hdr = Util.parseHeader((String)this.Headers.get("Transfer-Encoding"));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (te_hdr != null) {
            te_chunked = ((HttpHeaderElement)te_hdr.lastElement()).getName().equalsIgnoreCase("chunked");
            for (int idx = 0; idx < te_hdr.size(); ++idx) {
                if (((HttpHeaderElement)te_hdr.elementAt(idx)).getName().equalsIgnoreCase("identity")) {
                    te_hdr.removeElementAt(idx--);
                    continue;
                }
                te_is_identity = false;
            }
        }
        try {
            String hdr = (String)this.Headers.get("Content-Type");
            if (hdr != null) {
                Vector phdr = Util.parseHeader(hdr);
                ct_mpbr = phdr.contains(new HttpHeaderElement("multipart/byteranges")) || phdr.contains(new HttpHeaderElement("multipart/x-byteranges"));
            } else {
                this.Headers.put("Content-Type", "application/octet-stream");
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (this.StatusCode < 200 || this.StatusCode == 204 || this.StatusCode == 205 || this.StatusCode == 304) {
            this.cd_type = 2;
        } else if (te_chunked) {
            this.cd_type = 5;
            te_hdr.removeElementAt(te_hdr.size() - 1);
            if (te_hdr.size() > 0) {
                this.setHeader("Transfer-Encoding", Util.assembleHeader(te_hdr));
            } else {
                this.deleteHeader("Transfer-Encoding");
            }
        } else if (cont_len != -1 && te_is_identity) {
            this.cd_type = 4;
        } else if (ct_mpbr && te_is_identity) {
            this.cd_type = 6;
        } else if (!this.method.equals("HEAD")) {
            this.cd_type = 3;
            if (this.stream_handler != null) {
                this.stream_handler.markForClose(this);
            }
            if (this.Version.equals("HTTP/0.9")) {
                this.inp_stream = new SequenceInputStream(new ByteArrayInputStream(this.Data), this.inp_stream);
                this.Data = null;
            }
        }
        if (this.cd_type == 4) {
            this.ContentLength = cont_len;
        } else {
            this.deleteHeader("Content-Length");
        }
        if (this.method.equals("HEAD")) {
            this.cd_type = 2;
        }
        if (this.cd_type == 2) {
            this.ContentLength = 0;
            this.Data = new byte[0];
            this.inp_stream.close();
        }
        logger.log(Level.FINER, "Resp:  Response entity delimiter: " + (this.cd_type == 2 ? "No Entity" : (this.cd_type == 3 ? "Close" : (this.cd_type == 4 ? "Content-Length" : (this.cd_type == 5 ? "Chunked" : (this.cd_type == 6 ? "Multipart" : "???"))))) + " (" + this.inp_stream.hashCode() + ")");
        if (this.connection.ServerProtocolVersion >= 65537) {
            this.deleteHeader("Proxy-Connection");
        } else {
            String name;
            Vector pco;
            if (this.connection.getProxyHost() != null) {
                this.deleteHeader("Connection");
            } else {
                this.deleteHeader("Proxy-Connection");
            }
            try {
                pco = Util.parseHeader((String)this.Headers.get("Connection"));
            }
            catch (ParseException pe) {
                pco = null;
            }
            if (pco != null) {
                for (int idx = 0; idx < pco.size(); ++idx) {
                    name = ((HttpHeaderElement)pco.elementAt(idx)).getName();
                    if (name.equalsIgnoreCase("keep-alive")) continue;
                    pco.removeElementAt(idx);
                    this.deleteHeader(name);
                    --idx;
                }
                if (pco.size() > 0) {
                    this.setHeader("Connection", Util.assembleHeader(pco));
                } else {
                    this.deleteHeader("Connection");
                }
            }
            try {
                pco = Util.parseHeader((String)this.Headers.get("Proxy-Connection"));
            }
            catch (ParseException pe) {
                pco = null;
            }
            if (pco != null) {
                for (int idx = 0; idx < pco.size(); ++idx) {
                    name = ((HttpHeaderElement)pco.elementAt(idx)).getName();
                    if (name.equalsIgnoreCase("keep-alive")) continue;
                    pco.removeElementAt(idx);
                    this.deleteHeader(name);
                    --idx;
                }
                if (pco.size() > 0) {
                    this.setHeader("Proxy-Connection", Util.assembleHeader(pco));
                } else {
                    this.deleteHeader("Proxy-Connection");
                }
            }
        }
        this.got_headers = true;
        if (this.isFirstResponse && !this.connection.handleFirstRequest(this.req, this)) {
            Response resp;
            try {
                resp = this.connection.sendRequest(this.req, this.timeout);
            }
            catch (ModuleException me) {
                throw new IOException(me.toString());
            }
            resp.getVersion();
            this.StatusCode = resp.StatusCode;
            this.ReasonLine = resp.ReasonLine;
            this.Version = resp.Version;
            this.EffectiveURI = resp.EffectiveURI;
            this.ContentLength = resp.ContentLength;
            this.Headers = resp.Headers;
            this.inp_stream = resp.inp_stream;
            this.Data = resp.Data;
            this.req = null;
        }
    }

    private String readResponseHeaders(InputStream inp) throws IOException {
        if (this.buf_pos == 0) {
            logger.log(Level.FINE, "Resp:  Reading Response headers {0}", Integer.toString(this.inp_stream.hashCode()));
        } else {
            logger.log(Level.FINE, "Resp:  Resuming reading Response headers {0}", Integer.toString(this.inp_stream.hashCode()));
        }
        if (!this.reading_lines) {
            try {
                if (this.buf_pos == 0) {
                    int c;
                    do {
                        if ((c = inp.read()) != -1) continue;
                        throw new EOFException("Encountered premature EOF while reading Version");
                    } while (Character.isWhitespace((char)c));
                    this.buf[0] = (byte)c;
                    this.buf_pos = 1;
                }
                while (this.buf_pos < this.buf.length) {
                    int got = inp.read(this.buf, this.buf_pos, this.buf.length - this.buf_pos);
                    if (got == -1) {
                        throw new EOFException("Encountered premature EOF while reading Version");
                    }
                    this.buf_pos += got;
                }
            }
            catch (EOFException eof) {
                logger.log(Level.WARNING, "Resp:  ({0}) {1}", new Object[]{Integer.toString(this.inp_stream.hashCode()), eof});
                throw eof;
            }
            for (int idx = 0; idx < this.buf.length; ++idx) {
                this.hdrs.append((char)this.buf[idx]);
            }
            this.reading_lines = true;
        }
        if (this.hdrs.toString().startsWith("HTTP/") || this.hdrs.toString().startsWith("HTTP ")) {
            this.readLines(inp);
        }
        this.buf_pos = 0;
        this.reading_lines = false;
        this.bol = true;
        this.got_cr = false;
        String tmp = this.hdrs.toString();
        this.hdrs.setLength(0);
        return tmp;
    }

    void readTrailers(InputStream inp) throws IOException {
        try {
            this.readLines(inp);
            this.trailers_read = true;
        }
        catch (IOException ioe) {
            if (!(ioe instanceof InterruptedIOException)) {
                this.exception = ioe;
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLines(InputStream inp) throws IOException {
        InputStream inputStream = inp;
        synchronized (inputStream) {
            int bytesRead = 0;
            int bytesProcessed = 0;
            block9: while (true) {
                if ((bytesRead = inp.read(this.headerBuffer, 0, this.headerBuffer.length)) == -1) {
                    throw new EOFException("Encountered premature EOF while reading headers:\n" + this.hdrs);
                }
                bytesProcessed = 0;
                int i = 0;
                while (true) {
                    if (i >= bytesRead) continue block9;
                    byte b = this.headerBuffer[i];
                    switch (b) {
                        case -1: {
                            throw new EOFException("Encountered premature EOF while reading headers:\n" + this.hdrs);
                        }
                        case 13: {
                            this.got_cr = true;
                            break;
                        }
                        case 10: {
                            if (this.bol) break block9;
                            this.hdrs.append('\n');
                            this.bol = true;
                            this.got_cr = false;
                            break;
                        }
                        case 9: 
                        case 32: {
                            if (this.bol) {
                                this.hdrs.setCharAt(this.hdrs.length() - 1, ' ');
                                this.bol = false;
                                break;
                            }
                        }
                        default: {
                            if (this.got_cr) {
                                this.hdrs.append('\r');
                                this.got_cr = false;
                            }
                            this.hdrs.append((char)(b & 0xFF));
                            this.bol = false;
                        }
                    }
                    ++bytesProcessed;
                    ++i;
                }
                break;
            }
            if (bytesRead > ++bytesProcessed) {
                if (inp instanceof IPushBackInputStream) {
                    IPushBackInputStream inputStream2 = (IPushBackInputStream)((Object)inp);
                    inputStream2.unread(this.headerBuffer, bytesProcessed, bytesRead - bytesProcessed);
                } else {
                    throw new IOException("Incorrect stream type, doesn't allow push back of bytes");
                }
            }
        }
    }

    private void parseResponseHeaders(String headers) throws ProtocolException {
        StringTokenizer elem;
        String sts_line = null;
        StringTokenizer lines = new StringTokenizer(headers, "\r\n");
        logger.log(Level.FINE, "Resp:  Parsing Response headers from Request {0} {1}: ({2})\n{3}", new Object[]{this.method, this.resource, Integer.toString(this.inp_stream.hashCode()), headers});
        if (!headers.regionMatches(true, 0, "HTTP/", 0, 5) && !headers.regionMatches(true, 0, "HTTP ", 0, 5)) {
            this.Version = "HTTP/0.9";
            this.StatusCode = 200;
            this.ReasonLine = "OK";
            try {
                this.Data = headers.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            return;
        }
        try {
            sts_line = lines.nextToken();
            elem = new StringTokenizer(sts_line, " \t");
            this.Version = elem.nextToken();
            this.StatusCode = Integer.valueOf(elem.nextToken());
            if (this.Version.equalsIgnoreCase("HTTP")) {
                this.Version = "HTTP/1.0";
            }
        }
        catch (NoSuchElementException e) {
            throw new ProtocolException("Invalid HTTP status line received: " + sts_line);
        }
        try {
            this.ReasonLine = elem.nextToken("").trim();
        }
        catch (NoSuchElementException e) {
            this.ReasonLine = "";
        }
        this.parseHeaderFields(lines, this.Headers);
        if (this.StatusCode >= 300 && this.sent_entity) {
            AuthorizationHandler authHandler;
            boolean closeIt = true;
            if ((401 == this.StatusCode || 407 == this.StatusCode) && (authHandler = AuthorizationInfo.getAuthHandler()) instanceof AuthenticationSchemeRegistryHolder) {
                boolean forProxy;
                AuthenticationSchemeRegistryHolder registryHolder = (AuthenticationSchemeRegistryHolder)((Object)authHandler);
                AuthenticationSchemeRegistry registry = registryHolder.getAuthenticationSchemeRegistry();
                boolean bl = forProxy = 407 == this.StatusCode;
                if (registry.isAnyAuthChallengeConnectionOriented(this.Headers, forProxy)) {
                    closeIt = false;
                }
            }
            if (closeIt && this.stream_handler != null) {
                this.stream_handler.markForClose(this);
            }
        }
        if (this.Headers.get("Trailer") != null && this.resp_inp_stream != null) {
            this.resp_inp_stream.dontTruncate();
        }
        boolean vers = !this.Version.equalsIgnoreCase("HTTP/0.9") && !this.Version.equalsIgnoreCase("HTTP/1.0");
        try {
            String con = (String)this.Headers.get("Connection");
            String pcon = (String)this.Headers.get("Proxy-Connection");
            if (!((!vers || con == null || !Util.hasToken(con, "close")) && (vers || !this.used_proxy && con != null && Util.hasToken(con, "keep-alive") || this.used_proxy && pcon != null && Util.hasToken(pcon, "keep-alive")) || this.stream_handler == null)) {
                this.stream_handler.markForClose(this);
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getTrailers() throws IOException {
        if (this.got_trailers) {
            return;
        }
        if (this.exception != null) {
            this.exception.fillInStackTrace();
            throw this.exception;
        }
        logger.log(Level.FINE, "Resp:  Reading Response trailers {0}", Integer.toString(this.inp_stream.hashCode()));
        try {
            if (!this.trailers_read && this.resp_inp_stream != null) {
                this.resp_inp_stream.readAll(this.timeout.read);
            }
            if (this.trailers_read) {
                logger.log(Level.FINE, "Resp:  Parsing Response trailers from Request \"{0} {1}\":  ({2})\n\n{3}", new Object[]{this.method, this.resource, Integer.toString(this.inp_stream.hashCode()), this.hdrs});
                this.parseHeaderFields(new StringTokenizer(this.hdrs.toString(), "\r\n"), this.Trailers);
            }
        }
        finally {
            this.got_trailers = true;
        }
    }

    private void parseHeaderFields(StringTokenizer lines, CIHashtable list) throws ProtocolException {
        while (lines.hasMoreTokens()) {
            String hdr = lines.nextToken();
            int sep = hdr.indexOf(58);
            if (sep == -1) {
                sep = hdr.indexOf(32);
            }
            if (sep == -1) {
                throw new ProtocolException("Invalid HTTP header received: " + hdr);
            }
            String hdr_name = hdr.substring(0, sep).trim();
            String hdr_value = hdr.substring(sep + 1).trim();
            if (!singleValueHeaders.containsKey(hdr_name.toLowerCase())) {
                String old_value = (String)list.get(hdr_name);
                if (old_value == null) {
                    list.put(hdr_name, hdr_value);
                    continue;
                }
                list.put(hdr_name, old_value + ", " + hdr_value);
                continue;
            }
            list.put(hdr_name, hdr_value);
        }
    }

    private void readResponseData(InputStream inp) throws IOException {
        block14: {
            if (this.ContentLength == 0) {
                return;
            }
            if (this.Data == null) {
                this.Data = new byte[0];
            }
            int off = this.Data.length;
            try {
                if (this.getHeader("Content-Length") != null) {
                    int rcvd = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((rcvd = inp.read(this.Data, off += rcvd, this.ContentLength - off)) != -1) {
                        if (off + rcvd < this.ContentLength) continue;
                        break block14;
                    }
                    break block14;
                }
                int inc = 1000;
                int rcvd = 0;
                do {
                    this.Data = Util.resizeArray(this.Data, (off += rcvd) + inc);
                } while ((rcvd = inp.read(this.Data, off, inc)) != -1);
                this.Data = Util.resizeArray(this.Data, off);
            }
            catch (IOException ioe) {
                this.Data = Util.resizeArray(this.Data, off);
                throw ioe;
            }
            finally {
                try {
                    inp.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    void markAsFirstResponse(Request req) {
        this.req = req;
        this.isFirstResponse = true;
    }

    public Object clone() {
        Response cl;
        try {
            cl = (Response)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
        cl.Headers = (CIHashtable)this.Headers.clone();
        cl.Trailers = (CIHashtable)this.Trailers.clone();
        return cl;
    }

    static {
        logger = HttpClientLoggerFactory.getLogger();
        String[] singleValueHeaderNames = new String[]{"age", "location", "content-base", "content-length", "content-location", "content-md5", "content-range", "content-type", "date", "etag", "expires", "retry-after"};
        singleValueHeaders = new HashMap(singleValueHeaderNames.length);
        for (int idx = 0; idx < singleValueHeaderNames.length; ++idx) {
            singleValueHeaders.put(singleValueHeaderNames[idx], singleValueHeaderNames[idx]);
        }
    }
}

