/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpOutputStream;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class RedirectionModule
implements HTTPClientModule {
    private static WeakHashMap perm_redir_cntxt_list = new WeakHashMap();
    private static Hashtable deferred_redir_list = new Hashtable();
    private int level = 0;
    private URI lastURI = null;
    private boolean new_con;
    private Request saved_req = null;
    private static Logger logger = HttpClientLoggerFactory.getLogger();

    RedirectionModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        URI cur_loc;
        HTTPConnection con = req.getConnection();
        HttpOutputStream out = req.getStream();
        if (out != null && deferred_redir_list.get(out) != null) {
            this.copyFrom((RedirectionModule)deferred_redir_list.remove(out));
            req.copyFrom(this.saved_req);
            if (this.new_con) {
                return 5;
            }
            return 1;
        }
        try {
            cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
        }
        catch (ParseException pe) {
            throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'");
        }
        Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, req.getConnection().getContext());
        URI new_loc = (URI)perm_redir_list.get(cur_loc);
        if (new_loc != null) {
            String nres = new_loc.getPathAndQuery();
            req.setRequestURI(nres);
            try {
                this.lastURI = new URI(new_loc, nres);
            }
            catch (ParseException pe) {
                // empty catch block
            }
            logger.log(Level.FINE, "RdirM: matched request in permanent redirection list - redoing request to {0}", this.lastURI.toExternalForm());
            if (!con.isCompatibleWith(new_loc)) {
                try {
                    con = new HTTPConnection(new_loc);
                }
                catch (Exception e) {
                    throw new Error("HTTPClient Internal Error: unexpected exception '" + e + "'");
                }
                con.setSSL(req.getConnection().getSSL());
                con.setContext(req.getConnection().getContext());
                con.setCurrentProxy(req.getConnection().getProxyHost(), req.getConnection().getProxyPort());
                req.setConnection(con);
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        int sts = resp.getStatusCode();
        if ((sts < 301 || sts > 307 || sts == 304) && this.lastURI != null) {
            resp.setEffectiveURI(this.lastURI);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 302: {
                if (req.getMethod().equals("POST") || req.getMethod().equals("PUT")) {
                    logger.log(Level.FINE, "RdirM: Received status: {0} {1} - treating as 303", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                    sts = 303;
                }
            }
            case 301: 
            case 303: 
            case 307: {
                logger.log(Level.FINE, "RdirM: Handling status: {0} {1}", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                if (!req.getMethod().equals("GET") && !req.getMethod().equals("HEAD") && sts != 303) {
                    logger.log(Level.FINE, "RdirM: not redirected because method is neither HEAD nor GET");
                    if (sts == 301 && resp.getHeader("Location") != null) {
                        RedirectionModule.update_perm_redir_list(req, this.resLocHdr(resp.getHeader("Location"), req));
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
            }
            case 305: 
            case 306: {
                String nres;
                HTTPConnection mvd;
                if (sts == 305 || sts == 306) {
                    logger.log(Level.FINE, "RdirM: Handling status: {0} {1}", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                }
                if (sts == 305 && req.getConnection().getProxyHost() != null) {
                    logger.log(Level.FINE, "RdirM: 305 ignored because a proxy is already in use");
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                if (this.level >= 15 || resp.getHeader("Location") == null) {
                    if (this.level >= 15) {
                        logger.log(Level.FINE, "RdirM: not redirected because of too many levels of redirection");
                    } else {
                        logger.log(Level.FINE, "RdirM: not redirected because no Location header was present");
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                ++this.level;
                URI newLocation = this.resLocHdr(resp.getHeader("Location"), req);
                this.new_con = false;
                if (sts == 305) {
                    mvd = new HTTPConnection(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort());
                    if (newLocation.getScheme().equalsIgnoreCase("https")) {
                        mvd.setSSL(req.getConnection().getSSL());
                    }
                    mvd.setCurrentProxy(newLocation.getHost(), newLocation.getPort());
                    mvd.setContext(req.getConnection().getContext());
                    this.new_con = true;
                    nres = req.getRequestURI();
                    req.setMethod("GET");
                    req.setData(null);
                    req.setStream(null);
                } else {
                    if (sts == 306) {
                        return 10;
                    }
                    if (req.getConnection().isCompatibleWith(newLocation)) {
                        mvd = req.getConnection();
                        nres = newLocation.getPathAndQuery();
                    } else {
                        try {
                            mvd = new HTTPConnection(newLocation);
                            if (newLocation.getScheme().equalsIgnoreCase("https")) {
                                mvd.setSSL(req.getConnection().getSSL());
                            }
                            String host = req.getConnection().getProxyHost();
                            int port = req.getConnection().getProxyPort();
                            mvd.setCurrentProxy(host, port);
                            nres = newLocation.getPathAndQuery();
                        }
                        catch (Exception e) {
                            if (req.getConnection().getProxyHost() == null || !newLocation.getScheme().equalsIgnoreCase("ftp")) {
                                return 10;
                            }
                            mvd = new HTTPConnection("http", req.getConnection().getProxyHost(), req.getConnection().getProxyPort());
                            if (newLocation.getScheme().equalsIgnoreCase("https")) {
                                mvd.setSSL(req.getConnection().getSSL());
                            }
                            mvd.setCurrentProxy(null, 0);
                            nres = newLocation.toExternalForm();
                        }
                        mvd.setContext(req.getConnection().getContext());
                        this.new_con = true;
                    }
                    if (sts == 303) {
                        if (!req.getMethod().equals("HEAD")) {
                            req.setMethod("GET");
                        }
                        req.setData(null);
                        req.setStream(null);
                    } else {
                        if (req.getStream() != null) {
                            if (!HttpClientConfiguration.getDeferStreamed()) {
                                logger.log(Level.FINE, "RdirM: status {0} not handled - request has an output stream", Integer.toString(sts));
                                return 10;
                            }
                            this.saved_req = (Request)req.clone();
                            deferred_redir_list.put(req.getStream(), this);
                            req.getStream().reset();
                            resp.setRetryRequest(true);
                        }
                        if (sts == 301) {
                            try {
                                RedirectionModule.update_perm_redir_list(req, new URI(newLocation, nres));
                            }
                            catch (ParseException pe) {
                                throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'");
                            }
                        }
                    }
                    NVPair[] hdrs = req.getHeaders();
                    for (int idx = 0; idx < hdrs.length; ++idx) {
                        if (!hdrs[idx].getName().equalsIgnoreCase("Referer")) continue;
                        HTTPConnection con = req.getConnection();
                        hdrs[idx] = new NVPair("Referer", con + req.getRequestURI());
                        break;
                    }
                }
                if (this.new_con) {
                    int numOfConnections = resp.getPhysicalConnections() + 1;
                    resp.setPhysicalConnections(numOfConnections);
                    logger.log(Level.FINE, "Incrementing connection count due to redirection, count = {0}", Integer.toString(resp.getPhysicalConnections()));
                }
                req.setConnection(mvd);
                req.setRequestURI(nres);
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (sts != 305 && sts != 306) {
                    try {
                        this.lastURI = new URI(newLocation, nres);
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                    logger.log(Level.FINE, "RdirM: request redirected to {0} using method {1}", new Object[]{this.lastURI.toExternalForm(), req.getMethod()});
                } else {
                    logger.log(Level.FINE, "RdirM: resending request using proxy {0}:{1}", new Object[]{mvd.getProxyHost(), Integer.toString(mvd.getProxyPort())});
                }
                if (req.getStream() != null) {
                    return 10;
                }
                if (this.new_con) {
                    return 15;
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private static void update_perm_redir_list(RoRequest req, URI new_loc) {
        HTTPConnection con = req.getConnection();
        URI cur_loc = null;
        try {
            cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (!cur_loc.equals(new_loc)) {
            Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, con.getContext());
            perm_redir_list.put(cur_loc, new_loc);
        }
    }

    private URI resLocHdr(String loc, RoRequest req) throws ProtocolException {
        try {
            URI base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), null);
            base = new URI(base, req.getRequestURI());
            URI res = new URI(base, loc);
            if (res.getHost() == null) {
                throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - missing host field");
            }
            return res;
        }
        catch (ParseException pe) {
            throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - exception was: " + pe.getMessage());
        }
    }

    private void copyFrom(RedirectionModule other) {
        this.level = other.level;
        this.lastURI = other.lastURI;
        this.saved_req = other.saved_req;
    }
}

