/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import HTTPClient.Util;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;

final class QuotedPrintableEncoder {
    private static final BitSet EBCDICUnsafeChar = new BitSet(256);

    private QuotedPrintableEncoder() {
    }

    static final String encode(String str) {
        if (str == null) {
            return null;
        }
        char[] map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] nl = QuotedPrintableEncoder.getPrivilegedPropertywithDefault("line.separator", "\n").toCharArray();
        char[] res = new char[(int)((double)str.length() * 1.5)];
        char[] src = str.toCharArray();
        int cnt = 0;
        int didx = 1;
        boolean last = false;
        int slen = str.length();
        for (int sidx = 0; sidx < slen; ++sidx) {
            char ch = src[sidx];
            if (ch == nl[0] && QuotedPrintableEncoder.match(src, sidx, nl)) {
                if (res[didx - 1] == ' ') {
                    res[didx - 1] = 61;
                    res[didx++] = 50;
                    res[didx++] = 48;
                } else if (res[didx - 1] == '\t') {
                    res[didx - 1] = 61;
                    res[didx++] = 48;
                    res[didx++] = 57;
                }
                res[didx++] = 13;
                res[didx++] = 10;
                sidx += nl.length - 1;
                cnt = didx;
            } else if (ch > '~' || ch < ' ' && ch != '\t' || ch == '=' || EBCDICUnsafeChar.get(ch)) {
                res[didx++] = 61;
                res[didx++] = map[(ch & 0xF0) >>> 4];
                res[didx++] = map[ch & 0xF];
            } else {
                res[didx++] = ch;
            }
            if (didx > cnt + 70) {
                res[didx++] = 61;
                res[didx++] = 13;
                res[didx++] = 10;
                cnt = didx;
            }
            if (didx <= res.length - 5) continue;
            res = Util.resizeArray(res, res.length + 500);
        }
        return String.valueOf(res, 1, didx - 1);
    }

    static final String decode(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        char[] res = new char[(int)((double)str.length() * 1.1)];
        char[] src = str.toCharArray();
        char[] nl = QuotedPrintableEncoder.getPrivilegedPropertywithDefault("line.separator", "\n").toCharArray();
        int last = 0;
        int didx = 0;
        int slen = str.length();
        int sidx = 0;
        while (sidx < slen) {
            char ch;
            if ((ch = src[sidx++]) == '=') {
                if (sidx >= slen - 1) {
                    throw new ParseException("Premature end of input detected");
                }
                if (src[sidx] == '\n' || src[sidx] == '\r') {
                    if (src[++sidx - 1] == '\r' && src[sidx] == '\n') {
                        ++sidx;
                    }
                } else {
                    int lo;
                    int hi = Character.digit(src[sidx], 16);
                    if ((hi | (lo = Character.digit(src[sidx + 1], 16))) < 0) {
                        throw new ParseException(new String(src, sidx - 1, 3) + " is an invalid code");
                    }
                    char repl = (char)(hi << 4 | lo);
                    sidx += 2;
                    res[didx++] = repl;
                }
                last = didx;
            } else if (ch == '\n' || ch == '\r') {
                if (ch == '\r' && sidx < slen && src[sidx] == '\n') {
                    ++sidx;
                }
                for (int idx = 0; idx < nl.length; ++idx) {
                    res[last++] = nl[idx];
                }
                didx = last;
            } else {
                res[didx++] = ch;
                if (ch != ' ' && ch != '\t') {
                    last = didx;
                }
            }
            if (didx <= res.length - nl.length - 2) continue;
            res = Util.resizeArray(res, res.length + 500);
        }
        return new String(res, 0, didx);
    }

    private static final boolean match(char[] str, int start, char[] arr) {
        if (str.length < start + arr.length) {
            return false;
        }
        for (int idx = 1; idx < arr.length; ++idx) {
            if (str[start + idx] == arr[idx]) continue;
            return false;
        }
        return true;
    }

    private static String getPrivilegedPropertywithDefault(final String name, final String defaultValue) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
    }

    static {
        EBCDICUnsafeChar.set(33);
        EBCDICUnsafeChar.set(34);
        EBCDICUnsafeChar.set(35);
        EBCDICUnsafeChar.set(36);
        EBCDICUnsafeChar.set(64);
        EBCDICUnsafeChar.set(91);
        EBCDICUnsafeChar.set(92);
        EBCDICUnsafeChar.set(93);
        EBCDICUnsafeChar.set(94);
        EBCDICUnsafeChar.set(96);
        EBCDICUnsafeChar.set(123);
        EBCDICUnsafeChar.set(124);
        EBCDICUnsafeChar.set(125);
        EBCDICUnsafeChar.set(126);
    }
}

