/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientSSL;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.JWalletCertificateProxy;
import HTTPClient.JWalletPersonaProxy;
import HTTPClient.JWalletPvtKeyProxy;
import HTTPClient.OracleSSLCredentialProxy;
import HTTPClient.OracleSSLSocketFactoryImplProxy;
import HTTPClient.OracleSSLSocketFactoryProxy;
import HTTPClient.TxtWalletReaderProxy;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class OracleSSL
implements HTTPClientSSL {
    private OracleSSLCredentialProxy m_sslCredObjProxy;
    private boolean m_isDefaultCredential = true;
    private OracleSSLSocketFactoryImplProxy m_sslSocketFactoryProxy = null;
    private SSLSocket m_sslSock = null;
    private String[] m_sslEnabledCipherSuites = null;
    protected boolean m_assumeOracleSSL = true;
    private static Logger logger = HttpClientLoggerFactory.getLogger();
    private static String sm_sCachedLocation = null;
    private static long sm_lLastModifiedDate = 0L;
    private static TxtWalletReaderProxy sm_WalletReaderProxy = null;

    static boolean loadOracleSSLClasses(URL optionalUrl, boolean silently) throws RuntimeException {
        boolean isSuccessTemp = false;
        boolean isSuccess = true;
        isSuccessTemp = JWalletCertificateProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = JWalletPersonaProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = JWalletPvtKeyProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = OracleSSLCredentialProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = OracleSSLSocketFactoryImplProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = OracleSSLSocketFactoryProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        isSuccessTemp = TxtWalletReaderProxy.loadClass(optionalUrl, silently);
        isSuccess = isSuccess && isSuccessTemp;
        return isSuccess;
    }

    OracleSSLCredentialProxy getCredentialProxy() {
        if (this.m_sslCredObjProxy == null) {
            this.m_sslCredObjProxy = (OracleSSLCredentialProxy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new OracleSSLCredentialProxy();
                }
            });
        }
        return this.m_sslCredObjProxy;
    }

    OracleSSL(SSLSocketFactory factory) {
        this.initHttps(factory);
    }

    void initHttps(SSLSocketFactory factory) {
        if (factory == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    OracleSSL.this.m_sslSocketFactoryProxy = new OracleSSLSocketFactoryImplProxy();
                    return null;
                }
            });
        } else {
            OracleSSLSocketFactoryImplProxy proxy;
            this.m_sslSocketFactoryProxy = proxy = new OracleSSLSocketFactoryImplProxy(factory);
        }
        this.m_sslEnabledCipherSuites = this.getSSLDefaultCipherSuites();
    }

    private String[] getSSLDefaultCipherSuites() {
        String ciphers = OracleSSL.getPrivilegedPropertywithDefault("Oracle.ssl.defaultCipherSuites", "");
        if (ciphers.equals("")) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SSLSocketFactory sslSocketfactory = OracleSSL.this.m_sslSocketFactoryProxy.getSSLSocketFactory();
                    return sslSocketfactory.getSupportedCipherSuites();
                }
            });
        }
        StreamTokenizer strTok = new StreamTokenizer(new StringReader(ciphers));
        strTok.wordChars(95, 95);
        SSLSocketFactory sslSocketfactory = this.m_sslSocketFactoryProxy.getSSLSocketFactory();
        String[] supportedCiphers = sslSocketfactory.getDefaultCipherSuites();
        Vector<String> defaultCipherSuitesV = new Vector<String>();
        try {
            while (strTok.nextToken() != -1) {
                if (strTok.ttype != -3) continue;
                String suite = strTok.sval;
                for (int j = 0; j < supportedCiphers.length; ++j) {
                    if (!suite.equals(supportedCiphers[j])) continue;
                    defaultCipherSuitesV.addElement(suite);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] defaultCipherSuitesA = new String[defaultCipherSuitesV.size()];
        defaultCipherSuitesV.toArray(defaultCipherSuitesA);
        return defaultCipherSuitesA;
    }

    public String[] getSSLEnabledCipherSuites() {
        return (String[])this.m_sslEnabledCipherSuites.clone();
    }

    public SSLSession getSSLSession() {
        if (this.m_sslSock != null) {
            return this.m_sslSock.getSession();
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (null != this.m_sslSocketFactoryProxy) {
            return this.m_sslSocketFactoryProxy.getSSLSocketFactory();
        }
        return null;
    }

    void initDefaultSSLCredential() {
        final String loc = OracleSSL.getPrivilegedPropertywithDefault("javax.net.ssl.KeyStore", "");
        logger.log(Level.FINE, "Using wallet: {0}", loc);
        String pass = OracleSSL.getPrivilegedPropertywithDefault("javax.net.ssl.KeyStorePassword", "");
        Long templLastModified = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Long l = new Long(new File(loc).lastModified());
                return l;
            }
        });
        long lLastModified = templLastModified;
        if (loc.equals("")) {
            sm_sCachedLocation = null;
            sm_lLastModifiedDate = 0L;
            sm_WalletReaderProxy = null;
            return;
        }
        if (!loc.equals(sm_sCachedLocation) || sm_lLastModifiedDate != lLastModified) {
            sm_sCachedLocation = loc;
            sm_lLastModifiedDate = lLastModified;
            sm_WalletReaderProxy = new TxtWalletReaderProxy(loc, pass);
        }
        OracleSSLCredentialProxy cred = this.getCredentialProxy();
        JWalletPersonaProxy personaObj = sm_WalletReaderProxy.getPersonaByIndex(0);
        int tpCount = personaObj.getTrustedCertCount();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "OracleSSL: Trusted cert count=" + tpCount);
        }
        JWalletCertificateProxy tpcert = null;
        for (int i = 0; i < tpCount; ++i) {
            tpcert = personaObj.getTrustedCertByIndex(i);
            cred.addTrustedCert(tpcert.getCertData());
        }
        JWalletPvtKeyProxy pKeyObj = personaObj.getPrivateKey();
        if (pKeyObj != null) {
            byte[] pvkey = pKeyObj.getPvtKeyData();
            if (pvkey != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "OracleSSL: Have private key data");
                }
                cred.setPrivateKey(pKeyObj.getPvtKeyData(), pass);
            }
            int certCount = personaObj.getCertChainCount();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "OracleSSL: Cert chain count=" + certCount);
            }
            JWalletCertificateProxy usrcert = null;
            for (int i = certCount; i > 0; --i) {
                usrcert = personaObj.getCertChainByIndex(i - 1);
                cred.addCertChain(usrcert.getCertData());
            }
        }
    }

    Socket getSSLSocket(Socket proxy) throws IOException {
        if (this.m_isDefaultCredential) {
            this.initDefaultSSLCredential();
        }
        this.m_sslSocketFactoryProxy.setSSLCredentials(this.getCredentialProxy());
        this.m_sslSock = (SSLSocket)this.m_sslSocketFactoryProxy.createSocket(proxy);
        this.m_sslSock.setEnabledCipherSuites(this.m_sslEnabledCipherSuites);
        this.m_sslSock.startHandshake();
        return this.m_sslSock;
    }

    public Socket getSSLSocket(Socket proxy, String host, int port) throws IOException {
        return this.getSSLSocket(proxy);
    }

    public void setSSLCredentialProxy(OracleSSLCredentialProxy sslCredentialProxy) {
        this.m_sslCredObjProxy = sslCredentialProxy;
        this.m_isDefaultCredential = false;
    }

    public void setSSLEnabledCipherSuites(String[] cipherSuites) throws IllegalArgumentException {
        if (this.m_sslSocketFactoryProxy != null) {
            String[] supportedCiphers = this.m_sslSocketFactoryProxy.getSSLSocketFactory().getSupportedCipherSuites();
            for (int i = 0; i < cipherSuites.length; ++i) {
                boolean isSupported = false;
                for (int j = 0; j < supportedCiphers.length && !isSupported; ++j) {
                    if (!cipherSuites[i].equals(supportedCiphers[j])) continue;
                    isSupported = true;
                }
                if (isSupported) continue;
                throw new IllegalArgumentException("Cipher " + cipherSuites[i] + " is not supported ");
            }
            this.m_sslEnabledCipherSuites = (String[])cipherSuites.clone();
        }
    }

    private static String getPrivilegedPropertywithDefault(final String name, final String defaultValue) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
    }
}

