/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.OptionalClassProxyException;
import HTTPClient.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class OptionalClassProxy {
    private static Logger logger = HttpClientLoggerFactory.getLogger(OptionalClassProxy.class.getName());
    private Object proxiedObject = null;
    private static boolean isAllEnabled = true;
    protected static final boolean IS_VALID = true;
    protected static final boolean SILENTLY = true;
    protected static final boolean NULL_OK = true;
    private static Hashtable url_to_classLoader_map = new Hashtable(10);
    private static Hashtable validProxiesMap = new Hashtable(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLClassLoader getUrlClassloader(URL url) {
        if (null == url) {
            throw new IllegalArgumentException("Non-null URL object expected.");
        }
        URLClassLoader loader = (URLClassLoader)url_to_classLoader_map.get(url);
        if (null == loader) {
            Hashtable hashtable = url_to_classLoader_map;
            synchronized (hashtable) {
                loader = (URLClassLoader)url_to_classLoader_map.get(url);
                if (null == loader) {
                    loader = Util.newPrivilegedURLClassLoader(new URL[]{url});
                    url_to_classLoader_map.put(url, loader);
                }
            }
        }
        return loader;
    }

    private static Class getValidProxy(Class proxySubclass) {
        if (null == proxySubclass) {
            throw new IllegalArgumentException("Non-null proxy subclass expected.");
        }
        return (Class)validProxiesMap.get(proxySubclass);
    }

    private static void setValidProxy(Class proxySubclass, Class proxiedClass) {
        if (null == proxySubclass) {
            throw new IllegalArgumentException("Non-null proxy subclass expected.");
        }
        if (null == proxiedClass) {
            throw new IllegalArgumentException("Non-null proxied class expected.");
        }
        validProxiesMap.put(proxySubclass, proxiedClass);
    }

    static Class loadClass(String className, URL classUrl) throws Exception {
        Class<?> output;
        if (null == className || "".equals(className)) {
            throw new IllegalArgumentException("Non-null and non-empty className expected.");
        }
        ClassLoader loader = null;
        loader = null == classUrl ? OptionalClassProxy.class.getClassLoader() : OptionalClassProxy.getUrlClassloader(classUrl);
        if (null == loader) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (null == (output = loader.loadClass(className))) {
            throw new NullPointerException("loadClass returned null for '" + className + "'.");
        }
        return output;
    }

    protected static boolean loadClass(ProxyMetaData proxyMetaData, MethodValidator methodValidator, URL optionalUrl, boolean silently) throws RuntimeException, IllegalArgumentException {
        block6: {
            if (null == proxyMetaData) {
                throw new IllegalArgumentException("Non-null proxy meta data expected.");
            }
            Class proxiedClass = OptionalClassProxy.getValidProxy(proxyMetaData.getProxySubclass());
            if (null == proxiedClass) {
                try {
                    proxiedClass = OptionalClassProxy.loadClass(proxyMetaData.getProxiedClassName(), optionalUrl);
                    if (null != methodValidator) {
                        methodValidator.validate(proxiedClass);
                    }
                    OptionalClassProxy.setValidProxy(proxyMetaData.getProxySubclass(), proxiedClass);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Unable to initialize proxy for '" + proxyMetaData.getProxiedClassName() + "'.", e);
                    }
                    if (silently) break block6;
                    throw new RuntimeException("Unable to initialize proxy for '" + proxyMetaData.getProxiedClassName() + "'.", e);
                }
            }
        }
        return OptionalClassProxy.isValid(proxyMetaData.getProxySubclass());
    }

    protected static Method getMethod(final Class containingClass, final String methodName, final Class[] methodFormalParameters) throws Exception {
        if (null == containingClass) {
            throw new IllegalArgumentException("Non-null containingClass expected.");
        }
        if (null == methodName || "".equals(methodName)) {
            throw new IllegalArgumentException("Non-null, non-empty methodName expected.");
        }
        Method output = null;
        try {
            output = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return containingClass.getMethod(methodName, methodFormalParameters);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getException();
        }
        if (null == output) {
            throw new NullPointerException("getMethod returned null for '" + Util.formatMethodSignature(methodName, methodFormalParameters) + "' of class '" + containingClass.getName() + "'.");
        }
        return output;
    }

    protected static Constructor getConstructor(Class containingClass, Class[] formalParameters) throws Exception {
        if (null == containingClass) {
            throw new IllegalArgumentException("Non-null containingClass expected.");
        }
        Constructor output = containingClass.getConstructor(formalParameters);
        if (null == output) {
            throw new NullPointerException("getConstructor returned null for '" + Util.formatMethodSignature(containingClass.getName(), formalParameters) + "'.");
        }
        return output;
    }

    protected OptionalClassProxy(ProxyMetaData proxyMetaData, Object proxiedObject) throws OptionalClassProxyException, IllegalArgumentException {
        if (null == proxyMetaData) {
            throw new IllegalArgumentException("Non-null proxy meta data expected.");
        }
        if (null == proxiedObject) {
            throw new IllegalArgumentException("Expected proxiedObject to be a non-null instance of the proxied class '" + proxyMetaData.getProxiedClassName() + "'.");
        }
        if (!OptionalClassProxy.isInstance(proxyMetaData.getProxySubclass(), proxiedObject)) {
            throw new IllegalArgumentException("Given object is an instance of class '" + proxiedObject.getClass().getName() + "', which is not an instance of the proxied class '" + proxyMetaData.getProxiedClassName() + "'.");
        }
        this.proxiedObject = proxiedObject;
    }

    protected OptionalClassProxy(ProxyMetaData proxyMetaData) throws OptionalClassProxyException, IllegalArgumentException {
        this(proxyMetaData, null, null);
    }

    protected OptionalClassProxy(ProxyMetaData proxyMetaData, Constructor constructor, Object[] proxiedClassConstructorActualParameters) throws OptionalClassProxyException, IllegalArgumentException {
        OptionalClassProxy.checkValid(proxyMetaData.getProxySubclass());
        Class proxiedClass = OptionalClassProxy.getProxiedClass(proxyMetaData.getProxySubclass());
        if (null != constructor && !constructor.getDeclaringClass().equals(proxiedClass)) {
            throw new IllegalArgumentException("Constructor '" + constructor.toString() + "' is not declared by class '" + proxiedClass.getName() + "'.");
        }
        try {
            this.proxiedObject = null == constructor ? proxiedClass.newInstance() : constructor.newInstance(proxiedClassConstructorActualParameters);
        }
        catch (Exception e) {
            String message = "Unable to instantiate '" + proxiedClass.getName() + "'.";
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, message, e);
            }
            throw new OptionalClassProxyException(message, e, true);
        }
    }

    protected final Object invokeMethod(ProxyMetaData proxyMetaData, Method method, Object[] methodActualParameters, Class expectedReturnType) throws Exception {
        String methodName = null == method ? "" : method.getName();
        String logMessage = "invokeMethod: '" + methodName + "'. ";
        try {
            if (null == proxyMetaData) {
                throw new IllegalArgumentException("Non-null proxy meta data expected.");
            }
            if (null == method) {
                throw new IllegalArgumentException("Non-null method expected.");
            }
            if (null == expectedReturnType) {
                throw new IllegalArgumentException("Non-null expectedReturnType expected.");
            }
            OptionalClassProxy.checkValid(proxyMetaData.getProxySubclass());
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, logMessage, e);
            }
            throw e;
        }
        Object obj = this.getProxiedObject();
        Object output = null;
        try {
            output = method.invoke(obj, methodActualParameters);
        }
        catch (InvocationTargetException e) {
            Throwable cause;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, logMessage, e);
            }
            if ((cause = e.getCause()) instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, logMessage, e);
            }
            throw new OptionalClassProxyException(logMessage, e, true);
        }
        if (!OptionalClassProxy.isReturnedValid(true, output, expectedReturnType, methodName)) {
            throw new OptionalClassProxyException(logMessage, true);
        }
        return output;
    }

    protected final Object getProxiedObject() {
        return this.proxiedObject;
    }

    static boolean isValid(Class proxySubclass) throws IllegalArgumentException {
        if (!OptionalClassProxy.isAllEnabled()) {
            return false;
        }
        if (null == proxySubclass) {
            throw new IllegalArgumentException("Non-null proxy subclass expected.");
        }
        Class proxiedClass = OptionalClassProxy.getValidProxy(proxySubclass);
        return null != proxiedClass;
    }

    static Class getProxiedClass(Class proxySubclass) throws IllegalArgumentException, OptionalClassProxyException {
        OptionalClassProxy.checkValid(proxySubclass);
        Class proxiedClass = OptionalClassProxy.getValidProxy(proxySubclass);
        return proxiedClass;
    }

    protected static void checkValid(Class proxySubclass) throws OptionalClassProxyException, IllegalArgumentException {
        if (null == proxySubclass) {
            throw new IllegalArgumentException("Non-null proxy subclass expected.");
        }
        if (!OptionalClassProxy.isValid(proxySubclass)) {
            String message = "Called invalid OptionalClassProxy subclass '" + proxySubclass.getName() + "'.";
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, message);
            }
            throw new OptionalClassProxyException(message, false);
        }
    }

    static boolean isInstance(Class proxySubclass, Object testObject) throws OptionalClassProxyException, IllegalArgumentException {
        Class proxiedClass = OptionalClassProxy.getProxiedClass(proxySubclass);
        return proxiedClass.isInstance(testObject);
    }

    protected static boolean isAllEnabled() {
        return isAllEnabled;
    }

    protected static boolean setAllEnabled(boolean allEnabled) {
        boolean previous = isAllEnabled;
        isAllEnabled = allEnabled;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "OptionalClassProxy.setAllEnabled() set to '" + allEnabled + "', was '" + previous + "'.");
        }
        return previous;
    }

    static boolean isReturnedValid(boolean isNullReturnedObjectOk, Object returnedObject, Class expectedClass, String callingMethod) throws IllegalArgumentException {
        if (null == expectedClass) {
            throw new IllegalArgumentException("Non-null expectedClass expected.");
        }
        if (null == callingMethod || "".equals(callingMethod)) {
            throw new IllegalArgumentException("Non-empty callingMethod expected.");
        }
        if (null == returnedObject) {
            if (!expectedClass.equals(Void.TYPE) && !isNullReturnedObjectOk) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, callingMethod + " expected non-null returned object.");
                }
                return false;
            }
        } else if (!expectedClass.isInstance(returnedObject)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, callingMethod + " expected returned object of type '" + expectedClass.getName() + "', but returned object was of type '" + returnedObject.getClass().getName() + "'.");
            }
            return false;
        }
        return true;
    }

    public static class ProxyMetaData {
        private Class proxySubclass;
        private String proxiedClassName;

        public ProxyMetaData(Class proxySubclass, String proxiedClassName) {
            if (null == proxySubclass) {
                throw new IllegalArgumentException("Non-null proxy subclass expected.");
            }
            if (null == proxiedClassName || "".equals(proxiedClassName)) {
                throw new IllegalArgumentException("Non-null and non-empty proxied-class name expected.");
            }
            this.proxySubclass = proxySubclass;
            this.proxiedClassName = proxiedClassName;
        }

        public final Class getProxySubclass() {
            return this.proxySubclass;
        }

        public final String getProxiedClassName() {
            return this.proxiedClassName;
        }

        public final boolean isValid() {
            return OptionalClassProxy.isValid(this.proxySubclass);
        }

        public final boolean isInstance(Object testObject) {
            return OptionalClassProxy.isInstance(this.proxySubclass, testObject);
        }

        public final Class getProxiedClass() {
            return OptionalClassProxy.getProxiedClass(this.proxySubclass);
        }
    }

    static abstract class MethodValidator {
        MethodValidator() {
        }

        public abstract void validate(Class var1) throws Exception;
    }
}

