/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FilenameMangler;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.BitSet;
import java.util.Vector;

final class MultipartFormDataEncoder {
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String FileName = "\"; filename=\"";
    private static final NVPair[] dummy;
    private static final BitSet BoundChar;

    private MultipartFormDataEncoder() {
    }

    static final byte[] encode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr, FilenameMangler mangler) throws IOException {
        int idx;
        byte[] boundary = Boundary.getBytes("8859_1");
        byte[] cont_disp = ContDisp.getBytes("8859_1");
        byte[] cont_type = ContType.getBytes("8859_1");
        byte[] filename = FileName.getBytes("8859_1");
        int len = 0;
        int hdr_len = boundary.length + cont_disp.length + 1 + 2 + 2;
        if (opts == null) {
            opts = dummy;
        }
        if (files == null) {
            files = dummy;
        }
        for (idx = 0; idx < opts.length; ++idx) {
            if (opts[idx] == null) continue;
            len += hdr_len + opts[idx].getName().length() + opts[idx].getValue().length();
        }
        for (idx = 0; idx < files.length; ++idx) {
            if (files[idx] == null) continue;
            File file = new File(files[idx].getValue());
            String fname = file.getName();
            if (mangler != null) {
                fname = mangler.mangleFilename(fname, files[idx].getName());
            }
            if (fname == null) continue;
            len += hdr_len + files[idx].getName().length() + filename.length;
            len = (int)((long)len + ((long)fname.length() + file.length()));
            String ct = CT.getContentType(file.getName());
            if (ct == null) continue;
            len += cont_type.length + ct.length();
        }
        if (len == 0) {
            ct_hdr[0] = new NVPair("Content-Type", "application/octet-stream");
            return new byte[0];
        }
        len -= 2;
        byte[] res = new byte[len += boundary.length + 2 + 2];
        int pos = 0;
        block2: for (int new_c = 0x30303030; new_c != 0x7A7A7A7A; ++new_c) {
            int idx2;
            pos = 0;
            while (!BoundChar.get(new_c & 0xFF)) {
                ++new_c;
            }
            while (!BoundChar.get(new_c >> 8 & 0xFF)) {
                new_c += 256;
            }
            while (!BoundChar.get(new_c >> 16 & 0xFF)) {
                new_c += 65536;
            }
            while (!BoundChar.get(new_c >> 24 & 0xFF)) {
                new_c += 0x1000000;
            }
            boundary[40] = (byte)(new_c & 0xFF);
            boundary[42] = (byte)(new_c >> 8 & 0xFF);
            boundary[44] = (byte)(new_c >> 16 & 0xFF);
            boundary[46] = (byte)(new_c >> 24 & 0xFF);
            int off = 2;
            int[] bnd_cmp = Util.compile_search(boundary);
            for (idx2 = 0; idx2 < opts.length; ++idx2) {
                if (opts[idx2] == null) continue;
                System.arraycopy(boundary, off, res, pos, boundary.length - off);
                off = 0;
                int start = pos += boundary.length - off;
                System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                int nlen = opts[idx2].getName().length();
                System.arraycopy(opts[idx2].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                pos += nlen;
                res[pos++] = 34;
                res[pos++] = 13;
                res[pos++] = 10;
                res[pos++] = 13;
                res[pos++] = 10;
                int vlen = opts[idx2].getValue().length();
                System.arraycopy(opts[idx2].getValue().getBytes("8859_1"), 0, res, pos, vlen);
                if ((pos += vlen) - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) continue block2;
            }
            for (idx2 = 0; idx2 < files.length; ++idx2) {
                if (files[idx2] == null) continue;
                File file = new File(files[idx2].getValue());
                String fname = file.getName();
                if (mangler != null) {
                    fname = mangler.mangleFilename(fname, files[idx2].getName());
                }
                if (fname == null) continue;
                System.arraycopy(boundary, off, res, pos, boundary.length - off);
                off = 0;
                int start = pos += boundary.length - off;
                System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                int nlen = files[idx2].getName().length();
                System.arraycopy(files[idx2].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                System.arraycopy(filename, 0, res, pos += nlen, filename.length);
                nlen = fname.length();
                System.arraycopy(fname.getBytes("8859_1"), 0, res, pos += filename.length, nlen);
                pos += nlen;
                res[pos++] = 34;
                String ct = CT.getContentType(file.getName());
                if (ct != null) {
                    System.arraycopy(cont_type, 0, res, pos, cont_type.length);
                    System.arraycopy(ct.getBytes("8859_1"), 0, res, pos += cont_type.length, ct.length());
                    pos += ct.length();
                }
                res[pos++] = 13;
                res[pos++] = 10;
                res[pos++] = 13;
                res[pos++] = 10;
                nlen = (int)file.length();
                FileInputStream fin = new FileInputStream(file);
                while (nlen > 0) {
                    int got = fin.read(res, pos, nlen);
                    nlen -= got;
                    pos += got;
                }
                fin.close();
                if (pos - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) continue block2;
            }
        }
        System.arraycopy(boundary, 0, res, pos, boundary.length);
        pos += boundary.length;
        res[pos++] = 45;
        res[pos++] = 45;
        res[pos++] = 13;
        res[pos++] = 10;
        if (pos != len) {
            throw new Error("Calculated " + len + " bytes but wrote " + pos + " bytes!");
        }
        ct_hdr[0] = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(boundary, 4, boundary.length - 4, "8859_1"));
        return res;
    }

    static final NVPair[] decode(byte[] data, String cont_type, String dir, FilenameMangler mangler) throws IOException, ParseException {
        String bndstr = Util.getParameter("boundary", cont_type);
        if (bndstr == null) {
            throw new ParseException("'boundary' parameter not found in Content-type: " + cont_type);
        }
        byte[] srtbndry = ("--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] boundary = ("\r\n--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] endbndry = ("\r\n--" + bndstr + "--").getBytes("8859_1");
        int[] bs = Util.compile_search(srtbndry);
        int[] bc = Util.compile_search(boundary);
        int[] be = Util.compile_search(endbndry);
        int start = Util.findStr(srtbndry, bs, data, 0, data.length);
        if (start == -1) {
            throw new ParseException("Starting boundary not found: " + new String(srtbndry, "8859_1"));
        }
        start += srtbndry.length;
        NVPair[] res = new NVPair[10];
        boolean done = false;
        int idx = 0;
        while (!done) {
            String value;
            int next;
            int end = Util.findStr(boundary, bc, data, start, data.length);
            if (end == -1) {
                end = Util.findStr(endbndry, be, data, start, data.length);
                if (end == -1) {
                    throw new ParseException("Ending boundary not found: " + new String(endbndry, "8859_1"));
                }
                done = true;
            }
            String name = null;
            String filename = null;
            String cont_disp = null;
            while ((next = MultipartFormDataEncoder.findEOL(data, start) + 2) - 2 > start) {
                byte ch;
                String hdr = new String(data, start, next - 2 - start, "8859_1");
                start = next;
                while (next < data.length - 1 && ((ch = data[next]) == 32 || ch == 9)) {
                    next = MultipartFormDataEncoder.findEOL(data, start) + 2;
                    hdr = hdr + new String(data, start, next - 2 - start, "8859_1");
                    start = next;
                }
                if (!hdr.regionMatches(true, 0, "Content-Disposition", 0, 19)) continue;
                Vector pcd = Util.parseHeader(hdr.substring(hdr.indexOf(58) + 1));
                HttpHeaderElement elem = Util.getElement(pcd, "form-data");
                if (elem == null) {
                    throw new ParseException("Expected 'Content-Disposition: form-data' in line: " + hdr);
                }
                NVPair[] params = elem.getParams();
                filename = null;
                name = null;
                for (int pidx = 0; pidx < params.length; ++pidx) {
                    if (params[pidx].getName().equalsIgnoreCase("name")) {
                        name = params[pidx].getValue();
                    }
                    if (!params[pidx].getName().equalsIgnoreCase("filename")) continue;
                    filename = params[pidx].getValue();
                }
                if (name == null) {
                    throw new ParseException("'name' parameter not found in header: " + hdr);
                }
                cont_disp = hdr;
            }
            if ((start += 2) > end) {
                throw new ParseException("End of header not found at offset " + end);
            }
            if (cont_disp == null) {
                throw new ParseException("Missing 'Content-Disposition' header at offset " + start);
            }
            if (filename != null) {
                if (mangler != null) {
                    filename = mangler.mangleFilename(filename, name);
                }
                if (filename != null && filename.length() > 0) {
                    File file = new File(dir, filename);
                    FileOutputStream out = new FileOutputStream(file);
                    out.write(data, start, end - start);
                    out.close();
                }
                value = filename;
            } else {
                value = new String(data, start, end - start, "8859_1");
            }
            if (idx >= res.length) {
                res = Util.resizeArray(res, idx + 10);
            }
            res[idx] = new NVPair(name, value);
            start = end + boundary.length;
            ++idx;
        }
        return Util.resizeArray(res, idx);
    }

    private static final int findEOL(byte[] arr, int off) {
        while (off < arr.length - 1 && (arr[off++] != 13 || arr[off] != 10)) {
        }
        return off - 1;
    }

    static {
        int ch;
        dummy = new NVPair[0];
        BoundChar = new BitSet(256);
        for (ch = 48; ch <= 57; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            BoundChar.set(ch);
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String fname) {
            return CT.guessContentTypeFromName(fname);
        }

        private CT() {
            super(null);
        }

        public void connect() {
        }
    }
}

