/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.SystemPropertyNames;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class HttpClientConfiguration
implements SystemPropertyNames {
    private static final String version = "Oracle HTTPClient Version 10h";
    private static boolean no_chunked;
    private static boolean force_1_0;
    private static boolean neverPipeline;
    private static boolean noKeepAlives;
    private static boolean deferStreamed;
    private static boolean enableNagleAlgorithm;
    private static boolean inOneTwo;
    private static String proxyHost;
    private static int proxyPort;
    private static String[] nonProxyHosts;
    private static String socksHost;
    private static int socksPort;
    private static int socksVersion;
    private static String defaultModules;
    private static boolean inApplet;
    private static int socketIdleTimeout;
    private static int connectionTimeout;
    private static int socketReadTimeout;
    private static String defaultNtlmDomainName;
    private static String defaultHostnameVerifier;
    private static boolean preferOracleSsl;
    private static NVPair[] authenticationSchemes;
    private static Logger logger;
    private static int MAXIMUM_AUTORIZATION_TRIES;
    private static final String EMPTY_STRING = "";
    private static boolean staleSocketCheckEnabled;

    public static void setDefaults() {
        no_chunked = false;
        force_1_0 = false;
        neverPipeline = false;
        noKeepAlives = false;
        deferStreamed = false;
        enableNagleAlgorithm = false;
        inOneTwo = true;
        proxyHost = null;
        proxyPort = -1;
        nonProxyHosts = null;
        socksHost = null;
        socksPort = -1;
        socksVersion = -1;
        defaultModules = null;
        inApplet = false;
        socketIdleTimeout = 60;
        connectionTimeout = 0;
        socketReadTimeout = 0;
        logger = HttpClientLoggerFactory.getLogger();
        MAXIMUM_AUTORIZATION_TRIES = 4;
        defaultNtlmDomainName = EMPTY_STRING;
        defaultHostnameVerifier = EMPTY_STRING;
        preferOracleSsl = false;
        authenticationSchemes = null;
        staleSocketCheckEnabled = false;
    }

    public static void readConfigurationProperties() {
        try {
            HttpClientConfiguration.configureLogging();
            logger.config("Version: " + HttpClientConfiguration.getVersion());
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    no_chunked = Boolean.getBoolean("HTTPClient.dontChunkRequests");
                    return null;
                }
            });
            if (no_chunked) {
                logger.config("Conn:  never chunking requests");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    neverPipeline = Boolean.getBoolean("HTTPClient.disable_pipelining");
                    return null;
                }
            });
            if (neverPipeline) {
                logger.config("Conn:  disabling pipelining");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    noKeepAlives = Boolean.getBoolean("HTTPClient.disableKeepAlives");
                    return null;
                }
            });
            if (noKeepAlives) {
                logger.config("Conn:  disabling keep-alives");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    force_1_0 = Boolean.getBoolean("HTTPClient.forceHTTP_1.0");
                    return null;
                }
            });
            if (force_1_0) {
                logger.config("Conn:  forcing HTTP/1.0 requests");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    deferStreamed = Boolean.getBoolean("HTTPClient.deferStreamed");
                    return null;
                }
            });
            if (deferStreamed) {
                logger.config("Conn:  enabling defered handling of responses to streamed requests");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    enableNagleAlgorithm = Boolean.getBoolean("HTTPClient.Nagle");
                    return null;
                }
            });
            if (enableNagleAlgorithm) {
                logger.config("Conn: Nagle's Algorithm is enabled");
            } else {
                logger.config("Conn: Nagle's Algorithm is disabled");
            }
            try {
                Class.forName("java.security.AccessController");
                inOneTwo = true;
            }
            catch (ClassNotFoundException ex) {
                inOneTwo = false;
            }
            proxyHost = HttpClientConfiguration.getPrivilegedSystemProperty("http.proxyHost");
            proxyPort = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("http.proxyPort", -1);
            String hosts = HttpClientConfiguration.getPrivilegedSystemProperty("HTTPClient.nonProxyHosts");
            if (hosts == null) {
                hosts = HttpClientConfiguration.getPrivilegedSystemProperty("http.nonProxyHosts");
            }
            nonProxyHosts = hosts == null ? null : Util.splitProperty(hosts);
            socksHost = HttpClientConfiguration.getPrivilegedSystemProperty("HTTPClient.socksHost");
            socksPort = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.socksPort", -1);
            socksVersion = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.socksVersion", -1);
            defaultNtlmDomainName = HttpClientConfiguration.getPrivilegedSystemPropertywithDefault("HTTPClient.ntlm.defaultDomainName", EMPTY_STRING);
            defaultHostnameVerifier = HttpClientConfiguration.getPrivilegedSystemPropertywithDefault("HTTPClient.defaultHostnameVerifier", EMPTY_STRING);
            preferOracleSsl = Boolean.valueOf(HttpClientConfiguration.getPrivilegedSystemProperty("HTTPClient.preferOracleSSL"));
            authenticationSchemes = HttpClientConfiguration.readAuthenticationSchemes();
            String modules = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule";
            defaultModules = HttpClientConfiguration.getPrivilegedSystemPropertywithDefault("HTTPClient.Modules", modules);
            socketIdleTimeout = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.socket.idleTimeout", socketIdleTimeout);
            logger.config("Conn: Setting Socket Idle Timeout to " + socketIdleTimeout + " seconds");
            connectionTimeout = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.socket.connectionTimeout", 0);
            socketReadTimeout = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.socket.readTimeout", 0);
            HTTPConnection.setDefaultTimeout(socketReadTimeout);
            logger.config("Conn: Setting Socket connection Timeout to " + connectionTimeout + " milliseconds");
            HTTPConnection.setDefaultConnectionTimeout(connectionTimeout);
            logger.config("Conn: Setting Socket Read Timeout to " + socketReadTimeout + " milliseconds");
            MAXIMUM_AUTORIZATION_TRIES = HttpClientConfiguration.getPrivilegedSystemPropertyAsIntWithDefault("HTTPClient.authorization.MaxRetry", 4);
            logger.config("Conn: Setting Maximum Authorization retries to " + MAXIMUM_AUTORIZATION_TRIES);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HttpClientConfiguration.setStaleSocketCheckEnabled(Boolean.getBoolean("HTTPClient.socket.staleCheck"));
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            inApplet = true;
        }
    }

    private HttpClientConfiguration() {
    }

    public static boolean getNoChunkingFlag() {
        return no_chunked;
    }

    public static String getVersion() {
        return version;
    }

    public static boolean getNoKeepAlives() {
        return noKeepAlives;
    }

    public static boolean getForceHTTP1_0() {
        return force_1_0;
    }

    public static boolean getNeverPipeline() {
        return neverPipeline;
    }

    public static boolean getDeferStreamed() {
        return deferStreamed;
    }

    public static boolean getNagleAlgorithmEnabled() {
        return enableNagleAlgorithm;
    }

    public static boolean getInOneTwo() {
        return inOneTwo;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static String[] getNonProxyHosts() {
        return nonProxyHosts;
    }

    public static String getSocksHost() {
        return socksHost;
    }

    public static String getDefaultNtlmDomainName() {
        return defaultNtlmDomainName;
    }

    public static String getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static boolean isPreferOracleSsl() {
        return preferOracleSsl;
    }

    public static NVPair[] getAuthenticationSchemes() {
        if (null == authenticationSchemes) {
            return null;
        }
        NVPair[] output = new NVPair[authenticationSchemes.length];
        System.arraycopy(authenticationSchemes, 0, output, 0, authenticationSchemes.length);
        return output;
    }

    public static int getSocksPort() {
        return socksPort;
    }

    public static int getSocksVersion() {
        return socksVersion;
    }

    public static int getSocketIdleTimeout() {
        return socketIdleTimeout;
    }

    public static void setSocketIdleTime(int idleTimeout) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "setSocketIdleTime: {0} seconds", Integer.toString(idleTimeout));
        }
        socketIdleTimeout = idleTimeout;
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public static int getSocketReadTimeout() {
        return socketReadTimeout;
    }

    public static boolean isStaleSocketCheckEnabled() {
        return staleSocketCheckEnabled;
    }

    public static void setStaleSocketCheckEnabled(boolean enabled) {
        staleSocketCheckEnabled = enabled;
        String s = "enabled";
        if (!staleSocketCheckEnabled) {
            s = "disabled";
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Stale socket checking is " + s);
        }
    }

    public static int getMaxAuthTries() {
        return MAXIMUM_AUTORIZATION_TRIES;
    }

    public static Vector setupDefaultModuleList() {
        Vector vectorToReturn = new Vector();
        String[] list = Util.splitProperty(defaultModules);
        for (int idx = 0; idx < list.length; ++idx) {
            try {
                vectorToReturn.addElement(Class.forName(list[idx]));
                logger.log(Level.CONFIG, "Conn:  added module {0}", list[idx]);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (inApplet) continue;
                throw new NoClassDefFoundError(cnfe.getMessage());
            }
        }
        return vectorToReturn;
    }

    private static void configureLogging() {
        String logLevel = HttpClientConfiguration.getPrivilegedSystemProperty("HTTPClient.log.level");
        if (logLevel != null) {
            final LogManager logMgr = LogManager.getLogManager();
            String rootLevel = ".level = " + logMgr.getProperty(".level");
            String handlerProperty = " handlers= " + logMgr.getProperty("handlers");
            String consoleLevel = "java.util.logging.ConsoleHandler.level = " + logLevel;
            String consoleFormatter = "java.util.logging.ConsoleHandler.formatter = HTTPClient.HttpClientSimpleFormatter";
            String httpClientLogLevel = "HTTPClient.level = " + logLevel;
            String propertyList = rootLevel + "\n" + handlerProperty + "\n" + consoleLevel + "\n" + consoleFormatter + "\n" + httpClientLogLevel + "\n";
            final ByteArrayInputStream inputStream = new ByteArrayInputStream(propertyList.getBytes());
            try {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            logMgr.readConfiguration(inputStream);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    private static NVPair[] readAuthenticationSchemes() {
        int SCHEME_NAME_OFFSET = "HTTPClient.authenticationScheme.".length();
        ArrayList<NVPair> list = new ArrayList<NVPair>(10);
        Properties sysProps = HttpClientConfiguration.getPrivilegedSystemProperties();
        Iterator<Object> iter = sysProps.keySet().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            if (!propName.startsWith("HTTPClient.authenticationScheme.")) continue;
            String schemeName = propName.substring(SCHEME_NAME_OFFSET).trim();
            String schemeClassName = sysProps.getProperty(propName).trim();
            list.add(new NVPair(schemeName, schemeClassName));
        }
        if (0 == list.size()) {
            return null;
        }
        NVPair[] output = new NVPair[list.size()];
        output = list.toArray(output);
        return output;
    }

    private static String getPrivilegedSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    private static String getPrivilegedSystemPropertywithDefault(final String name, final String defaultValue) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
        if (value == null || EMPTY_STRING.equalsIgnoreCase(value.trim())) {
            value = defaultValue;
        }
        return value;
    }

    private static int getPrivilegedSystemPropertyAsIntWithDefault(String name, int defaultValue) {
        int intValue = defaultValue;
        String strValue = HttpClientConfiguration.getPrivilegedSystemProperty(name);
        if (strValue != null || !EMPTY_STRING.equalsIgnoreCase(strValue)) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return intValue;
    }

    private static Properties getPrivilegedSystemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }

    static {
        HttpClientConfiguration.setDefaults();
    }
}

