/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.BufferedInputStream;
import HTTPClient.CIHashtable;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPClientSSL;
import HTTPClient.HTTPClientSSLFactory;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.OracleSSL;
import HTTPClient.OracleSSLCredentialProxy;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.SystemPropertyNames;
import HTTPClient.Timeouts;
import HTTPClient.URI;
import HTTPClient.Util;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants,
SystemPropertyNames {
    private static final Object dflt_context = new Object();
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private String Host;
    private int Port;
    private InetAddress LocalAddr;
    private int LocalPort;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private static String Default_Proxy_Host = null;
    private static int Default_Proxy_Port;
    private static CIHashtable non_proxy_host_list;
    private static Vector non_proxy_dom_list;
    private static Vector non_proxy_addr_list;
    private static Vector non_proxy_mask_list;
    private SocksClient Socks_client = null;
    private static SocksClient Default_Socks_client;
    private StreamDemultiplexor input_demux = null;
    List DemuxList = Collections.synchronizedList(new LinkedList());
    private List RequestList = Collections.synchronizedList(new LinkedList());
    private boolean doesKeepAlive = false;
    private boolean keepAliveUnknown = true;
    private int keepAliveReqMax = -1;
    private int keepAliveReqLeft;
    private boolean no_chunked_instance = false;
    private int chunkSize = 4096;
    private static Timeouts DefaultTimeout;
    private Timeouts Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private static Vector DefaultModuleList;
    private Vector ModuleList;
    private static boolean defaultAllowUI;
    private boolean allowUI;
    private HTTPClientSSL m_ssl;
    private AuthorizationPrompter m_authPrompter = null;
    private static SSLSocketFactory defaultSSLSocketFactory;
    private SSLSocketFactory m_SSLSocketFactory;
    private static SocketFactory defaultSocketFactory;
    private SocketFactory m_socketFactory;
    private static HostnameVerifier defaultHostnameVerifier;
    private HostnameVerifier hostnameVerifier = null;
    private static final HostnameVerifier NULL_HOSTNAME_VERIFIER;
    private Map m_cookieMap = null;
    private String urlEncoding;
    private static final char[] CR_LF;
    private static Logger logger;
    boolean usedByHttpURLConnection = false;
    private static Timeouts defaultContinueTimeout;
    private volatile Response early_stall = null;
    private volatile Response late_stall = null;
    private volatile Response prev_resp = null;
    private boolean output_finished = true;

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String host) {
        this.Setup(0, host, 80, null, -1);
    }

    public HTTPConnection(String host, int port) {
        this.Setup(0, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port) throws ProtocolNotSuppException {
        this(prot, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port, InetAddress localAddr, int localPort) throws ProtocolNotSuppException {
        prot = prot.trim().toLowerCase();
        if (!prot.equals("http") && !prot.equals("https")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + prot + "'");
        }
        this.Setup(this.getProtocol(prot), host, port, localAddr, localPort);
    }

    public HTTPConnection(URL url) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URL url, boolean oracleSSL) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URI uri) throws ProtocolNotSuppException {
        this(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    private void Setup(int prot, String host, int port, InetAddress localAddr, int localPort) {
        this.Protocol = prot;
        this.Host = host.trim().toLowerCase();
        this.Port = port;
        this.LocalAddr = localAddr;
        this.LocalPort = localPort;
        if (this.Port == -1) {
            this.Port = URI.defaultPort(this.getProtocol());
        }
        if (Default_Proxy_Host != null && !this.matchNonProxy(this.Host)) {
            this.setCurrentProxy(Default_Proxy_Host, Default_Proxy_Port);
        } else {
            this.setCurrentProxy(null, 0);
        }
        this.Socks_client = Default_Socks_client;
        this.Timeout = DefaultTimeout;
        this.ModuleList = (Vector)DefaultModuleList.clone();
        this.allowUI = defaultAllowUI;
        if (HttpClientConfiguration.getNoKeepAlives()) {
            this.setDefaultHeaders(new NVPair[]{new NVPair("Connection", "close")});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchNonProxy(String host) {
        CIHashtable cIHashtable = non_proxy_host_list;
        synchronized (cIHashtable) {
            if (non_proxy_host_list.get(host) != null) {
                return true;
            }
        }
        for (int idx = 0; idx < non_proxy_dom_list.size(); ++idx) {
            if (!host.endsWith((String)non_proxy_dom_list.elementAt(idx))) continue;
            return true;
        }
        if (non_proxy_addr_list.size() == 0) {
            return false;
        }
        InetAddress[] host_addr = null;
        try {
            host_addr = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (host_addr != null && host_addr.length > 0) {
            for (int i = 0; i < host_addr.length; ++i) {
                try {
                    if (HTTPConnection.findIP(host_addr[i].getHostAddress()) >= 0) {
                        return true;
                    }
                    continue;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public HTTPResponse Head(String file) throws IOException, ModuleException {
        return this.Head(file, (String)null, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Head(file, form_data, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, form_data);
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Head(String file, String query) throws IOException, ModuleException {
        return this.Head(file, query, null);
    }

    public HTTPResponse Head(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, query);
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Get(String file) throws IOException, ModuleException {
        return this.Get(file, (String)null, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Get(file, form_data, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, form_data);
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Get(String file, String query) throws IOException, ModuleException {
        return this.Get(file, query, null);
    }

    public HTTPResponse Get(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, query);
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Post(String file) throws IOException, ModuleException {
        return this.Post(file, (byte[])null, null);
    }

    public HTTPResponse Post(String file, NVPair[] form_data) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-type", "application/x-www-form-urlencoded")};
        return this.Post(file, Codecs.nv2query(form_data, this.urlEncoding), headers);
    }

    public HTTPResponse Post(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        int idx;
        for (idx = 0; idx < headers.length && !headers[idx].getName().equalsIgnoreCase("Content-type"); ++idx) {
        }
        if (idx == headers.length) {
            headers = Util.resizeArray(headers, idx + 1);
            headers[idx] = new NVPair("Content-type", "application/x-www-form-urlencoded");
        }
        return this.Post(file, Codecs.nv2query(form_data, this.urlEncoding), headers);
    }

    public HTTPResponse Post(String file, String data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Post(file, tmp, headers);
    }

    public HTTPResponse Post(String file, byte[] data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Post(file, stream, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Post(String file, byte[] data, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, data, stream);
    }

    public HTTPResponse Put(String file, String data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Put(file, tmp, headers);
    }

    public HTTPResponse Put(String file, byte[] data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("PUT", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Put(file, stream, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("PUT", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Options(String file) throws IOException, ModuleException {
        return this.Options(file, null, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.Options(file, headers, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, byte[] data) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, HttpOutputStream stream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Delete(String file) throws IOException, ModuleException {
        return this.Delete(file, null);
    }

    public HTTPResponse Delete(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("DELETE", HTTPConnection.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("TRACE", HTTPConnection.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file) throws IOException, ModuleException {
        return this.Trace(file, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, HttpOutputStream os, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), HTTPConnection.stripRef(file), headers, null, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Iterator iterator;
        List list = this.RequestList;
        synchronized (list) {
            iterator = this.RequestList.iterator();
            while (iterator.hasNext()) {
                Request req = (Request)iterator.next();
                req.aborted = true;
            }
        }
        list = this.DemuxList;
        synchronized (list) {
            iterator = this.DemuxList.iterator();
            while (iterator.hasNext()) {
                StreamDemultiplexor demux = (StreamDemultiplexor)iterator.next();
                demux.abort();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultHeaders(NVPair[] headers) {
        int length = headers == null ? 0 : headers.length;
        NVPair[] def_hdrs = new NVPair[length];
        int didx = 0;
        for (int sidx = 0; sidx < length; ++sidx) {
            String name;
            if (headers[sidx] == null || (name = headers[sidx].getName().trim()).equalsIgnoreCase("Content-length")) continue;
            def_hdrs[didx++] = headers[sidx];
        }
        if (didx < length) {
            def_hdrs = Util.resizeArray(def_hdrs, didx);
        }
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            this.DefaultHeaders = def_hdrs;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NVPair[] getDefaultHeaders() {
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (NVPair[])this.DefaultHeaders.clone();
        }
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public boolean isCompatibleWith(URI uri) {
        if (!uri.getScheme().equals(this.getProtocol()) || !uri.getHost().equalsIgnoreCase(this.Host)) {
            return false;
        }
        int port = uri.getPort();
        if (port == -1) {
            port = URI.defaultPort(uri.getScheme());
        }
        return port == this.Port;
    }

    public void setRawMode(boolean raw) {
        String[] modules = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule"};
        for (int idx = 0; idx < modules.length; ++idx) {
            try {
                if (raw) {
                    this.removeModule(Class.forName(modules[idx]));
                    continue;
                }
                this.addModule(Class.forName(modules[idx]), -1);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
    }

    public static void setDefaultTimeout(int time) {
        DefaultTimeout = new Timeouts(time);
    }

    public static void setDefaultConnectionTimeout(int time) {
        DefaultTimeout = new Timeouts(HTTPConnection.DefaultTimeout.read, time);
    }

    public static int getDefaultTimeout() {
        return HTTPConnection.DefaultTimeout.read;
    }

    public static int getDefaultConnectionTimeout() {
        return HTTPConnection.DefaultTimeout.connection;
    }

    public void setTimeout(int time) {
        this.Timeout = new Timeouts(time);
    }

    public void setConnectionTimeout(int time) {
        this.Timeout = new Timeouts(this.Timeout.read, time);
    }

    public int getTimeout() {
        return this.Timeout.read;
    }

    public int getConnectionTimeout() {
        return this.Timeout.connection;
    }

    public void setAllowUserInteraction(boolean allow) {
        this.allowUI = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean allow) {
        defaultAllowUI = allow;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUI;
    }

    public static Class[] getDefaultModules() {
        return HTTPConnection.getModules(DefaultModuleList);
    }

    public static boolean addDefaultModule(Class module, int pos) {
        return HTTPConnection.addModule(DefaultModuleList, module, pos);
    }

    public static boolean removeDefaultModule(Class module) {
        return HTTPConnection.removeModule(DefaultModuleList, module);
    }

    public Class[] getModules() {
        return HTTPConnection.getModules(this.ModuleList);
    }

    public boolean addModule(Class module, int pos) {
        return HTTPConnection.addModule(this.ModuleList, module, pos);
    }

    public boolean removeModule(Class module) {
        return HTTPConnection.removeModule(this.ModuleList, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class[] getModules(Vector list) {
        Vector vector = list;
        synchronized (vector) {
            Object[] modules = new Class[list.size()];
            list.copyInto(modules);
            return modules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean addModule(Vector list, Class module, int pos) {
        if (module == null) {
            return false;
        }
        try {
            HTTPClientModule tmp = (HTTPClientModule)module.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        Vector e = list;
        synchronized (e) {
            if (list.contains(module)) {
                return false;
            }
            if (pos < 0) {
                list.insertElementAt(module, DefaultModuleList.size() + pos + 1);
            } else {
                list.insertElementAt(module, pos);
            }
        }
        String moduleListName = null;
        moduleListName = list == DefaultModuleList ? "default" : "";
        logger.log(Level.CONFIG, "Conn:  Added module {0} to {1} list", new Object[]{module.getName(), moduleListName});
        return true;
    }

    private static final boolean removeModule(Vector list, Class module) {
        if (module == null) {
            return false;
        }
        boolean removed = list.removeElement(module);
        String moduleListName = "";
        if (list == DefaultModuleList) {
            moduleListName = "default";
        }
        if (removed) {
            logger.log(Level.CONFIG, "Conn:  Removed module {0}  from {1} list", new Object[]{module.getName(), moduleListName});
        }
        return removed;
    }

    public void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new IllegalStateException("Context already set");
        }
        this.Context = context;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    public static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(String realm, String user, String passwd) {
        AuthorizationInfo.addDigestAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public void addBasicAuthorization(String realm, String user, String passwd) {
        AuthorizationInfo.addBasicAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public void addNtlmAuthentication(String username, String password) {
        AuthorizationInfo.addNtlmAuthentication(this.Host, this.Port, username, password, this.getContext());
    }

    public static void setProxyServer(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            Default_Proxy_Host = null;
        } else {
            Default_Proxy_Host = host.trim().toLowerCase();
            Default_Proxy_Port = port;
        }
    }

    public synchronized void setCurrentProxy(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            this.Proxy_Host = null;
        } else {
            this.Proxy_Host = host.trim().toLowerCase();
            this.Proxy_Port = port <= 0 ? 80 : port;
        }
        switch (this.Protocol) {
            case 0: 
            case 1: {
                if (HttpClientConfiguration.getForceHTTP1_0()) {
                    this.ServerProtocolVersion = 65536;
                    this.ServProtVersKnown = true;
                    this.RequestProtocolVersion = "HTTP/1.0";
                    break;
                }
                this.ServerProtocolVersion = 65537;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "HTTP/1.1";
                break;
            }
            case 3: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "";
                break;
            }
            case 2: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "Secure-HTTP/1.3";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        this.keepAliveUnknown = true;
        this.doesKeepAlive = false;
        this.input_demux = null;
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dontProxyFor(String host) throws ParseException {
        if ((host = host.trim().toLowerCase()).startsWith("*.")) {
            host = host.substring(1);
        }
        if (host.charAt(0) == '.') {
            if (!non_proxy_dom_list.contains(host)) {
                non_proxy_dom_list.addElement(host);
            }
            return;
        }
        if (!HTTPConnection.isStringAnIP(host)) {
            CIHashtable cIHashtable = non_proxy_host_list;
            synchronized (cIHashtable) {
                non_proxy_host_list.put(host, "");
            }
            return;
        }
        byte[] ip_addr = null;
        byte[] ip_mask = null;
        boolean isIPv6 = false;
        int slash = host.indexOf(47);
        if (slash != -1) {
            String h = host.substring(0, slash);
            ip_addr = Util.string2arr(h);
            isIPv6 = HTTPConnection.isAddressIPv6(h);
            if (isIPv6) {
                ip_mask = HTTPConnection.extractIPv6NetMask(host);
            } else {
                ip_mask = Util.string2arr(host.substring(slash + 1));
                if (ip_addr.length != ip_mask.length) {
                    throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
                }
            }
        } else {
            ip_addr = Util.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (int idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block4: for (int idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            if (addr.length != ip_addr.length || non_proxy_mask_list.size() == 0) continue;
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block4;
            }
            return;
        }
        non_proxy_addr_list.addElement(ip_addr);
        non_proxy_mask_list.addElement(ip_mask);
    }

    private static boolean isAddressIPv6(String h) {
        boolean ipv6;
        block2: {
            ipv6 = false;
            try {
                ipv6 = InetAddress.getByName(h) instanceof Inet6Address;
            }
            catch (UnknownHostException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Expected address to be in IPv6 Hex format.  Cannot resolve host: " + h, e);
            }
        }
        return ipv6;
    }

    public static void dontProxyFor(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        for (int idx = 0; idx < hosts.length; ++idx) {
            try {
                if (hosts[idx] == null) continue;
                HTTPConnection.dontProxyFor(hosts[idx]);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doProxyFor(String host) throws ParseException {
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            return non_proxy_dom_list.removeElement(host);
        }
        Cloneable cloneable = non_proxy_host_list;
        synchronized (cloneable) {
            if (!HTTPConnection.isStringAnIP(host)) {
                return non_proxy_host_list.remove(host) != null;
            }
        }
        cloneable = non_proxy_addr_list;
        synchronized (cloneable) {
            int idx = HTTPConnection.findIP(host);
            if (idx >= 0) {
                non_proxy_addr_list.removeElementAt(idx);
                non_proxy_mask_list.removeElementAt(idx);
                return true;
            }
        }
        return false;
    }

    static int findIP(String host) throws ParseException {
        int foundIndex = -1;
        byte[] ip_addr = null;
        byte[] ip_mask = null;
        boolean isIPV6 = false;
        int slash = host.indexOf(47);
        if (slash != -1) {
            String h = host.substring(0, slash);
            isIPV6 = HTTPConnection.isAddressIPv6(h);
            ip_addr = Util.string2arr(h);
            if (isIPV6) {
                ip_mask = HTTPConnection.extractIPv6NetMask(host);
            } else {
                ip_mask = Util.string2arr(host.substring(slash + 1));
                if (ip_addr.length != ip_mask.length) {
                    throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
                }
            }
        } else {
            ip_addr = Util.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (int idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block1: for (int idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2])) continue block1;
            }
            foundIndex = idx;
            break;
        }
        return foundIndex;
    }

    static byte[] extractIPv6NetMask(String ipWithPrefixLength) {
        int slashIdx = ipWithPrefixLength.indexOf(47);
        int prefixLength = Integer.parseInt(ipWithPrefixLength.substring(slashIdx + 1));
        byte[] netmask_addr = new byte[16];
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(ipWithPrefixLength.substring(0, slashIdx));
        }
        catch (UnknownHostException e) {
            return netmask_addr;
        }
        byte[] rawB = ia.getAddress();
        String ipInBinary = "";
        int totalBits = 0;
        for (int i = 0; i < rawB.length; ++i) {
            int t = 0xFF & rawB[i];
            String binaryStr = Integer.toBinaryString(t);
            binaryStr = HTTPConnection.padBits(binaryStr, 8, '0', true);
            ipInBinary = ipInBinary + binaryStr;
            totalBits += binaryStr.length();
        }
        String netmaskStr = HTTPConnection.padBits(ipInBinary.substring(0, prefixLength), 128, '0', false);
        for (int i = 0; i < netmask_addr.length; ++i) {
            netmask_addr[i] = (byte)Integer.parseInt(netmaskStr.substring(i * 8, (i + 1) * 8), 2);
        }
        return netmask_addr;
    }

    private static String padBits(String str, int totalLength, char c, boolean prepended) {
        String tmp = str;
        int diff = totalLength - str.length();
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                tmp = prepended ? c + tmp : tmp + c;
            }
        }
        return tmp;
    }

    private static int getHostIndexInNonProxyList(byte[] ip_addr) {
        int idx = -1;
        for (int i = 0; i < non_proxy_addr_list.size(); ++i) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(i);
            if (!Arrays.equals(ip_addr, addr)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    static boolean isStringAnIP(String hostAddr) {
        boolean isIP = false;
        if (hostAddr != null && hostAddr.trim().length() > 0) {
            if (hostAddr.indexOf(58) >= 0) {
                String nodeAddr = hostAddr;
                int idx = nodeAddr.indexOf(47);
                if (idx > -1) {
                    nodeAddr = nodeAddr.substring(0, idx);
                }
                try {
                    InetAddress inetAddr = InetAddress.getByName(nodeAddr);
                    isIP = inetAddr instanceof Inet6Address;
                }
                catch (UnknownHostException uhe) {}
            } else {
                String[] ipFields = hostAddr.split("\\Q.\\E");
                if (ipFields != null && ipFields.length == 4) {
                    for (int idx = 0; idx < ipFields.length; ++idx) {
                        for (int j = 0; j < ipFields[idx].length(); ++j) {
                            if (Character.isDigit(ipFields[idx].charAt(j))) continue;
                            return false;
                        }
                    }
                    isIP = true;
                }
            }
        }
        return isIP;
    }

    static boolean isStringAnIPv6(String hostAddr) {
        boolean ipv6 = false;
        if (hostAddr != null && hostAddr.trim().length() > 0 && hostAddr.indexOf(58) >= 0) {
            try {
                InetAddress inetAddr = InetAddress.getByName(hostAddr);
                ipv6 = inetAddr instanceof Inet6Address;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ipv6;
    }

    public static void setSocksServer(String host) {
        HTTPConnection.setSocksServer(host, 1080);
    }

    public static void setSocksServer(String host, int port) {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port);
    }

    public static void setSocksServer(String host, int port, int version) throws SocksException {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port, version);
    }

    private static final String stripRef(String file) {
        if (file == null) {
            return "";
        }
        int hash = file.indexOf(35);
        if (hash != -1) {
            file = file.substring(0, hash);
        }
        return file.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HTTPResponse setupRequest(String method, String resource, NVPair[] headers, byte[] entity, HttpOutputStream stream) throws IOException, ModuleException {
        Request req = new Request(this, method, resource, this.mergedHeaders(headers), entity, stream, this.allowUI);
        this.RequestList.add(req);
        try {
            HTTPResponse resp = new HTTPResponse(this.gen_mod_insts(), this.Timeout, req);
            this.handleRequest(req, resp, null, true);
            HTTPResponse hTTPResponse = resp;
            return hTTPResponse;
        }
        finally {
            this.RequestList.remove(req);
        }
    }

    private void closeStaleSocket() {
        if (HttpClientConfiguration.isStaleSocketCheckEnabled() && this.input_demux != null && this.DemuxList.size() > 0 && this.input_demux.getSocket() != null && this.input_demux.isSocketClosedByServer()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Closing server-closed (stale) socket: " + this.input_demux.getSocket());
            }
            this.input_demux.abort();
            this.DemuxList.remove(this.input_demux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NVPair[] mergedHeaders(NVPair[] spec) {
        int spec_len = spec != null ? spec.length : 0;
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            int defs_len = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
            NVPair[] merged = new NVPair[spec_len + defs_len];
            System.arraycopy(this.DefaultHeaders, 0, merged, 0, defs_len);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int didx = defs_len;
            for (int sidx = 0; sidx < spec_len; ++sidx) {
                int search;
                String s_name;
                if (spec[sidx] == null || (s_name = spec[sidx].getName().trim()).equalsIgnoreCase("Content-length")) continue;
                for (search = 0; search < didx && !merged[search].getName().trim().equalsIgnoreCase(s_name); ++search) {
                }
                merged[search] = spec[sidx];
                if (search != didx) continue;
                ++didx;
            }
            if (didx < merged.length) {
                merged = Util.resizeArray(merged, didx);
            }
            return merged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClientModule[] gen_mod_insts() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            HTTPClientModule[] mod_insts = new HTTPClientModule[this.ModuleList.size()];
            for (int idx = 0; idx < this.ModuleList.size(); ++idx) {
                Class mod = (Class)this.ModuleList.elementAt(idx);
                try {
                    mod_insts[idx] = (HTTPClientModule)mod.newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new Error("HTTPClient Internal Error: could not create instance of " + mod.getName() + " -\n" + e);
                }
            }
            return mod_insts;
        }
    }

    void handleRequest(Request req, HTTPResponse http_resp, Response resp, boolean usemodules) throws IOException, ModuleException {
        int idx;
        Response[] rsp_arr = new Response[]{resp};
        HTTPClientModule[] modules = http_resp.getModules();
        if (usemodules) {
            block10: for (idx = 0; idx < modules.length; ++idx) {
                int sts = modules[idx].requestHandler(req, rsp_arr);
                switch (sts) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        idx = -1;
                        continue block10;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (rsp_arr[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + modules[idx].getClass().getName());
                        }
                        http_resp.set(req, rsp_arr[0]);
                        if (req.getStream() != null) {
                            req.getStream().ignoreData(req);
                        }
                        if (req.internal_subrequest) {
                            return;
                        }
                        if (sts == 3) {
                            http_resp.handleResponse();
                        } else {
                            http_resp.init(rsp_arr[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], true);
                        return;
                    }
                    case 6: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + sts + " returned by module " + modules[idx].getClass().getName());
                    }
                }
            }
        }
        if (req.internal_subrequest) {
            return;
        }
        if (req.getStream() != null && req.getStream().getLength() == -1) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || this.no_chunked_instance) {
                req.getStream().goAhead(req, null, http_resp.getTimeout());
                if (req.getData() != null && req.getData().length > 0) {
                    http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
                } else {
                    http_resp.set(req, req.getStream());
                }
            } else {
                NVPair[] hdrs = req.getHeaders();
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Transfer-Encoding"); ++idx) {
                }
                if (idx == hdrs.length) {
                    logger.finer("Conn: setting chunking header");
                    hdrs = Util.resizeArray(hdrs, idx + 1);
                    hdrs[idx] = new NVPair("Transfer-Encoding", "chunked");
                    req.setHeaders(hdrs);
                } else {
                    String v = hdrs[idx].getValue();
                    try {
                        if (!Util.hasToken(v, "chunked")) {
                            hdrs[idx] = new NVPair("Transfer-Encoding", v + ", chunked");
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                }
                http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
            }
        } else {
            http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
        }
        this.checkForAbortedRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response sendRequest(Request req, Timeouts con_timeout) throws IOException, ModuleException {
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        Response resp = null;
        this.handleEarlyStall(req);
        String[] con_hdrs = this.assembleHeaders(req, hdr_buf);
        boolean keep_alive = this.determineKeepAlive(con_hdrs);
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            this.handleLateStall(req);
            this.waitForPreviousRequest(req);
            this.waitForOutputStreamToFinish();
            this.checkForAbortedRequest(req);
            int try_count = 3;
            while (try_count-- > 0) {
                try {
                    this.closeStaleSocket();
                    int numOfSocketConnections = this.doConnect(con_timeout, req);
                    Socket sock = this.input_demux.getSocket();
                    this.checkForAbortedRequest(req);
                    logger.log(Level.FINE, "Conn:  Sending Request:\n{0}", hdr_buf);
                    OutputStream sock_out = HTTPConnection.getOutputStream(sock);
                    hdr_buf.writeTo(sock_out);
                    try {
                        if (this.isUsing100Continue(con_hdrs)) {
                            resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                            resp.setPhysicalConnections(numOfSocketConnections);
                            resp.timeout = this.getTimeout() != 0 ? this.Timeout : defaultContinueTimeout;
                            if (resp.getContinue() != 100) {
                                if (req.getStream() == null) break;
                                req.getStream().ignoreData(req);
                                break;
                            }
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                    catch (InterruptedIOException iioe) {
                    }
                    finally {
                        if (resp != null) {
                            resp.timeout = Timeouts.zero;
                        }
                    }
                    keep_alive = this.writeEntityData(req, sock_out, keep_alive);
                    if (req.getStream() != null) {
                        req.getStream().goAhead(req, sock_out, Timeouts.zero);
                    }
                    if (resp != null) break;
                    resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    resp.setPhysicalConnections(numOfSocketConnections);
                    break;
                }
                catch (IOException ioe) {
                    logger.log(Level.FINER, "Conn:  ", ioe);
                    this.closeDemux(ioe, true);
                    if (try_count == 0 || ioe instanceof UnknownHostException || ioe instanceof ConnectException || ioe instanceof NoRouteToHostException || ioe instanceof InterruptedIOException || req.aborted) {
                        throw ioe;
                    }
                    logger.finer("Conn:  Retrying request");
                }
            }
            this.prev_resp = resp;
            this.handleEndOfRequestSend(keep_alive, resp);
            if (this.keepAliveReqMax != -1) {
                logger.log(Level.FINER, "Conn:  Number of requests left: {0}", Integer.toString(this.keepAliveReqLeft));
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = resp;
                resp.markAsFirstResponse(req);
            }
            if (this.isPipeliningDisabled(req)) {
                this.late_stall = resp;
            }
            this.notifyOutputStream(req);
            logger.finer("Conn:  Request sent");
        }
        return resp;
    }

    private Socket getSocket(Timeouts con_timeout) throws IOException {
        int actual_port;
        String actual_host;
        Socket sock = null;
        if (this.Proxy_Host != null) {
            actual_host = this.Proxy_Host;
            actual_port = this.Proxy_Port;
        } else {
            actual_host = this.Host;
            actual_port = this.Port;
        }
        logger.log(Level.FINER, "Conn:  Creating Socket: {0}:{1}", new Object[]{actual_host, Integer.toString(actual_port)});
        if (con_timeout.connection == 0) {
            if (this.Socks_client != null) {
                sock = this.Socks_client.getSocket(actual_host, actual_port);
            } else {
                InetAddress[] addr_list;
                try {
                    addr_list = (InetAddress[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getAllByName(actual_host);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (UnknownHostException)e.getException();
                }
                for (int idx = 0; idx < addr_list.length; ++idx) {
                    try {
                        sock = this.LocalAddr == null ? this.getCurrentSocketFactory().createSocket(addr_list[idx], actual_port) : this.getCurrentSocketFactory().createSocket(addr_list[idx], actual_port, this.LocalAddr, this.LocalPort);
                        break;
                    }
                    catch (SocketException se) {
                        if (idx != addr_list.length - 1) continue;
                        throw se;
                    }
                }
            }
        } else {
            EstablishConnection con = new EstablishConnection(actual_host, actual_port, this.Socks_client);
            con.start();
            try {
                con.join(con_timeout.connection);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (con.getException() != null) {
                throw con.getException();
            }
            sock = con.getSocket();
            if (sock == null) {
                con.forget();
                sock = con.getSocket();
                if (sock == null) {
                    throw new InterruptedIOException("Connection establishment timed out");
                }
            }
        }
        sock.setTcpNoDelay(!HttpClientConfiguration.getNagleAlgorithmEnabled());
        sock.setSoTimeout(con_timeout.read);
        return sock;
    }

    private Response enableSSLTunneling(Socket[] sock, Request req, Timeouts timeout) throws IOException, ModuleException {
        Vector<NVPair> hdrs = new Vector<NVPair>();
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (!name.equalsIgnoreCase("User-Agent") && !name.equalsIgnoreCase("Proxy-Authorization")) continue;
            hdrs.addElement(req.getHeaders()[idx]);
        }
        Object[] h = new NVPair[hdrs.size()];
        hdrs.copyInto(h);
        Request connect = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])h, null, null, req.allowUI());
        connect.internal_subrequest = true;
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        HTTPResponse r = new HTTPResponse(this.gen_mod_insts(), timeout, connect);
        Response resp = null;
        while (true) {
            this.handleRequest(connect, r, resp, true);
            hdr_buf.reset();
            this.assembleHeaders(connect, hdr_buf);
            logger.log(Level.FINER, "Conn:  Sending SSL-Tunneling Subrequest: {0}", hdr_buf);
            hdr_buf.writeTo(HTTPConnection.getOutputStream(sock[0]));
            resp = new Response(connect, HTTPConnection.getInputStream(sock[0]));
            if (resp.getStatusCode() == 200) {
                return null;
            }
            try {
                resp.getData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                sock[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            r.set(connect, resp);
            if (!r.handleResponse()) {
                return resp;
            }
            sock[0] = this.getSocket(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request req, ByteArrayOutputStream hdr_buf) throws IOException {
        con_hdrs = new String[]{"", ""};
        hdrs = req.getHeaders();
        var6_6 = headerBuffer = new StringBuffer(1000);
        synchronized (var6_6) {
            ho_idx = -1;
            ct_idx = -1;
            ua_idx = -1;
            un_idx = -1;
            co_idx = -1;
            pc_idx = -1;
            ka_idx = -1;
            ex_idx = -1;
            te_idx = -1;
            tc_idx = -1;
            ug_idx = -1;
            for (idx = 0; idx < hdrs.length; ++idx) {
                name = hdrs[idx].getName().toLowerCase();
                if (name.equals("host")) {
                    ho_idx = idx;
                    continue;
                }
                if (name.equals("content-type")) {
                    ct_idx = idx;
                    continue;
                }
                if (name.equals("user-agent")) {
                    ua_idx = idx;
                    continue;
                }
                if (name.equals("user-agent-noversion")) {
                    un_idx = idx;
                    continue;
                }
                if (name.equals("connection")) {
                    co_idx = idx;
                    continue;
                }
                if (name.equals("proxy-connection")) {
                    pc_idx = idx;
                    continue;
                }
                if (name.equals("keep-alive")) {
                    ka_idx = idx;
                    continue;
                }
                if (name.equals("expect")) {
                    ex_idx = idx;
                    continue;
                }
                if (name.equals("te")) {
                    te_idx = idx;
                    continue;
                }
                if (name.equals("transfer-encoding")) {
                    tc_idx = idx;
                    continue;
                }
                if (!name.equals("upgrade")) continue;
                ug_idx = idx;
            }
            file = Util.escapeUnsafeChars(req.getRequestURI());
            portString = ":" + this.Port;
            if (this.Protocol == 0 && this.Port == 80) {
                portString = "";
            }
            if (this.Proxy_Host != null && this.Protocol != 1 && !file.equals("*")) {
                headerBuffer.append(req.getMethod()).append(" http://").append(this.Host);
                headerBuffer.append(portString).append(file).append(" ").append(this.RequestProtocolVersion);
                headerBuffer.append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append(req.getMethod()).append(" ").append(file);
                headerBuffer.append(" ").append(this.RequestProtocolVersion).append(HTTPConnection.CR_LF);
            }
            v0 = h_hdr = ho_idx >= 0 ? hdrs[ho_idx].getValue() : this.Host;
            if (this.Port != URI.defaultPort(this.getProtocol())) {
                if (h_hdr.indexOf(58) < 0) {
                    headerBuffer.append("Host: ").append(h_hdr).append(":").append(this.Port).append(HTTPConnection.CR_LF);
                } else if (HTTPConnection.isStringAnIPv6(h_hdr)) {
                    headerBuffer.append("Host: ").append("[" + h_hdr + "]").append(":").append(this.Port).append(HTTPConnection.CR_LF);
                }
            } else if (HTTPConnection.isStringAnIPv6(h_hdr)) {
                headerBuffer.append("Host: ").append("[" + h_hdr + "]").append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("Host: ").append(h_hdr).append(HTTPConnection.CR_LF);
            }
            co_hdr = null;
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || co_idx != -1) {
                if (co_idx == -1) {
                    co_hdr = "Keep-Alive";
                    con_hdrs[0] = "Keep-Alive";
                } else {
                    con_hdrs[0] = hdrs[co_idx].getValue();
                    co_hdr = con_hdrs[0];
                }
                try {
                    if (ka_idx != -1 && Util.hasToken(con_hdrs[0], "keep-alive")) {
                        headerBuffer.append("Keep-Alive: ").append(hdrs[ka_idx].getValue()).append(HTTPConnection.CR_LF);
                    }
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
            }
            if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || co_hdr == null)) {
                headerBuffer.append("Proxy-Connection: ").append(co_hdr).append(HTTPConnection.CR_LF);
                co_hdr = null;
            }
            if (co_hdr != null) {
                try {
                    if (Util.hasToken(co_hdr, "TE")) ** GOTO lbl111
                    co_hdr = co_hdr + ", TE";
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
            } else {
                co_hdr = "TE";
            }
lbl111:
            // 3 sources

            if (ug_idx != -1) {
                co_hdr = co_hdr + ", Upgrade";
            }
            if (co_hdr != null) {
                headerBuffer.append("Connection: ").append(co_hdr).append(HTTPConnection.CR_LF);
            }
            if (te_idx != -1) {
                headerBuffer.append("TE: ");
                try {
                    pte = Util.parseHeader(hdrs[te_idx].getValue());
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                if (!pte.contains(new HttpHeaderElement("trailers"))) {
                    headerBuffer.append("trailers, ");
                }
                headerBuffer.append(hdrs[te_idx].getValue()).append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("TE: trailers\r\n");
            }
            if (un_idx != -1) {
                headerBuffer.append("User-Agent: ").append(hdrs[un_idx].getValue()).append(HTTPConnection.CR_LF);
            } else if (ua_idx != -1) {
                headerBuffer.append("User-Agent: ").append(hdrs[ua_idx].getValue()).append(" ");
                headerBuffer.append(HttpClientConfiguration.getVersion()).append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("User-Agent: ").append(HttpClientConfiguration.getVersion()).append(HTTPConnection.CR_LF);
            }
            for (idx = 0; idx < hdrs.length; ++idx) {
                if (idx == ct_idx || idx == ua_idx || idx == un_idx || idx == co_idx || idx == pc_idx || idx == ka_idx || idx == ex_idx || idx == te_idx || idx == ho_idx) continue;
                headerBuffer.append(hdrs[idx].getName()).append(": ");
                headerBuffer.append(hdrs[idx].getValue()).append(HTTPConnection.CR_LF);
            }
            if (req.getData() != null || req.getStream() != null) {
                headerBuffer.append("Content-type: ");
                if (ct_idx != -1) {
                    headerBuffer.append(hdrs[ct_idx].getValue());
                } else {
                    headerBuffer.append("application/octet-stream");
                }
                headerBuffer.append(HTTPConnection.CR_LF);
                if (req.getData() != null && tc_idx == -1) {
                    headerBuffer.append("Content-length: ").append(req.getData().length);
                    headerBuffer.append(HTTPConnection.CR_LF);
                } else if (tc_idx == -1 && req.getStream() != null && req.getStream().getLength() != -1) {
                    headerBuffer.append("Content-length: ").append(req.getStream().getLength());
                    headerBuffer.append(HTTPConnection.CR_LF);
                }
                if (ex_idx != -1) {
                    con_hdrs[1] = hdrs[ex_idx].getValue();
                    headerBuffer.append("Expect: ").append(con_hdrs[1]).append(HTTPConnection.CR_LF);
                }
            } else if (ex_idx != -1) {
                try {
                    expect_tokens = Util.parseHeader(hdrs[ex_idx].getValue());
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                cont = new HttpHeaderElement("100-continue");
                while (expect_tokens.removeElement(cont)) {
                }
                if (!expect_tokens.isEmpty()) {
                    con_hdrs[1] = Util.assembleHeader(expect_tokens);
                    headerBuffer.append("Expect: ").append(con_hdrs[1]).append(HTTPConnection.CR_LF);
                }
            }
            headerBuffer.append(HTTPConnection.CR_LF);
            hdr_buf.write(Util.buildByteArray(headerBuffer));
        }
        return con_hdrs;
    }

    boolean handleFirstRequest(Request req, Response resp) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(resp.getVersion());
        this.ServProtVersKnown = true;
        int sts = resp.getStatusCode();
        if (this.Proxy_Host != null && this.Protocol != 1 && resp.getHeader("Via") == null && sts != 407 && sts != 502 && sts != 504) {
            this.ServerProtocolVersion = 65536;
        }
        logger.log(Level.FINER, "Conn:  Protocol Version established: {0}", HTTPConnection.ProtVers2String(this.ServerProtocolVersion));
        if (this.ServerProtocolVersion == 65536 && (resp.getStatusCode() == 400 || resp.getStatusCode() == 500) && IdempotentSequence.methodIsIdempotent(req.getMethod())) {
            if (this.input_demux != null) {
                this.input_demux.markForClose(resp);
            }
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response resp) throws IOException {
        try {
            HttpHeaderElement max;
            String con;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (con = resp.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (con = resp.getHeader("Proxy-Connection")) != null) && Util.hasToken(con, "keep-alive")) {
                this.doesKeepAlive = true;
                this.keepAliveUnknown = false;
                logger.finer("Conn:  Keep-Alive enabled");
            } else if (resp.getStatusCode() < 400) {
                this.keepAliveUnknown = false;
            }
            if (this.doesKeepAlive && this.ServerProtocolVersion == 65536 && (con = resp.getHeader("Keep-Alive")) != null && (max = Util.getElement(Util.parseHeader(con), "max")) != null && max.getValue() != null) {
                this.keepAliveReqLeft = this.keepAliveReqMax = Integer.parseInt(max.getValue());
                logger.log(Level.FINER, "Conn:  Max Keep-Alive requests: {0}", Integer.toString(this.keepAliveReqMax));
            }
        }
        catch (ParseException pe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        this.notify();
    }

    synchronized void closeDemux(IOException ioe, boolean was_reset) {
        if (this.input_demux != null) {
            this.input_demux.close(ioe, was_reset);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int prot_vers) {
        return "HTTP/" + (prot_vers >>> 16) + "." + (prot_vers & 0xFFFF);
    }

    static final int String2ProtVers(String prot_vers) {
        String vers = prot_vers.substring(5);
        int dot = vers.indexOf(46);
        return Integer.parseInt(vers.substring(0, dot)) << 16 | Integer.parseInt(vers.substring(dot + 1));
    }

    public String toString() {
        String str = this.getProtocol() + "://";
        str = HTTPConnection.isStringAnIPv6(this.getHost()) ? str + "[" + this.getHost() + "]" : str + this.getHost();
        return str + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    public void connect() throws IOException {
        Request req = new Request(this, "", "", null, null, null, this.allowUI);
        try {
            this.doConnect(this.Timeout, req);
        }
        catch (ModuleException e) {
            throw new IOException(e.toString());
        }
    }

    private int doConnect(Timeouts con_timeout, Request req) throws IOException, ModuleException {
        Response resp = null;
        int numOfSocketConnections = 0;
        if (this.input_demux == null || this.input_demux.getSocket() == null) {
            Socket sock = this.getSocket(con_timeout);
            ++numOfSocketConnections;
            if (this.Protocol == 1) {
                if (this.Proxy_Host != null) {
                    Socket[] sarr = new Socket[]{sock};
                    resp = this.enableSSLTunneling(sarr, req, con_timeout);
                    if (resp != null) {
                        resp.final_resp = true;
                        throw new IOException("Cannot establish proxy connection: " + resp.getStatusCode() + " " + resp.getReasonLine());
                    }
                    sock = sarr[0];
                }
                sock = this.getSSLSocket(sock);
            }
            this.input_demux = new StreamDemultiplexor(this.Protocol, sock, this);
            this.DemuxList.add(this.input_demux);
            this.keepAliveReqLeft = this.keepAliveReqMax;
        }
        return numOfSocketConnections;
    }

    static InputStream getInputStream(final Socket socket) throws IOException {
        if (!HttpClientConfiguration.getInOneTwo()) {
            return new BufferedInputStream(socket.getInputStream());
        }
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new BufferedInputStream(socket.getInputStream());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static OutputStream getOutputStream(final Socket socket) throws IOException {
        if (!HttpClientConfiguration.getInOneTwo()) {
            return socket.getOutputStream();
        }
        try {
            return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return socket.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void addTrustPoint(byte[] certificate) {
        OracleSSLCredentialProxy proxy;
        boolean executed = false;
        if (OracleSSLCredentialProxy.META_DATA.isValid() && null != (proxy = this.getSSLCredentialProxy())) {
            proxy.addTrustedCert(certificate);
            executed = true;
        }
        if (!executed && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Oracle SSL is not currently selected; addTrustPoint(byte[]) is not supported.");
        }
    }

    public void addTrustPoint(String certificate) {
        OracleSSLCredentialProxy proxy;
        boolean executed = false;
        if (OracleSSLCredentialProxy.META_DATA.isValid() && null != (proxy = this.getSSLCredentialProxy())) {
            proxy.addTrustedCert(certificate);
            executed = true;
        }
        if (!executed && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Oracle SSL is not currently selected; addTrustPoint(String) is not supported.");
        }
    }

    public void addTrustPoint(Certificate certificate) throws CertificateEncodingException {
        OracleSSLCredentialProxy proxy;
        boolean executed = false;
        if (OracleSSLCredentialProxy.META_DATA.isValid() && null != (proxy = this.getSSLCredentialProxy())) {
            proxy.addTrustedCert(certificate.getEncoded());
            executed = true;
        }
        if (!executed && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Oracle SSL is not currently selected; addTrustPoint(Certificate) is not supported.");
        }
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory factory) {
        defaultSSLSocketFactory = factory;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        this.m_SSLSocketFactory = factory;
        this.m_ssl = null;
    }

    public static SocketFactory getDefaultSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = SocketFactory.getDefault();
        }
        return defaultSocketFactory;
    }

    public static void setDefaultSocketFactory(SocketFactory factory) {
        defaultSocketFactory = factory;
    }

    public void setCurrentSocketFactory(SocketFactory factory) {
        this.m_socketFactory = factory;
    }

    public SocketFactory getCurrentSocketFactory() {
        SocketFactory factory = this.m_socketFactory;
        if (factory == null) {
            factory = HTTPConnection.getDefaultSocketFactory();
        }
        return factory;
    }

    HTTPClientSSL getSSL() {
        if (this.m_ssl == null) {
            SSLSocketFactory factory = null;
            factory = this.m_SSLSocketFactory != null ? this.m_SSLSocketFactory : (defaultSSLSocketFactory != null ? defaultSSLSocketFactory : null);
            this.m_ssl = HTTPClientSSLFactory.mk(factory);
        }
        return this.m_ssl;
    }

    OracleSSL getOracleSSL() {
        HTTPClientSSL ssl = this.getSSL();
        if (ssl instanceof OracleSSL) {
            return (OracleSSL)ssl;
        }
        return null;
    }

    public Object getSSLCredential() {
        OracleSSLCredentialProxy proxy;
        OracleSSL ssl = this.getOracleSSL();
        if (null != ssl && null != (proxy = ssl.getCredentialProxy())) {
            return proxy.getProxiedObject();
        }
        return null;
    }

    private OracleSSLCredentialProxy getSSLCredentialProxy() {
        OracleSSL ssl = this.getOracleSSL();
        if (null != ssl) {
            return ssl.getCredentialProxy();
        }
        return null;
    }

    public String[] getSSLEnabledCipherSuites() {
        return this.getSSL().getSSLEnabledCipherSuites();
    }

    public SSLSession getSSLSession() {
        return this.getSSL().getSSLSession();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.getSSL().getSSLSocketFactory();
    }

    public Socket getSSLSocket(Socket proxy) throws IOException {
        boolean hostNameOk;
        Socket sslSocket = this.getSSL().getSSLSocket(proxy, this.Host, this.Port);
        HostnameVerifier verifier = this.getHostnameVerifier();
        if (null != verifier && !(hostNameOk = verifier.verify(this.Host, this.getSSL().getSSLSession()))) {
            String message = MessageFormat.format("HostnameVerifier ''{0}'' reports a mismatch between the connection hostname ''{1}'' and the hostname in the SSL session certificate, or hostname verification otherwise failed.", verifier.getClass().getName(), this.Host);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, message);
            }
            throw new SSLPeerUnverifiedException(message);
        }
        return sslSocket;
    }

    void setSSL(HTTPClientSSL ssl) {
        this.m_ssl = ssl;
    }

    public boolean setSSLCredential(Object cred) {
        OracleSSL ssl = this.getOracleSSL();
        if (null != ssl && OracleSSLCredentialProxy.META_DATA.isValid()) {
            OracleSSLCredentialProxy proxy = new OracleSSLCredentialProxy(cred);
            ssl.setSSLCredentialProxy(proxy);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Oracle SSL is not currently selected; setSSLCredential(Object) is not supported.");
        }
        return false;
    }

    public boolean setSSLEnabledCipherSuites(String[] cipherSuites) {
        OracleSSL ssl = this.getOracleSSL();
        if (null != ssl) {
            ssl.setSSLEnabledCipherSuites(cipherSuites);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Oracle SSL is not currently selected; setSSLEnabledCipherSuites(String[]) is not supported.");
        }
        return false;
    }

    public String getQueryEncoding() {
        return this.urlEncoding;
    }

    public void setQueryEncoding(String encoding) {
        this.urlEncoding = encoding;
    }

    public void setChunking(boolean chunkingEnabled) {
        boolean bl = this.no_chunked_instance = !chunkingEnabled;
        if (!this.no_chunked_instance) {
            this.ServProtVersKnown = true;
        }
        logger.log(Level.CONFIG, "Conn: chunking set to {0}", this.no_chunked_instance);
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
        logger.log(Level.CONFIG, "Conn: chunk size set to {0}", new Integer(this.chunkSize));
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setAuthorizationPrompter(AuthorizationPrompter prompter) {
        if (this.Context == null) {
            AuthorizationInfo.removeAuthorization(dflt_context);
        } else {
            AuthorizationInfo.removeAuthorization(this.Context);
        }
        this.m_authPrompter = prompter;
    }

    public AuthorizationPrompter getAuthorizationPrompter() {
        return this.m_authPrompter;
    }

    public void setCookieStore(Map cookieMap) {
        this.m_cookieMap = cookieMap;
    }

    public Map getCookieStore() {
        return this.m_cookieMap;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static HostnameVerifier setDefaultHostnameVerifier(HostnameVerifier defaultHostnameVerifier) {
        HostnameVerifier previous = HTTPConnection.defaultHostnameVerifier;
        HTTPConnection.defaultHostnameVerifier = defaultHostnameVerifier;
        return previous;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (null == this.hostnameVerifier) {
            return defaultHostnameVerifier;
        }
        if (NULL_HOSTNAME_VERIFIER == this.hostnameVerifier) {
            return null;
        }
        return this.hostnameVerifier;
    }

    public HostnameVerifier setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        HostnameVerifier previous = this.getHostnameVerifier();
        this.hostnameVerifier = null == hostnameVerifier ? NULL_HOSTNAME_VERIFIER : hostnameVerifier;
        return previous;
    }

    private boolean isPipeliningDisabled(Request req) {
        return this.keepAliveUnknown || !IdempotentSequence.methodIsIdempotent(req.getMethod()) || req.dont_pipeline || HttpClientConfiguration.getNeverPipeline();
    }

    private void notifyOutputStream(Request req) {
        if (req.getStream() != null && !req.getStream().ignoring()) {
            this.output_finished = false;
        } else {
            this.output_finished = true;
            this.notify();
        }
    }

    private boolean isUsing100Continue(String[] con_hdrs) throws ParseException {
        return this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && Util.hasToken(con_hdrs[1], "100-continue");
    }

    private void handleEndOfRequestSend(boolean keep_alive, Response resp) {
        if (!this.keepAliveUnknown && !this.doesKeepAlive || !keep_alive || this.keepAliveReqMax != -1 && this.keepAliveReqLeft-- == 0) {
            this.input_demux.markForClose(resp);
            logger.finer("Conn: Closing stream");
            this.input_demux = null;
        } else {
            this.input_demux.restartTimer();
        }
    }

    private void checkForAbortedRequest(Request req) throws IOException {
        if (req.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    private void waitForPreviousRequest(Request req) {
        if ((req.getMethod().equals("POST") || req.dont_pipeline) && this.prev_resp != null && this.input_demux != null) {
            logger.log(Level.FINER, "Conn:  Stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
            try {
                this.prev_resp.getVersion();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void waitForOutputStreamToFinish() throws IOException {
        if (!this.output_finished) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie.toString());
            }
        }
    }

    private boolean writeEntityData(Request req, OutputStream sock_out, boolean keep_alive) throws IOException {
        if (req.getData() != null && req.getData().length > 0) {
            if (req.delay_entity > 0L) {
                long num_units = req.delay_entity / 100L;
                long one_unit = req.delay_entity / num_units;
                int idx = 0;
                while ((long)idx < num_units && this.input_demux.available(null) == 0) {
                    try {
                        Thread.sleep(one_unit);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    ++idx;
                }
                if (this.input_demux.available(null) == 0) {
                    this.sendData(req, sock_out);
                } else {
                    keep_alive = false;
                }
            } else {
                this.sendData(req, sock_out);
            }
        }
        return keep_alive;
    }

    private void sendData(Request req, OutputStream sock_out) throws IOException {
        if (req.getStream() == null || this.no_chunked_instance) {
            sock_out.write(req.getData());
            sock_out.flush();
        } else {
            req.getStream().goAhead(req, sock_out, Timeouts.zero);
            int dataSize = req.getData().length;
            int offset = 0;
            int length = 0;
            do {
                length = dataSize < this.chunkSize ? dataSize : this.chunkSize;
                req.getStream().write(req.getData(), offset, length);
                offset += length;
            } while ((dataSize -= length) > 0);
            req.getStream().close();
        }
    }

    private void handleLateStall(Request req) {
        if (this.late_stall != null) {
            if (this.input_demux != null || this.keepAliveUnknown) {
                logger.log(Level.FINER, "Conn:  Stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
                try {
                    this.late_stall.getVersion();
                    if (this.keepAliveUnknown) {
                        this.determineKeepAlive(this.late_stall);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.late_stall = null;
        }
    }

    private boolean determineKeepAlive(String[] con_hdrs) throws IOException {
        boolean keep_alive;
        try {
            keep_alive = this.ServerProtocolVersion >= 65537 && !Util.hasToken(con_hdrs[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(con_hdrs[0], "keep-alive");
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        return keep_alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEarlyStall(Request req) {
        if (this.early_stall != null) {
            try {
                logger.log(Level.FINER, "Conn:  Early-stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
                Response response = this.early_stall;
                synchronized (response) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private String addQueryToFile(String file, NVPair[] form_data) {
        String File2 = HTTPConnection.stripRef(file);
        String query = Codecs.nv2query(form_data, this.urlEncoding);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return File2;
    }

    private String addQueryToFile(String file, String query) {
        String File2 = HTTPConnection.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query, this.urlEncoding);
        }
        return File2;
    }

    private int getProtocol(String protocol) {
        if (protocol.equals("http")) {
            return 0;
        }
        if (protocol.equals("https")) {
            return 1;
        }
        return -1;
    }

    private static void readConfiguration() {
        HTTPConnection.readProxyProperties();
        HTTPConnection.readNonProxyProperties();
        HTTPConnection.readSOCKSProperties();
        HTTPConnection.readModuleProperties();
    }

    private static void readModuleProperties() {
        DefaultModuleList = HttpClientConfiguration.setupDefaultModuleList();
    }

    private static void readSOCKSProperties() {
        try {
            String socksHost = HttpClientConfiguration.getSocksHost();
            if (socksHost != null && socksHost.length() > 0) {
                int socksPort = HttpClientConfiguration.getSocksPort();
                int socksVersion = HttpClientConfiguration.getSocksVersion();
                logger.log(Level.FINER, "Conn:  using SOCKS {0}:{1}", new Object[]{socksHost, Integer.toString(socksPort)});
                if (socksVersion == -1) {
                    HTTPConnection.setSocksServer(socksHost, socksPort);
                } else {
                    HTTPConnection.setSocksServer(socksHost, socksPort, socksVersion);
                }
            }
        }
        catch (Exception e) {
            Default_Socks_client = null;
        }
    }

    private static void readNonProxyProperties() {
        HTTPConnection.dontProxyFor(HttpClientConfiguration.getNonProxyHosts());
    }

    private static void readProxyProperties() {
        if (HttpClientConfiguration.getProxyHost() != null) {
            logger.log(Level.CONFIG, "Conn:  using proxy {0}:{1}", new Object[]{HttpClientConfiguration.getProxyHost(), Integer.toString(HttpClientConfiguration.getProxyPort())});
            HTTPConnection.setProxyServer(HttpClientConfiguration.getProxyHost(), HttpClientConfiguration.getProxyPort());
        }
    }

    private static InetAddress[] privilegedInetAddressGetAllByName(final String host) throws UnknownHostException {
        InetAddress[] retVal = null;
        try {
            retVal = (InetAddress[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getAllByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getException();
        }
        return retVal;
    }

    static void initDefaultHostnameVerifier() {
        block4: {
            String hostnameVerifierClassName = HttpClientConfiguration.getDefaultHostnameVerifier();
            if (null == hostnameVerifierClassName || hostnameVerifierClassName.length() <= 0) {
                return;
            }
            try {
                Class<?> cls = Class.forName(hostnameVerifierClassName);
                Object obj = cls.newInstance();
                if (!(obj instanceof HostnameVerifier)) {
                    throw new ClassCastException("Specified implementation '" + hostnameVerifierClassName + "' is not an instance of '" + HostnameVerifier.class.getName() + "'.");
                }
                defaultHostnameVerifier = (HostnameVerifier)obj;
            }
            catch (Exception e) {
                String message = "Unable to instantiate HostnameVerifier '" + hostnameVerifierClassName + "'.";
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, message, e);
            }
        }
    }

    static {
        non_proxy_host_list = new CIHashtable();
        non_proxy_dom_list = new Vector();
        non_proxy_addr_list = new Vector();
        non_proxy_mask_list = new Vector();
        Default_Socks_client = null;
        DefaultTimeout = Timeouts.zero;
        defaultAllowUI = true;
        defaultHostnameVerifier = null;
        NULL_HOSTNAME_VERIFIER = new HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return false;
            }
        };
        CR_LF = "\r\n".toCharArray();
        logger = HttpClientLoggerFactory.getLogger();
        defaultContinueTimeout = new Timeouts(6000);
        HttpClientConfiguration.readConfigurationProperties();
        HTTPConnection.readConfiguration();
        HTTPConnection.initDefaultHostnameVerifier();
    }

    private class EstablishConnection
    extends Thread {
        String actual_host;
        int actual_port;
        IOException exception;
        Socket sock;
        SocksClient Socks_client;
        boolean close;

        EstablishConnection(String host, int port, SocksClient socks) {
            super("EstablishConnection (" + host + ":" + port + ")");
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ EstablishConnection this$1;
                {
                    this.this$1 = this$1;
                }

                public Object run() {
                    this.this$1.setDaemon(true);
                    return null;
                }
            });
            this.actual_host = host;
            this.actual_port = port;
            this.Socks_client = socks;
            this.exception = null;
            this.sock = null;
            this.close = false;
        }

        public void run() {
            block9: {
                try {
                    if (this.Socks_client != null) {
                        this.sock = this.Socks_client.getSocket(this.actual_host, this.actual_port);
                        break block9;
                    }
                    InetAddress[] addr_list = HTTPConnection.privilegedInetAddressGetAllByName(this.actual_host);
                    for (int idx = 0; idx < addr_list.length; ++idx) {
                        try {
                            this.sock = HTTPConnection.this.LocalAddr == null ? HTTPConnection.this.getCurrentSocketFactory().createSocket(addr_list[idx], this.actual_port) : HTTPConnection.this.getCurrentSocketFactory().createSocket(addr_list[idx], this.actual_port, HTTPConnection.this.LocalAddr, HTTPConnection.this.LocalPort);
                            break;
                        }
                        catch (SocketException se) {
                            if (idx != addr_list.length - 1 && !this.close) continue;
                            throw se;
                        }
                    }
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }
            if (this.close && this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        IOException getException() {
            return this.exception;
        }

        Socket getSocket() {
            return this.sock;
        }

        void forget() {
            this.close = true;
        }
    }
}

