/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientSSL;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.JsseSSL;
import HTTPClient.OracleSSL;
import HTTPClient.OracleSSLSocketFactoryProxy;
import HTTPClient.SystemPropertyNames;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;

public class HTTPClientSSLFactory
implements SystemPropertyNames {
    private static SSLSocketFactory defaultSocketFactory;
    private static Logger logger;

    static void setDefaultSSLSocketFactory(SSLSocketFactory factory) {
        defaultSocketFactory = factory;
    }

    static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSocketFactory;
    }

    static HTTPClientSSL mk(SSLSocketFactory factory) {
        if (factory == null) {
            factory = defaultSocketFactory;
        }
        boolean useOracle = false;
        if (factory == null) {
            if (HttpClientConfiguration.isPreferOracleSsl()) {
                if (OracleSSL.loadOracleSSLClasses(null, true)) {
                    useOracle = true;
                } else {
                    useOracle = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Oracle SSL was preferred, however Oracle SSL is not available on the Classpath.");
                    }
                }
            } else {
                useOracle = false;
            }
        } else {
            useOracle = OracleSSLSocketFactoryProxy.loadClass(null, true) && OracleSSLSocketFactoryProxy.META_DATA.isInstance(factory);
        }
        String sslProvider = useOracle ? "Oracle" : "JSSE";
        logger.log(Level.FINE, "Conn: using SSL version {0}", sslProvider);
        HTTPClientSSL ssl = useOracle ? new OracleSSL(factory) : new JsseSSL(factory);
        return ssl;
    }

    static {
        logger = HttpClientLoggerFactory.getLogger(HTTPClientSSLFactory.class.getName());
    }
}

