/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.Cookie2;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultCookiePolicyHandler;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ProtocolException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CookieModule
implements HTTPClientModule {
    private static WeakHashMap cookie_cntxt_list;
    private static File cookie_jar;
    private static Object cookieSaver;
    private static CookiePolicyHandler cookie_handler;
    private static Logger logger;

    private static void loadCookies() {
        try {
            cookie_jar = new File(CookieModule.getCookieJarName());
            if (cookie_jar.isFile() && cookie_jar.canRead()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cookie_jar));
                cookie_cntxt_list.put(HTTPConnection.getDefaultContext(), ois.readObject());
                ois.close();
            }
        }
        catch (Throwable t) {
            cookie_jar = null;
        }
    }

    private static void saveCookies() {
        if (cookie_jar != null && (!cookie_jar.exists() || cookie_jar.isFile() && cookie_jar.canWrite())) {
            Hashtable<Cookie, Cookie> cookie_list = new Hashtable<Cookie, Cookie>();
            Enumeration enum5 = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext()).elements();
            while (enum5.hasMoreElements()) {
                Cookie cookie = (Cookie)enum5.nextElement();
                if (cookie.discard()) continue;
                cookie_list.put(cookie, cookie);
            }
            if (cookie_list.size() > 0) {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cookie_jar));
                    oos.writeObject(cookie_list);
                    oos.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static String getCookieJarName() {
        String file = null;
        try {
            file = CookieModule.getPrivilegedProperty("HTTPClient.cookies.jar");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            String os = CookieModule.getPrivilegedProperty("os.name");
            file = os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("Windows") ? CookieModule.getPrivilegedProperty("java.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Windows NT") ? CookieModule.getPrivilegedProperty("user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("OS/2") ? CookieModule.getPrivilegedProperty("user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS") ? "System Folder" + File.separator + "Preferences" + File.separator + "HTTPClientCookies" : CookieModule.getPrivilegedProperty("user.home") + File.separator + ".httpclient_cookies")));
        }
        return file;
    }

    private static String getPrivilegedProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    protected CookiePolicyHandler cookieHandler() {
        return cookie_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHandler(Request req, Response[] resp) {
        NVPair[] hdrs = req.getHeaders();
        if (!req.getConnection().usedByHttpURLConnection) {
            int length = hdrs.length;
            for (int idx = 0; idx < hdrs.length; ++idx) {
                int beg = idx;
                while (idx < hdrs.length && hdrs[idx].getName().equalsIgnoreCase("Cookie")) {
                    if (++idx - beg <= 0) continue;
                    System.arraycopy(hdrs, idx, hdrs, beg, (length -= idx - beg) - beg);
                }
            }
            if (length < hdrs.length) {
                hdrs = Util.resizeArray(hdrs, length);
                req.setHeaders(hdrs);
            }
        }
        Map cookie_list = null;
        cookie_list = req.getConnection().getCookieStore() == null ? Util.getList(cookie_cntxt_list, req.getConnection().getContext()) : req.getConnection().getCookieStore();
        if (cookie_list.size() == 0) {
            return 0;
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> lens = new Vector<Integer>();
        int version = 0;
        Map map = cookie_list;
        synchronized (map) {
            Enumeration list = Collections.enumeration(cookie_list.values());
            Vector<Cookie> remove_list = null;
            while (list.hasMoreElements()) {
                int idx;
                Cookie cookie = (Cookie)list.nextElement();
                if (cookie.hasExpired()) {
                    logger.log(Level.FINEST, "CookM - requestHandler : cookie has expired and is being removed: {0}", cookie);
                    if (remove_list == null) {
                        remove_list = new Vector<Cookie>();
                    }
                    remove_list.addElement(cookie);
                    continue;
                }
                CookiePolicyHandler cookie_handler = this.cookieHandler();
                if (!cookie.sendWith(req) || cookie_handler != null && !cookie_handler.sendCookie(cookie, req)) continue;
                int len = cookie.getPath().length();
                for (idx = 0; idx < lens.size() && (Integer)lens.elementAt(idx) >= len; ++idx) {
                }
                names.insertElementAt(cookie.toExternalForm(), idx);
                lens.insertElementAt(new Integer(len), idx);
                if (!(cookie instanceof Cookie2)) continue;
                version = Math.max(version, ((Cookie2)cookie).getVersion());
            }
            if (remove_list != null) {
                for (int idx = 0; idx < remove_list.size(); ++idx) {
                    cookie_list.remove(remove_list.elementAt(idx));
                    remove_list.remove(idx);
                }
            }
        }
        if (!names.isEmpty()) {
            int idx;
            StringBuffer value = new StringBuffer();
            if (version > 0) {
                value.append("$Version=\"" + version + "\"; ");
            }
            value.append((String)names.elementAt(0));
            for (idx = 1; idx < names.size(); ++idx) {
                value.append("; ");
                value.append((String)names.elementAt(idx));
            }
            hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
            hdrs[hdrs.length - 1] = new NVPair("Cookie", value.toString());
            if (version != 1) {
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Cookie2"); ++idx) {
                }
                if (idx == hdrs.length) {
                    hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
                    hdrs[hdrs.length - 1] = new NVPair("Cookie2", "$Version=\"1\"");
                }
            }
            req.setHeaders(hdrs);
            if (value.length() > 0) {
                logger.log(Level.FINEST, "CookM: Sending cookies: {0}", value);
            }
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getHeader("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteHeader("Set-Cookie");
        resp.deleteHeader("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getTrailer("Set-Cookie");
        String set_cookie2 = resp.getTrailer("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteTrailer("Set-Cookie");
        resp.deleteTrailer("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String set_cookie, boolean cookie2, RoRequest req, Response resp) throws ProtocolException {
        Cookie[] cookies = cookie2 ? Cookie2.parse(set_cookie, req.getConnection().getHost(), req.getRequestURI(), req.getConnection().getPort()) : Cookie.parse(set_cookie, req.getConnection().getHost(), req.getRequestURI());
        logger.log(Level.FINEST, "CookM: Received and parsed {0} cookies:", Integer.toString(cookies.length));
        for (int idx = 0; idx < cookies.length; ++idx) {
            logger.log(Level.FINEST, "CookM: Cookie {0} : {1}", new Object[]{Integer.toString(idx), cookies[idx]});
        }
        Map cookie_list = null;
        cookie_list = req.getConnection().getCookieStore() == null ? Util.getList(cookie_cntxt_list, req.getConnection().getContext()) : req.getConnection().getCookieStore();
        Map map = cookie_list;
        synchronized (map) {
            CookiePolicyHandler cookie_handler = this.cookieHandler();
            for (int idx = 0; idx < cookies.length; ++idx) {
                Cookie cookie = (Cookie)cookie_list.get(cookies[idx]);
                if (cookie != null) {
                    if (cookies[idx].hasExpired()) {
                        logger.log(Level.FINEST, "CookM - handleCookie : cookie has expired and is being removed: {0}", cookie);
                        cookie_list.remove(cookie);
                        continue;
                    }
                    if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                    cookie_list.put(cookies[idx], cookies[idx]);
                    continue;
                }
                if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                cookie_list.put(cookies[idx], cookies[idx]);
            }
        }
    }

    public static void discardAllCookies() {
        cookie_cntxt_list.clear();
    }

    public static void discardAllCookies(Object context) {
        if (context != null) {
            cookie_cntxt_list.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        WeakHashMap weakHashMap = cookie_cntxt_list;
        synchronized (weakHashMap) {
            Cookie[] cookies = new Cookie[]{};
            int idx = 0;
            Iterator cntxt_list = cookie_cntxt_list.values().iterator();
            while (cntxt_list.hasNext()) {
                Hashtable cntxt;
                Hashtable hashtable = cntxt = (Hashtable)cntxt_list.next();
                synchronized (hashtable) {
                    cookies = Util.resizeArray(cookies, idx + cntxt.size());
                    Enumeration cookie_list = cntxt.elements();
                    while (cookie_list.hasMoreElements()) {
                        cookies[idx++] = (Cookie)cookie_list.nextElement();
                    }
                }
            }
            return cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[cookie_list.size()];
            int idx = 0;
            Enumeration enum5 = cookie_list.elements();
            while (enum5.hasMoreElements()) {
                cookies[idx++] = (Cookie)enum5.nextElement();
            }
            return cookies;
        }
    }

    public static void addCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler handler) {
        CookiePolicyHandler old = cookie_handler;
        cookie_handler = handler;
        return old;
    }

    static {
        boolean persist;
        cookie_cntxt_list = new WeakHashMap();
        cookie_jar = null;
        cookieSaver = null;
        cookie_handler = new DefaultCookiePolicyHandler();
        logger = HttpClientLoggerFactory.getLogger();
        try {
            Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    boolean b = Boolean.getBoolean("HTTPClient.cookies.save");
                    return new Boolean(b);
                }
            });
            persist = b;
        }
        catch (Exception e) {
            persist = false;
        }
        if (persist) {
            CookieModule.loadCookies();
            cookieSaver = new Object(){

                public void finalize() {
                    CookieModule.saveCookies();
                }
            };
            try {
                System.runFinalizersOnExit((boolean)true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

