/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

final class ChunkedTransferEncoder {
    private ChunkedTransferEncoder() {
    }

    static final byte[] encode(byte[] data, int off, int len, NVPair[] ftrs, boolean last) {
        if (data == null) {
            data = new byte[]{};
            len = 0;
        }
        if (last && ftrs == null) {
            ftrs = new NVPair[]{};
        }
        String hex_len = Integer.toString(len, 16);
        int res_len = 0;
        if (len > 0) {
            res_len += hex_len.length() + 2 + len + 2;
        }
        if (last) {
            res_len += 3;
            for (int idx = 0; idx < ftrs.length; ++idx) {
                res_len += ftrs[idx].getName().length() + 2 + ftrs[idx].getValue().length() + 2;
            }
            res_len += 2;
        }
        byte[] res = new byte[res_len];
        int r_off = 0;
        if (len > 0) {
            int hlen = hex_len.length();
            try {
                System.arraycopy(hex_len.getBytes("8859_1"), 0, res, r_off, hlen);
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            r_off += hlen;
            res[r_off++] = 13;
            res[r_off++] = 10;
            System.arraycopy(data, off, res, r_off, len);
            r_off += len;
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (last) {
            res[r_off++] = 48;
            res[r_off++] = 13;
            res[r_off++] = 10;
            for (int idx = 0; idx < ftrs.length; ++idx) {
                int nlen = ftrs[idx].getName().length();
                try {
                    System.arraycopy(ftrs[idx].getName().getBytes("8859_1"), 0, res, r_off, nlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += nlen;
                res[r_off++] = 58;
                res[r_off++] = 32;
                int vlen = ftrs[idx].getValue().length();
                try {
                    System.arraycopy(ftrs[idx].getValue().getBytes("8859_1"), 0, res, r_off, vlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += vlen;
                res[r_off++] = 13;
                res[r_off++] = 10;
            }
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (r_off != res.length) {
            throw new Error("Calculated " + res.length + " bytes but wrote " + r_off + " bytes!");
        }
        return res;
    }

    static final Object decode(InputStream input) throws ParseException, IOException {
        String line;
        long clen = ChunkedTransferEncoder.getChunkLength(input);
        if (clen > Integer.MAX_VALUE) {
            throw new ParseException("Can't deal with chunk lengths greater Integer.MAX_VALUE: " + clen + " > " + Integer.MAX_VALUE);
        }
        if (clen > 0L) {
            int off;
            byte[] res = new byte[(int)clen];
            int len = 0;
            for (off = 0; len != -1 && off < res.length; off += len) {
                len = input.read(res, off, res.length - off);
            }
            if (len == -1) {
                throw new ParseException("Premature EOF while reading chunk;Expected: " + res.length + " Bytes, " + "Received: " + (off + 1) + " Bytes");
            }
            input.read();
            input.read();
            return res;
        }
        NVPair[] res = new NVPair[]{};
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "8859_1"));
        while ((line = reader.readLine()) != null && line.length() > 0) {
            int colon = line.indexOf(58);
            if (colon == -1) {
                throw new ParseException("Error in Footer format: no ':' found in '" + line + "'");
            }
            res = Util.resizeArray(res, res.length + 1);
            res[res.length - 1] = new NVPair(line.substring(0, colon).trim(), line.substring(colon + 1).trim());
        }
        return res;
    }

    static final long getChunkLength(InputStream input) throws ParseException, IOException {
        int ch;
        byte[] hex_len = new byte[16];
        int off = 0;
        while ((ch = input.read()) > 0 && (ch == 32 || ch == 9)) {
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        hex_len[off++] = (byte)ch;
        while ((ch = input.read()) > 0 && ch != 13 && ch != 10 && ch != 32 && ch != 9 && ch != 59 && off < hex_len.length) {
            hex_len[off++] = (byte)ch;
        }
        while ((ch == 32 || ch == 9) && (ch = input.read()) > 0) {
        }
        if (ch == 59) {
            while ((ch = input.read()) > 0 && ch != 13 && ch != 10) {
            }
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        if (ch != 10 && (ch != 13 || input.read() != 10)) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
        try {
            return Long.parseLong(new String(hex_len, 0, off, "8859_1").trim(), 16);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
    }
}

