/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class AuthorizationModule
implements HTTPClientModule {
    private static WeakHashMap proxy_cntxt_list = new WeakHashMap();
    private static Hashtable deferred_auth_list = new Hashtable();
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private Request saved_req = null;
    private Response saved_resp = null;
    private static Logger logger = HttpClientLoggerFactory.getLogger();
    private static int MAXIMUM_AUTHORIZATION_RETRIES = HttpClientConfiguration.getMaxAuthTries();

    AuthorizationModule() {
    }

    static WeakHashMap getProxy_cntxt_list() {
        return proxy_cntxt_list;
    }

    /*
     * Unable to fully structure code
     */
    public int requestHandler(Request req, Response[] resp) throws IOException, AuthSchemeNotImplException {
        block19: {
            block21: {
                block18: {
                    block20: {
                        con = req.getConnection();
                        auth_handler = AuthorizationInfo.getAuthHandler();
                        hdrs = req.getHeaders();
                        rem_idx = -1;
                        out = req.getStream();
                        if (out != null && AuthorizationModule.deferred_auth_list.get(out) != null) {
                            this.copyFrom((AuthorizationModule)AuthorizationModule.deferred_auth_list.remove(out));
                            req.copyFrom(this.saved_req);
                            AuthorizationModule.logger.finest("AuthM: Handling deferred auth challenge");
                            this.handle_auth_challenge(req, this.saved_resp);
                            if (this.auth_sent != null) {
                                AuthorizationModule.logger.log(Level.FINEST, "AuthM: Sending request with Authorization =  {0} ", this.auth_sent);
                            } else {
                                AuthorizationModule.logger.log(Level.FINEST, "AuthM: Sending request with Proxy-Authorization = {0} ", this.prxy_sent);
                            }
                            return 1;
                        }
                        if (con.getProxyHost() == null || this.prxy_from_4xx) break block18;
                        for (idx = 0; idx < hdrs.length; ++idx) {
                            if (!hdrs[idx].getName().equalsIgnoreCase("Proxy-Authorization")) continue;
                            rem_idx = idx;
                            break;
                        }
                        if ((guess = (AuthorizationInfo)(proxy_auth_list = Util.getList(AuthorizationModule.proxy_cntxt_list, con.getContext())).get(con.getProxyHost() + ":" + con.getProxyPort())) != null) break block20;
                        rem_idx = -1;
                        break block18;
                    }
                    if (auth_handler == null) ** GOTO lbl-1000
                    try {
                        guess = auth_handler.fixupAuthInfo(guess, req, null, null);
                    }
                    catch (AuthSchemeNotImplException asnie) {
                        rem_idx = -1;
                        break block18;
                    }
                    if (guess == null) {
                        rem_idx = -1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (rem_idx == -1) {
                            rem_idx = hdrs.length;
                            hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                            req.setHeaders(hdrs);
                        }
                        hdrs[rem_idx] = new NVPair("Proxy-Authorization", guess.toString());
                        rem_idx = -1;
                        this.prxy_sent = guess;
                        this.prxy_from_4xx = false;
                        AuthorizationModule.logger.log(Level.FINEST, "AuthM: Preemptively sending Proxy-Authorization ' {0} '", guess);
                    }
                }
                if (rem_idx >= 0) {
                    System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
                    hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
                    req.setHeaders(hdrs);
                }
                rem_idx = -1;
                if (this.auth_from_4xx) break block19;
                for (idx = 0; idx < hdrs.length; ++idx) {
                    if (!hdrs[idx].getName().equalsIgnoreCase("Authorization")) continue;
                    rem_idx = idx;
                    break;
                }
                if ((guess = AuthorizationInfo.findBest(req)) != null) break block21;
                rem_idx = -1;
                break block19;
            }
            if (auth_handler == null) ** GOTO lbl-1000
            try {
                guess = auth_handler.fixupAuthInfo(guess, req, null, null);
            }
            catch (AuthSchemeNotImplException asnie) {
                rem_idx = -1;
                break block19;
            }
            if (guess == null) {
                rem_idx = -1;
            } else lbl-1000:
            // 2 sources

            {
                if (rem_idx == -1) {
                    rem_idx = hdrs.length;
                    hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                    req.setHeaders(hdrs);
                }
                hdrs[rem_idx] = new NVPair("Authorization", guess.toString());
                rem_idx = -1;
                this.auth_sent = guess;
                this.auth_from_4xx = false;
                if (guess != null) {
                    AuthorizationModule.logger.log(Level.FINEST, "AuthM: Preemptively sending Authorization:  {0} ", guess);
                }
            }
        }
        if (rem_idx >= 0) {
            System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
            hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
            req.setHeaders(hdrs);
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        if (resp.getStatusCode() != 401 && resp.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, req, resp, false).addPath(req.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
        if (resp.getHeader("WWW-Authenticate") == null) {
            this.auth_scm_idx = 0;
        }
        if (resp.getHeader("Proxy-Authenticate") == null) {
            this.prxy_scm_idx = 0;
        }
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthHeaders(resp, req, this.auth_sent, this.prxy_sent);
        }
        int sts = resp.getStatusCode();
        switch (sts) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > MAXIMUM_AUTHORIZATION_RETRIES) {
                    logger.log(Level.FINEST, "AuthM: Server refused the given Authorization info {} times, aborting request", Integer.toString(this.num_tries));
                    return 12;
                }
                if (req.getStream() != null) {
                    if (!HttpClientConfiguration.getDeferStreamed()) {
                        logger.log(Level.FINEST, "AuthM: status {0} not handled - request has an output stream", Integer.toString(sts));
                        return 10;
                    }
                    this.saved_req = (Request)req.clone();
                    this.saved_resp = (Response)resp.clone();
                    deferred_auth_list.put(req.getStream(), this);
                    req.getStream().reset();
                    resp.setRetryRequest(true);
                    logger.log(Level.FINEST, "AuthM: Handling of status {0}  deferred because an output stream was used", Integer.toString(sts));
                    return 10;
                }
                logger.log(Level.FINEST, "AuthM: Handling status: {0} {1}", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                this.handle_auth_challenge(req, resp);
                if (this.auth_sent != null || this.prxy_sent != null) {
                    try {
                        resp.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (this.auth_sent != null) {
                        logger.log(Level.FINEST, "AuthM: Resending request with Authorization ' {0} '", this.auth_sent);
                    } else {
                        logger.log(Level.FINEST, "AuthM: Resending request with Proxy-Authorization ' {0} '", this.prxy_sent);
                    }
                    return 13;
                }
                if (req.getStream() != null) {
                    logger.log(Level.FINEST, "AuthM: status {0} not handled - request has an output stream", Integer.toString(sts));
                } else {
                    logger.log(Level.FINEST, "AuthM: No Auth Info found status {0} not handled", Integer.toString(sts));
                }
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthTrailers(resp, req, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request req, Response resp) throws AuthSchemeNotImplException, IOException {
        int[] idx_arr = new int[]{0, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(resp.getHeader("WWW-Authenticate"), req, resp, "Authorization", idx_arr, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
            this.auth_scm_idx = idx_arr[1];
        } else {
            this.auth_scm_idx = 0;
        }
        idx_arr[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(resp.getHeader("Proxy-Authenticate"), req, resp, "Proxy-Authorization", idx_arr, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
            this.prxy_scm_idx = idx_arr[1];
        } else {
            this.prxy_scm_idx = 0;
        }
        if (this.prxy_sent != null) {
            HTTPConnection con = req.getConnection();
            Util.getList(proxy_cntxt_list, con.getContext()).put(con.getProxyHost() + ":" + con.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && resp.getHeader("WWW-Authenticate") == null && resp.getHeader("Proxy-Authenticate") == null) {
            if (resp.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
            throw new ProtocolException("Missing Proxy-Authenticate header");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationInfo setAuthHeaders(String auth_str, Request req, RoResponse resp, String header, int[] idx_arr, AuthorizationInfo prev) throws ProtocolException, AuthSchemeNotImplException, IOException {
        int auth_idx;
        int idx;
        if (auth_str == null) {
            return null;
        }
        AuthorizationInfo[] challenges = AuthorizationInfo.parseAuthString(auth_str, req, resp);
        logger.log(Level.FINEST, "AuthM: parsed {0} challenges:", Integer.toString(challenges.length));
        for (idx = 0; idx < challenges.length; ++idx) {
            logger.log(Level.FINEST, "AuthM: Challenge {0}", challenges[idx]);
        }
        if (challenges.length == 0) {
            return null;
        }
        if (prev != null && prev.getScheme().equalsIgnoreCase("Basic")) {
            for (idx = 0; idx < challenges.length; ++idx) {
                if (!prev.getRealm().equals(challenges[idx].getRealm()) || !prev.getScheme().equalsIgnoreCase(challenges[idx].getScheme())) continue;
                AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
            }
        }
        AuthorizationInfo credentials = null;
        AuthorizationHandler auth_handler = AuthorizationInfo.getAuthHandler();
        for (int i = 0; i < challenges.length; ++i) {
            credentials = AuthorizationInfo.getAuthorization(challenges[i], req, resp, false);
            if (auth_handler != null && credentials != null) {
                credentials = auth_handler.fixupAuthInfo(credentials, req, challenges[i], resp);
            }
            if (credentials != null) break;
        }
        if (credentials == null) {
            for (int idx2 = 0; idx2 < challenges.length; ++idx2) {
                if (idx_arr[1] >= challenges.length) {
                    idx_arr[1] = 0;
                }
                try {
                    credentials = AuthorizationInfo.queryAuthHandler(challenges[idx_arr[1]], req, resp);
                    break;
                }
                catch (AuthSchemeNotImplException asnie) {
                    if (idx2 != challenges.length - 1) continue;
                    throw asnie;
                }
                finally {
                    idx_arr[1] = idx_arr[1] + 1;
                }
            }
        }
        if (credentials == null) {
            return null;
        }
        NVPair[] hdrs = req.getHeaders();
        for (auth_idx = 0; auth_idx < hdrs.length && !hdrs[auth_idx].getName().equalsIgnoreCase(header); ++auth_idx) {
        }
        if (auth_idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, auth_idx + 1);
            req.setHeaders(hdrs);
        }
        hdrs[auth_idx] = new NVPair(header, credentials.toString());
        return credentials;
    }

    private void copyFrom(AuthorizationModule other) {
        this.auth_scm_idx = other.auth_scm_idx;
        this.prxy_scm_idx = other.prxy_scm_idx;
        this.auth_sent = other.auth_sent;
        this.prxy_sent = other.prxy_sent;
        this.auth_from_4xx = other.auth_from_4xx;
        this.prxy_from_4xx = other.prxy_from_4xx;
        this.num_tries = other.num_tries;
        this.saved_req = other.saved_req;
        this.saved_resp = other.saved_resp;
    }

    public static void removeAuthorization(AuthorizationInfo auth_info, Object context) {
        Hashtable proxy_auth_list = Util.getList(proxy_cntxt_list, context);
        proxy_auth_list.remove(auth_info.getHost() + ":" + auth_info.getPort());
    }
}

