/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthenticationScheme;
import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.SystemPropertyNames;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AuthenticationSchemeRegistry
implements SystemPropertyNames {
    public static final String RESP_AUTH_HEADER = "www-authenticate";
    public static final String RESP_AUTH_PROXY_HEADER = "proxy-authenticate";
    private static Logger logger = HttpClientLoggerFactory.getLogger(AuthenticationSchemeRegistry.class.getName());
    private Map map = new Hashtable(10);
    public static final String[] BUILT_IN_AUTHENTICATION_SCHEMES = new String[]{"HTTPClient.ntlm.NtlmAuthenticationScheme"};

    protected AuthenticationSchemeRegistry() {
    }

    public static AuthenticationSchemeRegistry newInstance(boolean preLoad) {
        AuthenticationSchemeRegistry registry = new AuthenticationSchemeRegistry();
        if (preLoad) {
            registry.loadSchemes();
        }
        return registry;
    }

    private static String makeCaseInsensitive(String input) {
        if (null == input) {
            return input;
        }
        return input.toLowerCase();
    }

    private static void validateSchemeName(String schemeName) throws IllegalArgumentException {
        if (null == schemeName || "".equals(schemeName)) {
            throw new IllegalArgumentException("Non-null or non-empty schemeName expected.");
        }
    }

    public AuthenticationScheme addScheme(AuthenticationScheme schemeObject) throws IllegalArgumentException {
        if (null == schemeObject) {
            throw new IllegalArgumentException("Non-null schemeObject expected.");
        }
        String schemeName = schemeObject.getSchemeName();
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        AuthenticationScheme previous = this.map.put(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName), schemeObject);
        return previous;
    }

    public AuthenticationScheme getScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        Object obj = this.map.get(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
        return (AuthenticationScheme)obj;
    }

    public boolean hasScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        return this.map.containsKey(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getSchemeCount() {
        return this.map.size();
    }

    public AuthenticationScheme removeScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        Object previous = this.map.remove(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
        return (AuthenticationScheme)previous;
    }

    public void removeAllSchemes() {
        this.map.clear();
    }

    public Iterator getSchemeNameIterator() {
        Set schemeSet = this.map.keySet();
        return schemeSet.iterator();
    }

    protected AuthenticationScheme createScheme(String schemeClassName) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        if (null == schemeClassName || "".equals(schemeClassName)) {
            throw new IllegalArgumentException("Non-null, non-empty schemeClassName expected.");
        }
        Class<?> schemeClass = Class.forName(schemeClassName);
        Object obj = schemeClass.newInstance();
        if (!(obj instanceof AuthenticationScheme)) {
            throw new ClassCastException("'" + schemeClassName + "' is not an instance of '" + AuthenticationScheme.class.getName() + "'.");
        }
        AuthenticationScheme schemeObj = (AuthenticationScheme)obj;
        return schemeObj;
    }

    public int loadSchemes() {
        int failureCount = 0;
        for (int i = 0; i < BUILT_IN_AUTHENTICATION_SCHEMES.length; ++i) {
            String schemeClassName = BUILT_IN_AUTHENTICATION_SCHEMES[i];
            try {
                AuthenticationScheme schemeObj = this.createScheme(schemeClassName);
                this.addScheme(schemeObj);
                continue;
            }
            catch (Exception e) {
                ++failureCount;
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Unable to register built-in AuthenticationScheme '" + schemeClassName + "'.", e);
            }
        }
        NVPair[] sysPropSchemes = HttpClientConfiguration.getAuthenticationSchemes();
        if (null != sysPropSchemes) {
            for (int i = 0; i < sysPropSchemes.length; ++i) {
                String schemeName = sysPropSchemes[i].getName();
                String schemeClassName = sysPropSchemes[i].getValue();
                try {
                    AuthenticationScheme schemeObj = this.createScheme(schemeClassName);
                    schemeObj.setSchemeName(schemeName);
                    this.addScheme(schemeObj);
                    continue;
                }
                catch (Exception e) {
                    ++failureCount;
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.log(Level.FINER, "Unable to register AuthenticationScheme '" + schemeClassName + "' for scheme name '" + schemeName + "'.", e);
                }
            }
        }
        return failureCount;
    }

    public boolean isAnyAuthChallengeConnectionOriented(CIHashtable headers, boolean forProxy) throws IllegalArgumentException {
        if (null == headers) {
            throw new IllegalArgumentException("Non-null headers expected.");
        }
        String headerName = null;
        headerName = forProxy ? RESP_AUTH_PROXY_HEADER : RESP_AUTH_HEADER;
        String headerValue = (String)headers.get(headerName);
        if (null == headerValue) {
            return false;
        }
        String dummyHost = "";
        int dummyPort = -1;
        Iterator iter = this.getSchemeNameIterator();
        while (iter.hasNext()) {
            String schemeName = (String)iter.next();
            boolean isConnectionOriented = this.getScheme(schemeName).isConnectionOriented();
            if (!isConnectionOriented) continue;
            try {
                AuthorizationInfo[] challenges = AuthorizationInfo.parseAuthString(headerValue, "", -1);
                if (null == challenges) continue;
                for (int i = 0; i < challenges.length; ++i) {
                    if (!challenges[i].getScheme().equalsIgnoreCase(schemeName)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Unable to parse header '" + headerName + ":" + headerValue + "'.", e);
            }
        }
        return false;
    }
}

