/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthenticationScheme;
import HTTPClient.HttpClientLoggerFactory;
import java.util.logging.Logger;

public abstract class AuthenticationSchemeBase
implements AuthenticationScheme {
    private static Logger logger = HttpClientLoggerFactory.getLogger(AuthenticationSchemeBase.class.getName());
    private String schemeName = null;
    private boolean isConnectionOriented = false;

    protected AuthenticationSchemeBase(String schemeName, boolean isConnectionOriented) throws IllegalArgumentException {
        this.setSchemeName(schemeName);
        this.isConnectionOriented = isConnectionOriented;
    }

    public final String getSchemeName() {
        return this.schemeName;
    }

    public final String setSchemeName(String schemeName) {
        String prevName = this.schemeName;
        if (null == schemeName || "".equals(schemeName)) {
            throw new IllegalArgumentException("Null or empty scheme name given.");
        }
        this.schemeName = schemeName;
        return prevName;
    }

    public boolean isConnectionOriented() {
        return this.isConnectionOriented;
    }
}

