/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraDefaultDecimalFormatPattern;
import oracle.i18n.util.GDKOracleMetaData;

public class OraTerritory
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static final String NAME_PREFIX = GDKOracleMetaData.getDataPath();
    private static final HashMap m_objCache = new HashMap();
    protected String VERSION;
    protected String INFO;
    protected String Name;
    protected String Id;
    protected String StartDayOfTheWeek;
    protected String NegativeSignLocation;
    protected String ISOWeekFlag;
    protected String MetricMeasurementFlag;
    protected String RoundingIndicator;
    protected String MinAccountingUnit;
    protected String InternationalMonetaryFraction;
    protected String MonetaryFraction;
    protected String DebitSignFlag;
    protected String CreditSignFlag;
    protected String CurrencyDebitCreditFlag;
    protected String ISOAbbreviation;
    protected String DecimalCharacter;
    protected String GroupSeparator;
    protected String NumberDigitsForNumberGrouping;
    protected String InternationalCurrencySymbol;
    protected String LocalCurrencySymbol;
    protected String DecimalMonetaryChar;
    protected String MonetaryGroupSeparator;
    protected String NumberDigitsForMonetaryGrouping;
    protected String ListSeparator;
    protected String DebitSymbol;
    protected String CreditSymbol;
    protected String InternationalCurrencySeparator;
    protected String DateTimeFormatString;
    protected String DateFormatString;
    protected String TimeFormatString;
    protected String OracleDateFormatString;
    protected String OracleTimeFormatString;
    protected String UnionCurrencySymbol;
    protected String NLSTimeFormatString;
    protected String NLSTimestampFormatString;
    protected String NLSTimeAndTimezoneFormatString;
    protected String NLSTimestampAndTimezoneFormatString;
    protected String NLSTimeShortFormat;
    protected String NLSDateShortFormat;
    protected String NLSDateLongFormat;
    protected OraDefaultDecimalFormatPattern NLSNumberFormatPositive;
    protected OraDefaultDecimalFormatPattern NLSNumberFormatNegative;
    protected OraDefaultDecimalFormatPattern NLSCurrencyFormatPositive;
    protected OraDefaultDecimalFormatPattern NLSCurrencyFormatNegative;
    protected String[] CommonLanguages;
    protected String[] CommonTimeZones;

    public static synchronized OraTerritory getInstance(String string, String string2) {
        String string3 = string.toUpperCase(Locale.US) + "_" + string2.toUpperCase(Locale.US);
        OraTerritory oraTerritory = (OraTerritory)m_objCache.get(string3);
        if (oraTerritory != null) {
            return oraTerritory;
        }
        String string4 = NAME_PREFIX + OraBoot.getInstance().getTerritoryFileName(string.equals("") ? null : string, string2) + ".glb";
        oraTerritory = (OraTerritory)OraBoot.readObj((String)string4);
        if (oraTerritory != null) {
            m_objCache.put(string3, oraTerritory);
        }
        return oraTerritory;
    }

    public static OraTerritory getInstance(String string) {
        return OraTerritory.getInstance("", string);
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public String getINFO() {
        return this.INFO;
    }

    public String getName() {
        return this.Name;
    }

    public String getId() {
        return this.Id;
    }

    public String getStartDayOfTheWeek() {
        return this.StartDayOfTheWeek;
    }

    public String getNegativeSignLocation() {
        return this.NegativeSignLocation;
    }

    public String getISOWeekFlag() {
        return this.ISOWeekFlag;
    }

    public String getMetricMeasurementFlag() {
        return this.MetricMeasurementFlag;
    }

    public String getRoundingIndicator() {
        return this.RoundingIndicator;
    }

    public String getMinAccountingUnit() {
        return this.MinAccountingUnit;
    }

    public String getInternationalMonetaryFraction() {
        return this.InternationalMonetaryFraction;
    }

    public String getMonetaryFraction() {
        return this.MonetaryFraction;
    }

    public String getDebitSignFlag() {
        return this.DebitSignFlag;
    }

    public String getCreditSignFlag() {
        return this.CreditSignFlag;
    }

    public String getCurrencyDebitCreditFlag() {
        return this.CurrencyDebitCreditFlag;
    }

    public String getISOAbbreviation() {
        return this.ISOAbbreviation;
    }

    public String getDecimalCharacter() {
        return this.DecimalCharacter;
    }

    public String getGroupSeparator() {
        return this.GroupSeparator;
    }

    public String getNumberDigitsForNumberGrouping() {
        return this.NumberDigitsForNumberGrouping;
    }

    public String getInternationalCurrencySymbol() {
        return this.InternationalCurrencySymbol;
    }

    public String getLocalCurrencySymbol() {
        return this.LocalCurrencySymbol;
    }

    public String getDecimalMonetaryChar() {
        return this.DecimalMonetaryChar;
    }

    public String getMonetaryGroupSeparator() {
        return this.MonetaryGroupSeparator;
    }

    public String getNumberDigitsForMonetaryGrouping() {
        return this.NumberDigitsForMonetaryGrouping;
    }

    public String getListSeparator() {
        return this.ListSeparator;
    }

    public String getDebitSymbol() {
        return this.DebitSymbol;
    }

    public String getCreditSymbol() {
        return this.CreditSymbol;
    }

    public String getInternationalCurrencySeparator() {
        return this.InternationalCurrencySeparator;
    }

    public String getDateTimeFormatString() {
        return this.DateTimeFormatString;
    }

    public String getDateFormatString() {
        return this.DateFormatString;
    }

    public String getTimeFormatString() {
        return this.TimeFormatString;
    }

    public String getOracleDateFormatString() {
        return this.OracleDateFormatString;
    }

    public String getOracleTimeFormatString() {
        return this.OracleTimeFormatString;
    }

    public String getUnionCurrencySymbol() {
        return this.UnionCurrencySymbol;
    }

    public String getNLSTimeFormatString() {
        return this.NLSTimeFormatString;
    }

    public String getNLSTimestampFormatString() {
        return this.NLSTimestampFormatString;
    }

    public String getNLSTimeAndTimezoneFormatString() {
        return this.NLSTimeAndTimezoneFormatString;
    }

    public String getNLSTimestampAndTimezoneFormatString() {
        return this.NLSTimestampAndTimezoneFormatString;
    }

    public String getNLSTimeShortFormat() {
        return this.NLSTimeShortFormat;
    }

    public String getNLSDateShortFormat() {
        return this.NLSDateShortFormat;
    }

    public String getNLSDateLongFormat() {
        return this.NLSDateLongFormat;
    }

    public OraDefaultDecimalFormatPattern getNLSNumberFormatPositive() {
        return this.NLSNumberFormatPositive;
    }

    public OraDefaultDecimalFormatPattern getNLSNumberFormatNegative() {
        return this.NLSNumberFormatNegative;
    }

    public OraDefaultDecimalFormatPattern getNLSCurrencyFormatPositive() {
        return this.NLSCurrencyFormatPositive;
    }

    public OraDefaultDecimalFormatPattern getNLSCurrencyFormatNegative() {
        return this.NLSCurrencyFormatNegative;
    }

    public String[] getLocalLanguages() {
        return this.CommonLanguages;
    }

    public String[] getLocalTimeZoneIds() {
        return this.CommonTimeZones;
    }
}

