/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import java.security.ProviderException;

public final class UcryptoException
extends ProviderException {
    private static final long serialVersionUID = -933864511110035746L;
    private static final String[] ERROR_MSG = new String[]{"CRYPTO_SUCCESS", "CRYPTO_CANCEL", "CRYPTO_HOST_MEMORY", "CRYPTO_GENERAL_ERROR", "CRYPTO_FAILED", "CRYPTO_ARGUMENTS_BAD", "CRYPTO_ATTRIBUTE_READ_ONLY", "CRYPTO_ATTRIBUTE_SENSITIVE", "CRYPTO_ATTRIBUTE_TYPE_INVALID", "CRYPTO_ATTRIBUTE_VALUE_INVALID", "CRYPTO_CANCELED", "CRYPTO_DATA_INVALID", "CRYPTO_DATA_LEN_RANGE", "CRYPTO_DEVICE_ERROR", "CRYPTO_DEVICE_MEMORY", "CRYPTO_DEVICE_REMOVED", "CRYPTO_ENCRYPTED_DATA_INVALID", "CRYPTO_ENCRYPTED_DATA_LEN_RANGE", "CRYPTO_KEY_HANDLE_INVALID", "CRYPTO_KEY_SIZE_RANGE", "CRYPTO_KEY_TYPE_INCONSISTENT", "CRYPTO_KEY_NOT_NEEDED", "CRYPTO_KEY_CHANGED", "CRYPTO_KEY_NEEDED", "CRYPTO_KEY_INDIGESTIBLE", "CRYPTO_KEY_FUNCTION_NOT_PERMITTED", "CRYPTO_KEY_NOT_WRAPPABLE", "CRYPTO_KEY_UNEXTRACTABLE", "CRYPTO_MECHANISM_INVALID", "CRYPTO_MECHANISM_PARAM_INVALID", "CRYPTO_OBJECT_HANDLE_INVALID", "CRYPTO_OPERATION_IS_ACTIVE", "CRYPTO_OPERATION_NOT_INITIALIZED", "CRYPTO_PIN_INCORRECT", "CRYPTO_PIN_INVALID", "CRYPTO_PIN_LEN_RANGE", "CRYPTO_PIN_EXPIRED", "CRYPTO_PIN_LOCKED", "CRYPTO_SESSION_CLOSED", "CRYPTO_SESSION_COUNT", "CRYPTO_SESSION_HANDLE_INVALID", "CRYPTO_SESSION_READ_ONLY", "CRYPTO_SESSION_EXISTS", "CRYPTO_SESSION_READ_ONLY_EXISTS", "CRYPTO_SESSION_READ_WRITE_SO_EXISTS", "CRYPTO_SIGNATURE_INVALID", "CRYPTO_SIGNATURE_LEN_RANGE", "CRYPTO_TEMPLATE_INCOMPLETE", "CRYPTO_TEMPLATE_INCONSISTENT", "CRYPTO_UNWRAPPING_KEY_HANDLE_INVALID", "CRYPTO_UNWRAPPING_KEY_SIZE_RANGE", "CRYPTO_UNWRAPPING_KEY_TYPE_INCONSISTENT", "CRYPTO_USER_ALREADY_LOGGED_IN", "CRYPTO_USER_NOT_LOGGED_IN", "CRYPTO_USER_PIN_NOT_INITIALIZED", "CRYPTO_USER_TYPE_INVALID", "CRYPTO_USER_ANOTHER_ALREADY_LOGGED_IN", "CRYPTO_USER_TOO_MANY_TYPES", "CRYPTO_WRAPPED_KEY_INVALID", "CRYPTO_WRAPPED_KEY_LEN_RANGE", "CRYPTO_WRAPPING_KEY_HANDLE_INVALID", "CRYPTO_WRAPPING_KEY_SIZE_RANGE", "CRYPTO_WRAPPING_KEY_TYPE_INCONSISTENT", "CRYPTO_RANDOM_SEED_NOT_SUPPORTED", "CRYPTO_RANDOM_NO_RNG", "CRYPTO_DOMAIN_PARAMS_INVALID", "CRYPTO_BUFFER_TOO_SMALL", "CRYPTO_INFORMATION_SENSITIVE", "CRYPTO_NOT_SUPPORTED", "CRYPTO_QUEUED", "CRYPTO_BUFFER_TOO_BIG", "CRYPTO_INVALID_CONTEXT", "CRYPTO_INVALID_MAC", "CRYPTO_MECH_NOT_SUPPORTED", "CRYPTO_INCONSISTENT_ATTRIBUTE", "CRYPTO_NO_PERMISSION", "CRYPTO_INVALID_PROVIDER_ID", "CRYPTO_VERSION_MISMATCH", "CRYPTO_BUSY", "CRYPTO_UNKNOWN_PROVIDER", "CRYPTO_MODVERIFICATION_FAILED", "CRYPTO_OLD_CTX_TEMPLATE", "CRYPTO_WEAK_KEY", "CRYPTO_FIPS140_ERROR"};
    private final int errorCode;

    static String getErrorMessage(int n) {
        String string = n < ERROR_MSG.length ? ERROR_MSG[n] : "0x" + Integer.toHexString(n);
        return string;
    }

    public UcryptoException(int n) {
        super(UcryptoException.getErrorMessage(n));
        this.errorCode = n;
    }

    public UcryptoException(String string) {
        super(string);
        this.errorCode = -1;
    }

    public UcryptoException(String string, Throwable throwable) {
        super(string, throwable);
        this.errorCode = -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

