/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

abstract class NativeKey
implements Key {
    private static final long serialVersionUID = 6812507588904302830L;
    private final int numComponents;

    NativeKey(int n) {
        this.numComponents = n;
    }

    abstract long value();

    int length() {
        return this.numComponents;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    private static native void nativeFree(long var0, int var2);

    static byte[] getMagnitude(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private static class KeyRef
    extends PhantomReference<NativeKey>
    implements Comparable<KeyRef> {
        private static ReferenceQueue<NativeKey> refQueue = new ReferenceQueue();
        private static Set<KeyRef> refList = new ConcurrentSkipListSet<KeyRef>();
        private final long id;
        private final int length;

        private static void drainRefQueueBounded() {
            KeyRef keyRef;
            while ((keyRef = (KeyRef)refQueue.poll()) != null) {
                keyRef.dispose();
            }
        }

        KeyRef(NativeKey nativeKey, long l) {
            super(nativeKey, refQueue);
            this.id = l;
            this.length = nativeKey.length();
            refList.add(this);
            UcryptoProvider.debug("Resource: track NativeKey " + this.id);
            KeyRef.drainRefQueueBounded();
        }

        @Override
        public int compareTo(KeyRef keyRef) {
            if (this.id == keyRef.id) {
                return 0;
            }
            return this.id < keyRef.id ? -1 : 1;
        }

        void dispose() {
            refList.remove(this);
            UcryptoProvider.debug("Resource: free NativeKey " + this.id);
            try {
                NativeKey.nativeFree(this.id, this.length);
            }
            finally {
                this.clear();
            }
        }
    }

    static final class RSAPublic
    extends NativeKey
    implements RSAPublicKey {
        private static final long serialVersionUID = 6812507588904302832L;
        private final RSAPublicKeySpec keySpec;
        private final long keyId;

        RSAPublic(KeySpec keySpec) throws InvalidKeySpecException {
            super(2);
            long l = 0L;
            if (!(keySpec instanceof RSAPublicKeySpec)) {
                throw new InvalidKeySpecException("Only supports RSAPublicKeySpec");
            }
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            BigInteger bigInteger = rSAPublicKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
            l = RSAPublic.nativeInit(NativeKey.getMagnitude(bigInteger), NativeKey.getMagnitude(bigInteger2));
            if (l == 0L) {
                throw new UcryptoException("Error constructing RSA PublicKey");
            }
            new KeyRef(this, l);
            this.keySpec = (RSAPublicKeySpec)keySpec;
            this.keyId = l;
        }

        @Override
        long value() {
            return this.keyId;
        }

        @Override
        public BigInteger getModulus() {
            return this.keySpec.getModulus();
        }

        @Override
        public BigInteger getPublicExponent() {
            return this.keySpec.getPublicExponent();
        }

        private static native long nativeInit(byte[] var0, byte[] var1);
    }

    static final class RSAPrivateCrt
    extends NativeKey
    implements RSAPrivateCrtKey {
        private static final long serialVersionUID = 6812507588904302831L;
        private final RSAPrivateCrtKeySpec keySpec;
        private final long keyId;

        RSAPrivateCrt(KeySpec keySpec) throws InvalidKeySpecException {
            super(8);
            long l = 0L;
            if (!(keySpec instanceof RSAPrivateCrtKeySpec)) {
                throw new InvalidKeySpecException("Only supports RSAPrivateCrtKeySpec");
            }
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            BigInteger bigInteger = rSAPrivateCrtKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
            BigInteger bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
            BigInteger bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
            BigInteger bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
            BigInteger bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
            BigInteger bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
            l = RSAPrivateCrt.nativeInit(NativeKey.getMagnitude(bigInteger), NativeKey.getMagnitude(bigInteger2), NativeKey.getMagnitude(bigInteger3), NativeKey.getMagnitude(bigInteger4), NativeKey.getMagnitude(bigInteger5), NativeKey.getMagnitude(bigInteger6), NativeKey.getMagnitude(bigInteger7), NativeKey.getMagnitude(bigInteger8));
            if (l == 0L) {
                throw new UcryptoException("Error constructing RSA PrivateCrtKey");
            }
            new KeyRef(this, l);
            this.keySpec = (RSAPrivateCrtKeySpec)keySpec;
            this.keyId = l;
        }

        @Override
        long value() {
            return this.keyId;
        }

        @Override
        public BigInteger getModulus() {
            return this.keySpec.getModulus();
        }

        @Override
        public BigInteger getPublicExponent() {
            return this.keySpec.getPublicExponent();
        }

        @Override
        public BigInteger getPrivateExponent() {
            return this.keySpec.getPrivateExponent();
        }

        @Override
        public BigInteger getPrimeP() {
            return this.keySpec.getPrimeP();
        }

        @Override
        public BigInteger getPrimeQ() {
            return this.keySpec.getPrimeQ();
        }

        @Override
        public BigInteger getPrimeExponentP() {
            return this.keySpec.getPrimeExponentP();
        }

        @Override
        public BigInteger getPrimeExponentQ() {
            return this.keySpec.getPrimeExponentQ();
        }

        @Override
        public BigInteger getCrtCoefficient() {
            return this.keySpec.getCrtCoefficient();
        }

        private static native long nativeInit(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);
    }

    static final class RSAPrivate
    extends NativeKey
    implements RSAPrivateKey {
        private static final long serialVersionUID = 1622705588904302831L;
        private final RSAPrivateKeySpec keySpec;
        private final long keyId;

        RSAPrivate(KeySpec keySpec) throws InvalidKeySpecException {
            super(2);
            long l = 0L;
            if (!(keySpec instanceof RSAPrivateKeySpec)) {
                throw new InvalidKeySpecException("Only supports RSAPrivateKeySpec");
            }
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            BigInteger bigInteger = rSAPrivateKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPrivateKeySpec.getPrivateExponent();
            l = RSAPrivate.nativeInit(NativeKey.getMagnitude(bigInteger), NativeKey.getMagnitude(bigInteger2));
            if (l == 0L) {
                throw new UcryptoException("Error constructing RSA PrivateKey");
            }
            new KeyRef(this, l);
            this.keySpec = (RSAPrivateKeySpec)keySpec;
            this.keyId = l;
        }

        @Override
        long value() {
            return this.keyId;
        }

        @Override
        public BigInteger getModulus() {
            return this.keySpec.getModulus();
        }

        @Override
        public BigInteger getPrivateExponent() {
            return this.keySpec.getPrivateExponent();
        }

        private static native long nativeInit(byte[] var0, byte[] var1);
    }
}

