/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public abstract class NativeDigest
extends MessageDigestSpi
implements Cloneable {
    private static final int MECH_MD5 = 1;
    private static final int MECH_SHA1 = 2;
    private static final int MECH_SHA256 = 3;
    private static final int MECH_SHA224 = 4;
    private static final int MECH_SHA384 = 5;
    private static final int MECH_SHA512 = 6;
    private final int digestLen;
    private final int mech;
    private DigestContextRef pCtxt = null;

    NativeDigest(int n, int n2) {
        this.digestLen = n2;
        this.mech = n;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLen;
    }

    @Override
    protected synchronized void engineReset() {
        if (this.pCtxt != null) {
            this.pCtxt.dispose(true);
            this.pCtxt = null;
        }
    }

    @Override
    protected synchronized byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLen];
        try {
            int n = this.engineDigest(byArray, 0, this.digestLen);
            if (n != this.digestLen) {
                throw new UcryptoException("Digest length mismatch");
            }
            return byArray;
        }
        catch (DigestException digestException) {
            throw new UcryptoException("Internal error", digestException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLen) {
            throw new DigestException("Output buffer must be at least " + this.digestLen + " bytes long");
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.pCtxt == null) {
            this.pCtxt = new DigestContextRef(this, NativeDigest.nativeInit(this.mech), this.mech);
        }
        try {
            int n3 = NativeDigest.nativeDigest(this.mech, this.pCtxt.id, byArray, n, this.digestLen);
            if (n3 != 0) {
                throw new DigestException("Internal error: " + n3);
            }
        }
        finally {
            this.pCtxt.dispose(false);
            this.pCtxt = null;
        }
        return this.digestLen;
    }

    @Override
    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.pCtxt == null) {
            this.pCtxt = new DigestContextRef(this, NativeDigest.nativeInit(this.mech), this.mech);
        }
        NativeDigest.nativeUpdate(this.mech, this.pCtxt.id, byArray, n, n2);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        NativeDigest nativeDigest = (NativeDigest)super.clone();
        if (this.pCtxt != null) {
            nativeDigest.pCtxt = new DigestContextRef(this, NativeDigest.nativeClone(this.mech, this.pCtxt.id), this.mech);
        }
        return nativeDigest;
    }

    protected static native long nativeInit(int var0);

    protected static native int nativeUpdate(int var0, long var1, byte[] var3, int var4, int var5);

    protected static native int nativeDigest(int var0, long var1, byte[] var3, int var4, int var5);

    protected static native long nativeClone(int var0, long var1);

    private static native void nativeFree(int var0, long var1);

    public static final class SHA512
    extends NativeDigest {
        public SHA512() {
            super(6, 64);
        }
    }

    public static final class SHA384
    extends NativeDigest {
        public SHA384() {
            super(5, 48);
        }
    }

    public static final class SHA256
    extends NativeDigest {
        public SHA256() {
            super(3, 32);
        }
    }

    public static final class SHA1
    extends NativeDigest {
        public SHA1() {
            super(2, 20);
        }
    }

    public static final class MD5
    extends NativeDigest {
        public MD5() {
            super(1, 16);
        }
    }

    private static class DigestContextRef
    extends PhantomReference<NativeDigest>
    implements Comparable<DigestContextRef> {
        private static ReferenceQueue<NativeDigest> refQueue = new ReferenceQueue();
        private static Set<DigestContextRef> refList = new ConcurrentSkipListSet<DigestContextRef>();
        private final long id;
        private final int mech;

        private static void drainRefQueueBounded() {
            DigestContextRef digestContextRef;
            while ((digestContextRef = (DigestContextRef)refQueue.poll()) != null) {
                digestContextRef.dispose(true);
            }
        }

        DigestContextRef(NativeDigest nativeDigest, long l, int n) {
            super(nativeDigest, refQueue);
            this.id = l;
            this.mech = n;
            refList.add(this);
            UcryptoProvider.debug("Resource: track Digest Ctxt " + this.id);
            DigestContextRef.drainRefQueueBounded();
        }

        @Override
        public int compareTo(DigestContextRef digestContextRef) {
            if (this.id == digestContextRef.id) {
                return 0;
            }
            return this.id < digestContextRef.id ? -1 : 1;
        }

        void dispose(boolean bl) {
            refList.remove(this);
            try {
                if (bl) {
                    UcryptoProvider.debug("Resource: free Digest Ctxt " + this.id);
                    NativeDigest.nativeFree(this.mech, this.id);
                } else {
                    UcryptoProvider.debug("Resource: stop tracking Digest Ctxt " + this.id);
                }
            }
            finally {
                this.clear();
            }
        }
    }
}

