/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.NativeCipher;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class NativeCipherWithJavaPadding
extends CipherSpi {
    private final NativeCipher nc;
    private final Padding padding;
    private final int blockSize;
    private int lastBlockLen = 0;

    NativeCipherWithJavaPadding(NativeCipher nativeCipher, String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.nc = nativeCipher;
        this.blockSize = nativeCipher.engineGetBlockSize();
        if (!string.toUpperCase().equals("PKCS5PADDING")) {
            throw new NoSuchAlgorithmException("Unsupported padding scheme: " + string);
        }
        this.padding = new PKCS5Padding(this.blockSize);
    }

    void reset() {
        this.padding.clear();
        this.lastBlockLen = 0;
    }

    @Override
    protected synchronized void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.nc.engineSetMode(string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + string);
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected synchronized int engineGetOutputSize(int n) {
        int n2 = this.nc.engineGetOutputSize(n);
        n2 = this.nc.encrypt ? (n2 += this.padding.getPadLen(n2)) : (n2 += this.padding.getBufferedLength());
        return n2;
    }

    @Override
    protected synchronized byte[] engineGetIV() {
        return this.nc.engineGetIV();
    }

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        return this.nc.engineGetParameters();
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.nc.engineGetKeySize(key);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.reset();
        this.nc.engineInit(n, key, secureRandom);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset();
        this.nc.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset();
        this.nc.engineInit(n, key, algorithmParameters, secureRandom);
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.nc.encrypt) {
            this.lastBlockLen += n2;
            this.lastBlockLen &= this.blockSize - 1;
            return this.nc.engineUpdate(byArray, n, n2);
        }
        return this.padding.bufferBytes(this.nc.engineUpdate(byArray, n, n2));
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.nc.encrypt) {
            this.lastBlockLen += n2;
            this.lastBlockLen &= this.blockSize - 1;
            return this.nc.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        byte[] byArray3 = this.padding.bufferBytes(this.nc.engineUpdate(byArray, n, n2));
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            return byArray3.length;
        }
        return 0;
    }

    @Override
    protected synchronized byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3 = this.engineGetOutputSize(n2);
        byte[] byArray2 = new byte[n3];
        try {
            int n4 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (n4 != byArray2.length) {
                byArray2 = Arrays.copyOf(byArray2, n4);
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error");
        }
        finally {
            this.reset();
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.engineGetOutputSize(n2);
        if (byArray2.length - n3 < n4) {
            throw new ShortBufferException();
        }
        try {
            int n5;
            if (this.nc.encrypt) {
                int n6 = this.nc.engineUpdate(byArray, n, n2, byArray2, n3);
                this.lastBlockLen += n2;
                this.lastBlockLen &= this.blockSize - 1;
                byte[] byArray3 = this.padding.getPaddingBytes(this.lastBlockLen);
                n6 += this.nc.engineDoFinal(byArray3, 0, byArray3.length, byArray2, n3 + n6);
                int n7 = n6;
                return n7;
            }
            byte[] byArray4 = this.nc.engineDoFinal(byArray, n, n2);
            int n8 = n5 = this.padding.unpad(byArray4, byArray2, n3);
            return n8;
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected synchronized byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new UcryptoException("Internal Error", badPaddingException);
        }
        return byArray;
    }

    @Override
    protected synchronized Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw (InvalidKeyException)new InvalidKeyException().initCause(exception);
        }
        return NativeCipher.constructKey(n, byArray2, string);
    }

    public static final class AesCfb128PKCS5
    extends NativeCipherWithJavaPadding {
        public AesCfb128PKCS5() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new NativeCipher.AesCfb128NoPadding(), "PKCS5Padding");
        }
    }

    public static final class AesCbcPKCS5
    extends NativeCipherWithJavaPadding {
        public AesCbcPKCS5() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new NativeCipher.AesCbcNoPadding(), "PKCS5Padding");
        }
    }

    public static final class AesEcbPKCS5
    extends NativeCipherWithJavaPadding {
        public AesEcbPKCS5() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new NativeCipher.AesEcbNoPadding(), "PKCS5Padding");
        }
    }

    private static class PKCS5Padding
    implements Padding {
        private final int blockSize;
        private ByteBuffer trailingBytes = null;

        PKCS5Padding(int n) throws NoSuchPaddingException {
            if (n == 0) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
            }
            this.blockSize = n;
        }

        @Override
        public int getPadLen(int n) {
            return this.blockSize - (n & this.blockSize - 1);
        }

        @Override
        public byte[] getPaddingBytes(int n) {
            byte by = (byte)this.getPadLen(n);
            byte[] byArray = new byte[by];
            Arrays.fill(byArray, by);
            return byArray;
        }

        @Override
        public byte[] bufferBytes(byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            byte[] byArray2 = null;
            if (this.trailingBytes == null) {
                this.trailingBytes = ByteBuffer.wrap(new byte[this.blockSize]);
            }
            int n = this.trailingBytes.position();
            if (byArray.length > this.trailingBytes.remaining()) {
                int n2 = byArray.length + n;
                int n3 = n2 % this.blockSize;
                if (n3 == 0) {
                    n3 = this.blockSize;
                }
                if (n == 0) {
                    byArray2 = Arrays.copyOf(byArray, n2 - n3);
                } else {
                    byArray2 = Arrays.copyOf(this.trailingBytes.array(), n2 - n3);
                    if (byArray2.length != n) {
                        System.arraycopy(byArray, 0, byArray2, n, byArray2.length - n);
                    }
                }
                this.trailingBytes.clear();
                this.trailingBytes.put(byArray, byArray.length - n3, n3);
            } else {
                this.trailingBytes.put(byArray);
            }
            return byArray2;
        }

        @Override
        public int getBufferedLength() {
            if (this.trailingBytes != null) {
                return this.trailingBytes.position();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int unpad(byte[] byArray, byte[] byArray2, int n) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
            int n2;
            int n3;
            byte by;
            int n4 = this.trailingBytes == null ? 0 : this.trailingBytes.position();
            int n5 = n4 + byArray.length;
            if (n5 < 1 || n5 % this.blockSize != 0) {
                UcryptoProvider.debug("PKCS5Padding: unpad, buffered " + n4 + " bytes, last block " + byArray.length + " bytes");
                throw new IllegalBlockSizeException("Input length must be multiples of " + this.blockSize);
            }
            if (byArray.length == 0) {
                if (n4 != 0) {
                    byArray = Arrays.copyOf(this.trailingBytes.array(), n4);
                    this.trailingBytes.clear();
                    n4 = 0;
                } else {
                    throw new BadPaddingException("No pad bytes found!");
                }
            }
            if ((by = byArray[byArray.length - 1]) < 1 || by > this.blockSize) {
                UcryptoProvider.debug("PKCS5Padding: unpad, lastData: " + Arrays.toString(byArray));
                UcryptoProvider.debug("PKCS5Padding: unpad, padValue=" + by);
                throw new BadPaddingException("Invalid pad value!");
            }
            for (n3 = n2 = byArray.length - by; n3 < byArray.length; ++n3) {
                if (byArray[n3] == by) continue;
                UcryptoProvider.debug("PKCS5Padding: unpad, lastData: " + Arrays.toString(byArray));
                UcryptoProvider.debug("PKCS5Padding: unpad, padValue=" + by);
                throw new BadPaddingException("Invalid padding bytes!");
            }
            n3 = n5 - by;
            if (byArray2.length - n < n3) {
                throw new ShortBufferException("Output buffer too small, need " + n3 + ", got " + (byArray2.length - n));
            }
            try {
                if (n4 != 0) {
                    this.trailingBytes.rewind();
                    if (n4 < n3) {
                        this.trailingBytes.get(byArray2, n, n4);
                        n += n4;
                    } else {
                        this.trailingBytes.get(byArray2, n, n3);
                        int n6 = n3;
                        return n6;
                    }
                }
                if (byArray.length > by) {
                    System.arraycopy(byArray, 0, byArray2, n, byArray.length - by);
                }
                int n7 = n3;
                return n7;
            }
            finally {
                this.clear();
            }
        }

        @Override
        public void clear() {
            if (this.trailingBytes != null) {
                this.trailingBytes.clear();
            }
        }
    }

    private static interface Padding {
        public int getPadLen(int var1);

        public byte[] getPaddingBytes(int var1);

        public byte[] bufferBytes(byte[] var1);

        public int getBufferedLength();

        public int unpad(byte[] var1, byte[] var2, int var3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException;

        public void clear();
    }
}

