/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.CipherContextRef;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.jca.JCAUtil;

class NativeCipher
extends CipherSpi {
    public static final int AES_BLOCK_SIZE = 16;
    public static final String AES_KEY_ALGO = "AES";
    protected final UcryptoMech mech;
    protected String keyAlgo;
    protected int blockSize;
    protected int fixedKeySize;
    protected CipherContextRef pCtxt = null;
    protected byte[] keyValue = null;
    protected byte[] iv = null;
    protected boolean initialized = false;
    protected boolean encrypt = true;
    protected int bytesBuffered = 0;

    private static final PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No provider found for " + string + " KeyFactory");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct public key", invalidKeySpecException);
        }
        return publicKey;
    }

    private static final PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No provider found for " + string + " KeyFactory");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct private key", invalidKeySpecException);
        }
        return privateKey;
    }

    private static final SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    static final Key constructKey(int n, byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key = null;
        switch (n) {
            case 3: {
                key = NativeCipher.constructSecretKey(byArray, string);
                break;
            }
            case 2: {
                key = NativeCipher.constructPrivateKey(byArray, string);
                break;
            }
            case 1: {
                key = NativeCipher.constructPublicKey(byArray, string);
            }
        }
        return key;
    }

    NativeCipher(UcryptoMech ucryptoMech, int n) throws NoSuchAlgorithmException {
        this.mech = ucryptoMech;
        this.blockSize = 16;
        this.keyAlgo = AES_KEY_ALGO;
        this.fixedKeySize = n;
    }

    NativeCipher(UcryptoMech ucryptoMech) throws NoSuchAlgorithmException {
        this(ucryptoMech, -1);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + string);
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected synchronized int engineGetOutputSize(int n) {
        return this.getOutputSizeByOperation(n, true);
    }

    @Override
    protected synchronized byte[] engineGetIV() {
        return this.iv != null ? (byte[])this.iv.clone() : null;
    }

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.iv != null) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])this.iv.clone());
                algorithmParameters = AlgorithmParameters.getInstance(this.keyAlgo);
                algorithmParameters.init(ivParameterSpec);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UcryptoException("Could not encode parameters", generalSecurityException);
        }
        return algorithmParameters;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.checkKey(key) * 8;
    }

    @Override
    protected synchronized void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkKey(key);
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
        }
        boolean bl = n == 1 || n == 3;
        byte[] byArray = null;
        if (this.mech == UcryptoMech.CRYPTO_AES_ECB) {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("No Parameters for ECB mode");
            }
        } else if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("IvParameterSpec required");
            }
            byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
            if (byArray.length != this.blockSize) {
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
            }
        } else if (this.encrypt) {
            byArray = new byte[this.blockSize];
            if (secureRandom == null) {
                secureRandom = JCAUtil.getSecureRandom();
            }
            secureRandom.nextBytes(byArray);
        } else {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        this.init(bl, (byte[])key.getEncoded().clone(), byArray);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
            }
        }
        this.engineInit(n, key, ivParameterSpec, secureRandom);
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.getOutputSizeByOperation(n2, false)];
        int n3 = this.update(byArray, n, n2, byArray2, 0);
        if (n3 == 0) {
            return null;
        }
        if (byArray2.length != n3) {
            byArray2 = Arrays.copyOf(byArray2, n3);
        }
        return byArray2;
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = this.getOutputSizeByOperation(n2, false);
        if (byArray2.length - n3 < n4) {
            throw new ShortBufferException("min " + n4 + "-byte buffer needed");
        }
        return this.update(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] byArray, int n, int n2) throws IllegalStateException {
        throw new IllegalStateException("No AAD can be supplied");
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) throws IllegalStateException {
        throw new IllegalStateException("No AAD can be supplied");
    }

    @Override
    protected synchronized byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.getOutputSizeByOperation(n2, true)];
        try {
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (byArray2.length != n3) {
                byArray2 = Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error", shortBufferException);
        }
    }

    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        int n5 = this.getOutputSizeByOperation(n2, true);
        if (byArray2.length - n3 < n5) {
            throw new ShortBufferException("min " + n5 + "-byte buffer needed");
        }
        if (n2 > 0) {
            n4 = this.update(byArray, n, n2, byArray2, n3);
            n3 += n4;
        }
        return n4 += this.doFinal(byArray2, n3);
    }

    @Override
    protected synchronized byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new UcryptoException("Internal Error", badPaddingException);
        }
        return byArray;
    }

    @Override
    protected synchronized Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        Object var5_4 = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw (InvalidKeyException)new InvalidKeyException().initCause(exception);
        }
        return NativeCipher.constructKey(n, byArray2, string);
    }

    final int checkKey(Key key) throws InvalidKeyException {
        if (key == null || key.getEncoded() == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!this.keyAlgo.equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Key algorithm must be " + this.keyAlgo);
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Key format must be RAW");
        }
        int n = key.getEncoded().length;
        if (this.fixedKeySize == -1) {
            if (n != 16 && n != 24 && n != 32) {
                throw new InvalidKeyException("Key size is not valid");
            }
        } else if (n != this.fixedKeySize) {
            throw new InvalidKeyException("Only " + this.fixedKeySize + "-byte keys are accepted");
        }
        return n;
    }

    protected void reset(boolean bl) {
        this.initialized = false;
        this.bytesBuffered = 0;
        if (this.pCtxt != null) {
            this.pCtxt.dispose(bl);
            this.pCtxt = null;
        }
    }

    protected static native long nativeInit(int var0, boolean var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private static native int nativeUpdate(long var0, boolean var2, byte[] var3, int var4, int var5, byte[] var6, int var7);

    static native int nativeFinal(long var0, boolean var2, byte[] var3, int var4);

    protected void ensureInitialized() {
        if (!this.initialized) {
            this.init(this.encrypt, this.keyValue, this.iv);
            if (!this.initialized) {
                throw new UcryptoException("Cannot initialize Cipher");
            }
        }
    }

    protected int getOutputSizeByOperation(int n, boolean bl) {
        if (n <= 0) {
            n = 0;
        }
        if (!bl && n == 0) {
            return 0;
        }
        return n + this.bytesBuffered;
    }

    protected void init(boolean bl, byte[] byArray, byte[] byArray2) {
        this.reset(true);
        this.encrypt = bl;
        this.keyValue = byArray;
        this.iv = byArray2;
        long l = NativeCipher.nativeInit(this.mech.value(), bl, this.keyValue, this.iv, 0, null);
        boolean bl2 = this.initialized = l != 0L;
        if (!this.initialized) {
            throw new UcryptoException("Cannot initialize Cipher");
        }
        this.pCtxt = new CipherContextRef(this, l, bl);
    }

    private int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.ensureInitialized();
        if (n2 <= 0) {
            return 0;
        }
        int n4 = NativeCipher.nativeUpdate(this.pCtxt.id, this.encrypt, byArray, n, n2, byArray2, n3);
        if (n4 < 0) {
            this.reset(false);
            throw new UcryptoException(-n4);
        }
        this.bytesBuffered += n2 - n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFinal(byte[] byArray, int n) throws IllegalBlockSizeException, BadPaddingException {
        try {
            this.ensureInitialized();
            int n2 = NativeCipher.nativeFinal(this.pCtxt.id, this.encrypt, byArray, n);
            if (n2 < 0) {
                String string = UcryptoException.getErrorMessage(-n2);
                if (string.endsWith("_LEN_RANGE")) {
                    throw new IllegalBlockSizeException(string);
                }
                if (string.endsWith("_DATA_INVALID")) {
                    throw new BadPaddingException(string);
                }
                throw new UcryptoException(-n2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.reset(false);
        }
    }

    public static final class Aes256CbcNoPadding
    extends NativeCipher {
        public Aes256CbcNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CBC, 32);
        }
    }

    public static final class Aes256EcbNoPadding
    extends NativeCipher {
        public Aes256EcbNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_ECB, 32);
        }
    }

    public static final class Aes192CbcNoPadding
    extends NativeCipher {
        public Aes192CbcNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CBC, 24);
        }
    }

    public static final class Aes192EcbNoPadding
    extends NativeCipher {
        public Aes192EcbNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_ECB, 24);
        }
    }

    public static final class Aes128CbcNoPadding
    extends NativeCipher {
        public Aes128CbcNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CBC, 16);
        }
    }

    public static final class Aes128EcbNoPadding
    extends NativeCipher {
        public Aes128EcbNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_ECB, 16);
        }
    }

    public static final class AesCfb128NoPadding
    extends NativeCipher {
        public AesCfb128NoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CFB128);
        }
    }

    public static final class AesCtrNoPadding
    extends NativeCipher {
        public AesCtrNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CTR);
        }
    }

    public static final class AesCbcNoPadding
    extends NativeCipher {
        public AesCbcNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CBC);
        }
    }

    public static final class AesEcbNoPadding
    extends NativeCipher {
        public AesEcbNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_ECB);
        }
    }
}

