/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.ConfigException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.PropertyExpander;

final class Config {
    private Reader reader;
    private StreamTokenizer st;
    private Set<String> parsedKeywords;
    private Set<String> disabledServices;

    Config(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(Config.expand(string));
        this.reader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.parsedKeywords = new HashSet<String>();
        this.st = new StreamTokenizer(this.reader);
        this.setupTokenizer();
        this.parse();
    }

    String[] getDisabledServices() {
        if (this.disabledServices != null) {
            return this.disabledServices.toArray(new String[this.disabledServices.size()]);
        }
        return new String[0];
    }

    private static String expand(String string) throws IOException {
        try {
            return PropertyExpander.expand(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void setupTokenizer() {
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 57);
        this.st.wordChars(58, 58);
        this.st.wordChars(46, 46);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.wordChars(47, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(36, 36);
        this.st.wordChars(123, 123);
        this.st.wordChars(125, 125);
        this.st.wordChars(42, 42);
        this.st.wordChars(43, 43);
        this.st.wordChars(126, 126);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(35);
        this.st.eolIsSignificant(true);
        this.st.quoteChar(34);
    }

    private ConfigException excToken(String string) {
        return new ConfigException(string + " " + this.st);
    }

    private ConfigException excLine(String string) {
        return new ConfigException(string + ", line " + this.st.lineno());
    }

    private void parse() throws IOException {
        int n;
        while ((n = this.nextToken()) != -1) {
            if (n == 10) continue;
            if (n != -3) {
                throw this.excToken("Unexpected token:");
            }
            String string = this.st.sval;
            if (!string.equals("disabledServices")) {
                throw new ConfigException("Unknown keyword '" + string + "', line " + this.st.lineno());
            }
            this.parseDisabledServices(string);
            this.parsedKeywords.add(string);
        }
        this.reader.close();
        this.reader = null;
        this.st = null;
        this.parsedKeywords = null;
    }

    private int nextToken() throws IOException {
        int n = this.st.nextToken();
        return n;
    }

    private void parseEquals() throws IOException {
        int n = this.nextToken();
        if (n != 61) {
            throw this.excToken("Expected '=', read");
        }
    }

    private void parseOpenBraces() throws IOException {
        int n;
        while ((n = this.nextToken()) == 10) {
        }
        if (n == -3 && this.st.sval.equals("{")) {
            return;
        }
        throw this.excToken("Expected '{', read");
    }

    private boolean isCloseBraces(int n) {
        return n == -3 && this.st.sval.equals("}");
    }

    private void checkDup(String string) throws IOException {
        if (this.parsedKeywords.contains(string)) {
            throw this.excLine(string + " must only be specified once");
        }
    }

    private void parseDisabledServices(String string) throws IOException {
        int n;
        this.checkDup(string);
        this.disabledServices = new HashSet<String>();
        this.parseEquals();
        this.parseOpenBraces();
        while (!this.isCloseBraces(n = this.nextToken())) {
            if (n == 10) continue;
            if (n != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            this.disabledServices.add(this.st.sval);
        }
    }
}

