/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.eons.BodyBlock;
import oracle.eons.BodyElement;
import oracle.eons.BodySegment;
import oracle.eons.ONSFactory;
import oracle.supercluster.impl.common.CommonFactoryImpl;

class TierState {
    static final String S_NAME = "NAME";
    static final String S_TYPE = "TYPE";
    private static Logger s_logger = Logger.getLogger("oracle.supercluster");
    private String m_tierID;
    private List<BodyBlock> m_stateList;

    TierState(String tierID, List<BodyBlock> state) {
        this.m_tierID = tierID;
        this.m_stateList = new LinkedList<BodyBlock>(state);
    }

    String getTierID() {
        return this.m_tierID;
    }

    boolean equals(TierState tierState) {
        return this.m_tierID.equalsIgnoreCase(tierState.getTierID());
    }

    BodyBlock getState() {
        return TierState.getStateHelper(this.m_tierID, this.m_stateList);
    }

    static BodyBlock getStateHelper(String prefix, List<BodyBlock> bbList) {
        int suffix = 1;
        BodyBlock bblk = ONSFactory.createBodyBlock();
        for (BodyBlock bb : bbList) {
            List bsList = bb.getSegments();
            if (bsList.size() == 0) continue;
            BodySegment rootseg = ONSFactory.createBodySegment((String)(bbList.size() > 1 ? TierState.generateTierID(prefix, suffix++) : prefix));
            for (BodySegment bseg : bsList) {
                CommonFactoryImpl.copyRecurse(bseg, rootseg);
            }
            bblk.addSegment(rootseg);
        }
        return bblk;
    }

    List<BodyBlock> getState(BodyBlock bblock) {
        LinkedList<BodyBlock> bbList = new LinkedList<BodyBlock>();
        for (BodySegment bs1 : bblock.getSegments()) {
            block1: for (BodyBlock bb : this.m_stateList) {
                for (BodySegment bs2 : bb.getSegments()) {
                    if (!this.matchFound(bs1, bs2)) continue;
                    bbList.add(bb);
                    continue block1;
                }
            }
        }
        return bbList;
    }

    private boolean matchFound(BodySegment srcBS, BodySegment tgtBS) {
        boolean match = true;
        for (BodyElement be1 : srcBS.getElements()) {
            BodyElement be2 = tgtBS.getElement(be1.getName());
            if (be2 == null) continue;
            s_logger.info("be1=" + be1.toString() + " be2=" + be2.toString());
            match &= be1.getValue().equalsIgnoreCase(be2.getValue());
        }
        s_logger.info("match=" + match);
        return match;
    }

    void put(BodyBlock bodyBlock) {
        int index = this.getBodyBlockIndex(bodyBlock);
        if (index >= 0) {
            this.m_stateList.set(index, bodyBlock);
        } else {
            this.m_stateList.add(bodyBlock);
        }
    }

    void remove(BodyBlock bodyBlock) {
        int index = this.getBodyBlockIndex(bodyBlock);
        s_logger.info("index=" + index);
        if (index >= 0) {
            this.m_stateList.remove(index);
        }
    }

    int getBodyBlockIndex(BodyBlock bblk) {
        BodyElement name1 = null;
        BodyElement type1 = null;
        BodyElement name2 = null;
        BodyElement type2 = null;
        for (BodySegment bseg : bblk.getSegments()) {
            if (name1 != null || type1 != null) continue;
            name1 = bseg.getElement(S_NAME);
            type1 = bseg.getElement(S_TYPE);
        }
        for (int index = 0; index < this.m_stateList.size(); ++index) {
            BodyBlock cbb = this.m_stateList.get(index);
            for (BodySegment bseg : cbb.getSegments()) {
                if (name2 == null && type2 == null) {
                    name2 = bseg.getElement(S_NAME);
                    type2 = bseg.getElement(S_TYPE);
                }
                if ((name2 == null || type2 == null || name1 == null || type1 == null || !name2.getValue().equalsIgnoreCase(name1.getValue()) || !type1.getValue().equalsIgnoreCase(type1.getValue())) && (type1 != null || type2 != null || name1 == null || name2 == null || !name2.getValue().equalsIgnoreCase(name1.getValue()))) continue;
                return index;
            }
        }
        return -1;
    }

    static String generateTierID(String prefix, int suffix) {
        return prefix + "_" + suffix;
    }

    static String getTierID(BodySegment bodySegment) {
        String tierID = bodySegment.getName();
        int index = tierID.lastIndexOf("_");
        if (index > 0 && index < tierID.length() - 1) {
            try {
                String suffix = tierID.substring(index + 1);
                s_logger.info("suffix=" + suffix);
                Integer isfx = Integer.valueOf(suffix);
                tierID = tierID.substring(0, index);
            }
            catch (NumberFormatException e) {
                s_logger.info("IGNORED:" + e.getMessage());
            }
        }
        return tierID;
    }
}

