/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.eons.BodyBlock;
import oracle.eons.BodyElement;
import oracle.eons.BodySegment;
import oracle.eons.MessageNotification;
import oracle.eons.ONSFactory;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.common.CommonFactoryImpl;
import oracle.supercluster.impl.common.TierState;

class StateImpl {
    private static final String S_ROOT = "ROOT";
    private static Logger s_logger = Logger.getLogger("oracle.supercluster");
    private Version m_version;
    private List<TierState> m_tierStateList;

    protected StateImpl(Version version) {
        this.m_version = version;
        this.m_tierStateList = new LinkedList<TierState>();
    }

    byte[] getState(String tierID) {
        TierState tierState = this.getTierState(tierID);
        if (tierState != null) {
            return tierState.getState().generateBody();
        }
        s_logger.warning("Tier=" + tierID + " is not part of the current topology, returning null state.");
        return null;
    }

    byte[] getState() {
        ArrayList<BodyBlock> currentList = new ArrayList<BodyBlock>(this.m_tierStateList.size());
        for (TierState ts : this.m_tierStateList) {
            currentList.add(ts.getState());
        }
        BodyBlock bb = TierState.getStateHelper(S_ROOT, currentList);
        return bb.generateBody();
    }

    byte[] getState(MessageNotification notification) {
        BodyBlock bblock = notification.getBodyBlock();
        LinkedList<BodyBlock> bbList = new LinkedList<BodyBlock>();
        for (TierState ts : this.m_tierStateList) {
            for (BodyBlock bb : ts.getState(bblock)) {
                bbList.add(bb);
            }
        }
        String prefix = notification.getSourceAddr().getTierId();
        if (prefix == null) {
            prefix = notification.getType();
        }
        s_logger.info("prefix=" + prefix + " num matching comps = " + bbList.size());
        bblock = TierState.getStateHelper(prefix, bbList);
        return bblock.generateBody();
    }

    void process(MessageNotification notification) {
        String tierID = notification.getSourceAddr().getTierId();
        BodyBlock bblock = notification.getBodyBlock();
        BodyElement stateOp = null;
        boolean secondPass = false;
        String relVersion = this.m_version.getMajorVersion() + "." + this.m_version.getMinorVersion();
        do {
            BodySegment bseg;
            Iterator iterator = bblock.getSegments().iterator();
            while (iterator.hasNext() && (!(bseg = (BodySegment)iterator.next()).getName().startsWith(relVersion) && !secondPass || (stateOp = bseg.getElement("SC_STATE")) == null)) {
            }
            if (stateOp != null || secondPass) break;
            secondPass = true;
            s_logger.info("secondPass=" + secondPass);
        } while (secondPass);
        if (stateOp == null) {
            s_logger.info("No state impact due to notification:" + notification.toString());
            return;
        }
        String opID = stateOp.getValue();
        TierState tierState = this.getTierState(tierID);
        if ("REMOVE".equalsIgnoreCase(opID)) {
            if (tierState != null) {
                tierState.remove(bblock);
                tierState = null;
            }
        } else if ("SAVE".equalsIgnoreCase(opID)) {
            if (tierState != null) {
                tierState.put(bblock);
            } else {
                ArrayList<BodyBlock> bbList = new ArrayList<BodyBlock>(1);
                bbList.add(bblock);
                tierState = new TierState(tierID, bbList);
                this.m_tierStateList.add(tierState);
            }
        } else {
            s_logger.warning("Unknown state operation " + stateOp.toString() + " found in notification:" + notification.toString());
            return;
        }
    }

    void setState(String tierID, BodyBlock bodyBlock) {
        List<BodyBlock> bbList = this.getBodyBlocks(tierID, bodyBlock);
        TierState tierState = new TierState(tierID, bbList);
        int index = this.getIndexOf(tierID);
        s_logger.info("index = " + index);
        if (index >= 0) {
            this.m_tierStateList.set(index, tierState);
        } else {
            this.m_tierStateList.add(tierState);
        }
    }

    void setInitialState(BodyBlock bodyBlock) {
        List<BodyBlock> bbList = this.getBodyBlocks(S_ROOT, bodyBlock);
        if (bbList.size() == 0) {
            s_logger.severe("Initial State payload doesn't follow payload format, ignoring:" + bodyBlock);
            return;
        }
        this.clearState();
        for (BodyBlock bblk : bbList) {
            for (BodySegment bs : bblk.getSegments()) {
                String tierID = TierState.getTierID(bs);
                List<BodyBlock> bbList2 = this.getBodyBlocks(tierID, bblk);
                this.m_tierStateList.add(new TierState(tierID, bbList2));
            }
        }
    }

    void clearState(String tierID) {
        int index = this.getIndexOf(tierID);
        if (index >= 0) {
            this.m_tierStateList.remove(index);
        }
    }

    void clearState() {
        this.m_tierStateList.clear();
    }

    private TierState getTierState(String tierID) {
        for (TierState ts : this.m_tierStateList) {
            if (!ts.getTierID().equalsIgnoreCase(tierID)) continue;
            return ts;
        }
        return null;
    }

    private List<BodyBlock> getBodyBlocks(String tierID, BodyBlock bodyBlk) {
        LinkedList<BodyBlock> bbList = new LinkedList<BodyBlock>();
        for (BodySegment tseg : bodyBlk.getSegments()) {
            String mytid = TierState.getTierID(tseg);
            if (!mytid.equalsIgnoreCase(tierID)) continue;
            BodyBlock bblk = ONSFactory.createBodyBlock();
            for (BodySegment cseg : tseg.getSegments()) {
                BodySegment pSeg = ONSFactory.createBodySegment((String)cseg.getName());
                for (BodyElement be : cseg.getElements()) {
                    pSeg.addNewElement(be.getName(), be.getValue());
                }
                for (BodySegment bs2 : cseg.getSegments()) {
                    CommonFactoryImpl.copyRecurse(bs2, pSeg);
                }
                bblk.addSegment(pSeg);
            }
            if (bblk.getSegments().size() <= 0) continue;
            bbList.add(bblk);
        }
        return bbList;
    }

    private int getIndexOf(String tierID) {
        for (int index = 0; index < this.m_tierStateList.size(); ++index) {
            TierState ts = this.m_tierStateList.get(index);
            if (!ts.getTierID().equalsIgnoreCase(tierID)) continue;
            return index;
        }
        return -1;
    }
}

