/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.eons.BaseNotification;
import oracle.eons.LeaveGroupNotification;
import oracle.eons.LogicalAddress;
import oracle.eons.MembershipDeltaNotification;
import oracle.eons.MessageNotification;
import oracle.eons.ONS;
import oracle.eons.ONSFactory;
import oracle.eons.ProxyListener;
import oracle.eons.Publisher;
import oracle.eons.StateGetNotification;
import oracle.eons.StateSetNotification;
import oracle.eons.Subscriber;
import oracle.eons.TierDiscoveryInfo;
import oracle.eons.UserNotification;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.supercluster.common.SCEventHandler;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCRepresentative;
import oracle.supercluster.common.SCTier;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.common.StateImpl;
import oracle.supercluster.resources.SclsMsgID;

public class SCRepresentativeImpl
implements SCRepresentative {
    static final int STATETIMEOUT_DEFAULT = 30000;
    static final String SUBSCRIPTION_PROPNAME = "subscription";
    static final String COMPONENT_PROPNAME = "component";
    static final String TIER_ID = "tierid";
    static final String INTEREST_PROPNAME = "INTEREST";
    static final String SC_HTIER_INTEREST_VALUE = "SCClient";
    static final String INTEREST_TYPE = "SCInterest";
    private static final String INTEREST_VALUE = "SCRepresentative";
    private static SCRepresentativeImpl s_instance;
    private int m_repCount;
    private ONS.TierName m_tierName;
    private List<String> m_preferredList;
    private List<String> m_verificationList;
    private int m_verificationTimeout;
    private String m_subscription;
    private String m_interest;
    private String m_component;
    private StateImpl m_stateImpl;
    private LinkedHashSet<LogicalAddress> m_memberList;
    private ONS m_ons;
    private int m_proxyListenerPort;
    private ProxyListener m_proxyListener;
    private MessageProcessor m_messageProcessor;
    private Thread m_messageProcessorThread;
    private Version m_version;
    private static Logger s_logger;

    private SCRepresentativeImpl(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts, List<String> verificationList, int verificationTimeout, String subscription, String interest, String component) throws SCRException {
        this.m_proxyListenerPort = port;
        this.m_tierName = tierName;
        try {
            this.m_ons = ONSFactory.createONSRuntime((TierDiscoveryInfo)htierInfo, (ONS.TierName)tierName);
            this.m_proxyListener = this.m_ons.createProxyListener(this.m_proxyListenerPort);
            this.m_repCount = repCount;
            this.m_preferredList = preferredHosts != null ? new ArrayList<String>(preferredHosts) : null;
            this.m_ons.enableAsBridge(vtierInfo, repCount, this.m_preferredList);
            this.m_proxyListener.start();
            if (verificationList != null) {
                this.m_verificationList = new ArrayList<String>(verificationList.size());
                for (String host : verificationList) {
                    this.m_verificationList.add(host);
                }
            } else {
                this.m_verificationList = null;
            }
            this.m_verificationTimeout = verificationTimeout;
            this.m_subscription = subscription;
            this.m_interest = interest;
            this.m_component = component;
            this.m_version = version;
            this.m_stateImpl = new StateImpl(version);
            this.m_memberList = new LinkedHashSet();
            this.m_messageProcessor = new MessageProcessor();
            this.m_messageProcessorThread = new Thread((Runnable)this.m_messageProcessor, INTEREST_VALUE);
            this.m_messageProcessorThread.setDaemon(true);
            this.m_messageProcessorThread.start();
        }
        catch (IOException e) {
            String message = MessageBundle.getMessage((MessageKey)SclsMsgID.SCREP_CREATE_FAILED, (boolean)true, (Object[])new Object[]{tierName.name(), String.valueOf(port) + " " + htierInfo.toString() + " " + vtierInfo.toString()});
            s_logger.severe(message);
            s_logger.severe(e.getMessage());
            throw new SCRException(message, e);
        }
    }

    static synchronized SCRepresentativeImpl createInstance(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, null);
    }

    static synchronized SCRepresentativeImpl createInstance(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts, null, Integer.parseInt(System.getProperty("VERIFICATION_TIMEOUT", String.valueOf(60))), System.getProperty(SUBSCRIPTION_PROPNAME, "(\"eventType=/ORACLE/SUPERCLUSTER/STATEEVENT\")"), System.getProperty(INTEREST_PROPNAME, SCRepresentativeImpl.getDefaultInterest(htierInfo.getTierId())), System.getProperty(COMPONENT_PROPNAME, "/ORACLE/SUPERCLUSTER"));
    }

    static synchronized SCRepresentativeImpl createInstance(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts, List<String> verificationList, int verificationTimeout) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts, verificationList, verificationTimeout, System.getProperty(SUBSCRIPTION_PROPNAME, "(\"eventType=/ORACLE/SUPERCLUSTER/STATEEVENT\")"), System.getProperty(INTEREST_PROPNAME, SCRepresentativeImpl.getDefaultInterest(htierInfo.getTierId())), System.getProperty(COMPONENT_PROPNAME, "/ORACLE/SUPERCLUSTER"));
    }

    static synchronized SCRepresentativeImpl createInstance(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts, List<String> verificationList, int verificationTimeout, String subscription, String interest, String component) throws SCRException {
        if (null == s_instance) {
            s_logger.info("Creating new instance");
            s_instance = new SCRepresentativeImpl(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts, verificationList, verificationTimeout, subscription, interest, component);
        } else {
            s_logger.info("Returning existing instance:" + s_instance);
        }
        return s_instance;
    }

    static SCRepresentativeImpl getInstance() throws SCRException {
        s_logger.info("Returning existing instance:" + s_instance);
        return s_instance;
    }

    private static String getDefaultInterest(String htierID) {
        return "(\"SCInterest=SCRepresentative\")|((\"SCInterest=SCClient\")&(\"tierid=" + htierID + "\"))";
    }

    @Override
    public int getSCRepCount() throws SCRException {
        return this.m_repCount;
    }

    public void start() throws SCRException {
        if (!this.m_ons.isRunning()) {
            String message = MessageBundle.getMessage((MessageKey)SclsMsgID.EONS_RUNTIME_NOT_ACTIVE, (boolean)true, (Object[])new Object[]{this.m_tierName.toString()});
            s_logger.severe(message);
            throw new SCRException(message);
        }
        if (!this.m_proxyListener.isRunning()) {
            try {
                this.m_proxyListener = this.m_ons.createProxyListener(this.m_proxyListenerPort);
                this.m_proxyListener.start();
            }
            catch (IOException e) {
                s_logger.severe(e.getMessage());
                throw new SCRException(e);
            }
        }
        if (!this.m_messageProcessorThread.isAlive()) {
            this.m_messageProcessorThread = new Thread((Runnable)this.m_messageProcessor, INTEREST_VALUE);
            this.m_messageProcessorThread.setDaemon(true);
            this.m_messageProcessorThread.start();
        }
    }

    public boolean status() {
        return this.m_messageProcessorThread.isAlive();
    }

    public void stop() {
        this.m_messageProcessor.stop();
        if (this.m_messageProcessorThread.isAlive()) {
            this.m_messageProcessorThread.interrupt();
        }
        this.m_proxyListener.shutdown();
        this.m_ons.shutdown();
    }

    @Override
    public boolean getState(SCTier tier, SCEventHandler handler) throws SCRException {
        throw new SCRException("getState: NOT IMPLEMENTED YET");
    }

    @Override
    public void setState(SCTier tier, byte[] state) throws SCRException {
        throw new SCRException("setState: NOT IMPLEMENTED YET");
    }

    @Override
    public List<SCTier> tiers() throws SCRException {
        throw new SCRException("NOT IMPLEMENTED");
    }

    @Override
    public List<LogicalAddress> memberList(SCTier tier) throws SCRException {
        try {
            ArrayList<LogicalAddress> mbrList = new ArrayList<LogicalAddress>(this.m_memberList.size());
            String htierID = this.m_ons.getHorizontalTierInfo().getTierId();
            for (LogicalAddress addr : this.m_memberList) {
                if (!tier.isClusterTier()) {
                    String myInterest = (String)addr.getProperties().get(INTEREST_TYPE);
                    if (!INTEREST_VALUE.equalsIgnoreCase(myInterest)) continue;
                    mbrList.add(addr);
                    continue;
                }
                if (!htierID.equalsIgnoreCase(addr.getTier())) continue;
                mbrList.add(addr);
            }
            s_logger.info("mbrList=" + mbrList.toString());
            return mbrList;
        }
        catch (SCTierException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclsMsgID.GET_MBRLIST_FAILED, (boolean)true, (Object[])new Object[]{tier.getName()}), e);
        }
    }

    static {
        s_logger = Logger.getLogger("oracle.supercluster");
    }

    private class MessageProcessor
    implements Runnable {
        private Subscriber m_subscriber = this.initialize();
        private boolean m_gotState = false;
        private LinkedList<MessageNotification> m_msgQueue = new LinkedList();

        MessageProcessor() {
        }

        @Override
        public void run() {
            boolean done = false;
            while (!done) {
                BaseNotification notification = this.m_subscriber.receive(true);
                if (notification == null) {
                    done = true;
                    s_logger.info("Subscriber closed already, notification=" + notification);
                    continue;
                }
                if (notification instanceof MembershipDeltaNotification) {
                    MembershipDeltaNotification deltaMsg = (MembershipDeltaNotification)notification;
                    List mbrList = deltaMsg.getMembersAdded();
                    if (mbrList.size() > 0) {
                        SCRepresentativeImpl.this.m_memberList.addAll(mbrList);
                    }
                    if ((mbrList = deltaMsg.getMembersRemoved()).size() > 0) {
                        boolean hasMbrship = false;
                        ArrayList<String> tidList = new ArrayList<String>(mbrList.size());
                        for (LogicalAddress mbr : mbrList) {
                            tidList.add(mbr.getTierId());
                            SCRepresentativeImpl.this.m_memberList.remove(mbr);
                        }
                        for (String tierID : tidList) {
                            hasMbrship = false;
                            for (LogicalAddress mbr : SCRepresentativeImpl.this.m_memberList) {
                                if (!mbr.getTierId().equalsIgnoreCase(tierID)) continue;
                                hasMbrship = true;
                                break;
                            }
                            if (hasMbrship) continue;
                            boolean anyAlive = false;
                            if (SCRepresentativeImpl.this.m_verificationList != null) {
                                int msvtime = SCRepresentativeImpl.this.m_verificationTimeout * 1000 / SCRepresentativeImpl.this.m_verificationList.size();
                                s_logger.info("msvtime=" + msvtime);
                                for (String host : SCRepresentativeImpl.this.m_verificationList) {
                                    try {
                                        anyAlive = InetAddress.getByName(host).isReachable(msvtime);
                                        if (!anyAlive) continue;
                                        break;
                                    }
                                    catch (UnknownHostException e) {
                                        s_logger.info("IGNORED:" + e.getMessage());
                                    }
                                    catch (IOException e) {
                                        s_logger.info("IGNORED:" + e.getMessage());
                                    }
                                }
                            }
                            s_logger.info("anyAlive=" + anyAlive);
                            if (anyAlive) continue;
                            byte[] bblock = SCRepresentativeImpl.this.m_stateImpl.getState(tierID);
                            MessageNotification msg = ONSFactory.createNotification((String)"/ORACLE/SUPERCLUSTER/NETWORK_PARTITION", (byte[])bblock);
                            msg.setProperty(SCRepresentativeImpl.TIER_ID, tierID);
                            msg.setProperty("/ORACLE/SUPERCLUSTER/NETWORK_PARTITION", String.valueOf(true));
                            this.m_msgQueue.addLast(msg);
                            if (SCRepresentativeImpl.this.m_ons.getBridgeStatus() != ONS.BRIDGESTATUS.PRIMARY) continue;
                            Publisher publisher = this.m_subscriber.getPublisher();
                            while (!this.m_msgQueue.isEmpty()) {
                                msg = this.m_msgQueue.removeFirst();
                                String tid = msg.getProperty(SCRepresentativeImpl.TIER_ID);
                                publisher.publish((UserNotification)msg);
                                SCRepresentativeImpl.this.m_stateImpl.clearState(tid);
                            }
                        }
                    }
                } else if (notification instanceof StateGetNotification) {
                    StateGetNotification stateGetNotification = (StateGetNotification)notification;
                    byte[] bodyBytes = SCRepresentativeImpl.this.m_stateImpl.getState();
                    this.m_subscriber.returnState(bodyBytes);
                } else if (notification instanceof StateSetNotification) {
                    StateSetNotification stateSetNotification = (StateSetNotification)notification;
                    SCRepresentativeImpl.this.m_stateImpl.setInitialState(ONSFactory.generateBodyBlock((byte[])stateSetNotification.getArgBytes()));
                    this.m_gotState = true;
                } else if (notification instanceof MessageNotification) {
                    if (this.m_gotState) {
                        MessageNotification msgNotification = (MessageNotification)notification;
                        if (msgNotification.getType().equals("/ORACLE/SUPERCLUSTER/NETWORK_PARTITION") && SCRepresentativeImpl.this.m_ons.getBridgeStatus() == ONS.BRIDGESTATUS.SECONDARY) {
                            String tid = msgNotification.getProperty(SCRepresentativeImpl.TIER_ID);
                            if (!this.m_msgQueue.isEmpty() && tid != null) {
                                Iterator it = this.m_msgQueue.iterator();
                                while (it.hasNext()) {
                                    MessageNotification msg = (MessageNotification)it.next();
                                    if (!tid.equalsIgnoreCase(msg.getProperty(SCRepresentativeImpl.TIER_ID))) continue;
                                    s_logger.info("msgQueue: removing msg=" + msg);
                                    it.remove();
                                    SCRepresentativeImpl.this.m_stateImpl.clearState(tid);
                                    break;
                                }
                            }
                        } else if (msgNotification.getType().equals("/ORACLE/SUPERCLUSTER/STATE_REQUEST")) {
                            byte[] state = SCRepresentativeImpl.this.m_stateImpl.getState(msgNotification);
                            MessageNotification response = ONSFactory.createNotification((String)"/ORACLE/SUPERCLUSTER/STATE_RESPONSE", (byte[])state);
                            response.setProperty("/ORACLE/SUPERCLUSTER/STATE_RESPONSE", String.valueOf(true));
                            response.setDestinationAddr(msgNotification.getSourceAddr());
                            if (SCRepresentativeImpl.this.m_ons.getBridgeStatus() == ONS.BRIDGESTATUS.PRIMARY) {
                                this.m_subscriber.getPublisher().publish((UserNotification)response);
                            }
                        } else {
                            SCRepresentativeImpl.this.m_stateImpl.process(msgNotification);
                        }
                    }
                } else if (notification instanceof LeaveGroupNotification) {
                    this.m_subscriber.close();
                    SCRepresentativeImpl.this.m_stateImpl.clearState();
                    this.m_gotState = false;
                    this.m_subscriber = this.initialize();
                    notification = null;
                }
                if (notification == null) continue;
                this.m_subscriber.relinquish(notification);
            }
            this.m_subscriber.close();
        }

        public void stop() {
            this.m_subscriber.close();
        }

        private Subscriber initialize() {
            HashMap<String, String> props = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            if (SCRepresentativeImpl.this.m_verificationList != null) {
                for (String hostNameOrIP : SCRepresentativeImpl.this.m_verificationList) {
                    if (sb.length() > 0) {
                        sb.append("," + hostNameOrIP);
                        continue;
                    }
                    sb.append(hostNameOrIP);
                }
                props.put("VERIFICATION_ADDRLIST", sb.toString());
                props.put("VERIFICATION_TIMEOUT", String.valueOf(SCRepresentativeImpl.this.m_verificationTimeout));
            }
            props.put(SCRepresentativeImpl.INTEREST_TYPE, SCRepresentativeImpl.INTEREST_VALUE);
            s_logger.info("props=" + ((Object)props).toString());
            Subscriber subscriber = SCRepresentativeImpl.this.m_ons.createSubscriber(SCRepresentativeImpl.this.m_subscription, SCRepresentativeImpl.this.m_component, SCRepresentativeImpl.this.m_interest, props, true);
            boolean stateExists = subscriber.getState(30000L);
            if (!stateExists) {
                SCRepresentativeImpl.this.m_stateImpl.clearState();
                this.m_gotState = true;
            }
            return subscriber;
        }
    }
}

