/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.net.InetAddress;
import java.util.logging.Logger;
import oracle.eons.DiscoveryServer;
import oracle.eons.ONSFactory;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCDiscoveryServer;

public class SCDiscoveryServerImpl
implements SCDiscoveryServer {
    private int m_port;
    private InetAddress m_address;
    private DiscoveryServer m_ds;
    private static SCDiscoveryServerImpl s_instance;
    private static Logger s_logger;

    private SCDiscoveryServerImpl(InetAddress bindAddr, int port) {
        this.m_address = bindAddr;
        this.m_port = port;
        this.m_ds = ONSFactory.createDiscoveryServer((String)bindAddr.getHostAddress(), (int)port);
    }

    static synchronized SCDiscoveryServer createInstance(InetAddress bindAddr, int port) throws DiscoveryServerException {
        if (null == s_instance) {
            s_logger.info("Creating new instance");
            s_instance = new SCDiscoveryServerImpl(bindAddr, port);
        } else {
            s_logger.info("Returning existing instance:" + s_instance);
        }
        return s_instance;
    }

    static SCDiscoveryServer getInstance() throws DiscoveryServerException {
        s_logger.info("Returning existing instance=" + s_instance);
        return s_instance;
    }

    @Override
    public InetAddress address() throws DiscoveryServerException {
        return this.m_address;
    }

    @Override
    public int port() throws DiscoveryServerException {
        return this.m_port;
    }

    @Override
    public void start() throws DiscoveryServerException {
        this.m_ds.launch();
    }

    @Override
    public boolean status() throws DiscoveryServerException {
        return this.m_ds.isRunning();
    }

    @Override
    public void stop() throws DiscoveryServerException {
        this.m_ds.shutdown();
    }

    static {
        s_logger = Logger.getLogger("oracle.supercluster");
    }
}

