/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import oracle.eons.BaseNotification;
import oracle.eons.LeaveGroupNotification;
import oracle.eons.LogicalAddress;
import oracle.eons.MembershipDeltaNotification;
import oracle.eons.MessageNotification;
import oracle.eons.ONS;
import oracle.eons.ONSFactory;
import oracle.eons.StateGetNotification;
import oracle.eons.StateSetNotification;
import oracle.eons.Subscriber;
import oracle.eons.TierDiscoveryInfo;
import oracle.supercluster.common.SCClient;
import oracle.supercluster.common.SuperClusterException;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.common.StateImpl;

public class SCClientImpl
implements SCClient {
    private static SCClientImpl s_instance;
    private String m_subscription;
    private String m_interest;
    private String m_component;
    private StateImpl m_stateImpl;
    private LinkedHashSet<LogicalAddress> m_memberList;
    private ONS m_ons;
    private MessageProcessor m_messageProcessor;
    private Thread m_messageProcessorThread;
    private Version m_version;
    private static Logger s_logger;

    private SCClientImpl(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version, String subscription, String interest, String component) throws SuperClusterException {
        this.m_ons = ONSFactory.createONSRuntime((TierDiscoveryInfo)htierInfo, (ONS.TierName)tierName);
        this.m_subscription = subscription;
        this.m_interest = interest;
        this.m_component = component;
        this.m_version = version;
        this.m_stateImpl = new StateImpl(version);
        this.m_memberList = new LinkedHashSet();
        this.m_messageProcessor = new MessageProcessor();
        this.m_messageProcessorThread = new Thread((Runnable)this.m_messageProcessor, "SCClient");
        this.m_messageProcessorThread.setDaemon(true);
        this.m_messageProcessorThread.start();
    }

    static synchronized SCClientImpl createInstance(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version) throws SuperClusterException {
        return SCClientImpl.createInstance(htierInfo, tierName, version, System.getProperty("subscription", "(\"eventType=/ORACLE/SUPERCLUSTER/STATEEVENT\")"), System.getProperty("INTEREST", SCClientImpl.getDefaultInterest()), System.getProperty("component", "/ORACLE/SUPERCLUSTER/CLIENT"));
    }

    static synchronized SCClientImpl createInstance(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version, String subscription, String interest, String component) throws SuperClusterException {
        if (null == s_instance) {
            s_logger.info("Creating new instance");
            s_instance = new SCClientImpl(htierInfo, tierName, version, subscription, interest, component);
        } else {
            s_logger.info("Returning existing instance:" + s_instance);
        }
        return s_instance;
    }

    static SCClientImpl getInstance() throws SuperClusterException {
        s_logger.info("Returning existing instance=" + s_instance);
        return s_instance;
    }

    private static String getDefaultInterest() {
        return "(\"SCInterest=SCClient\")";
    }

    public void stop() {
        this.m_messageProcessor.stop();
        if (this.m_messageProcessorThread.isAlive()) {
            this.m_messageProcessorThread.interrupt();
        }
        this.m_ons.shutdown();
    }

    @Override
    public boolean getState(String tierName) {
        throw new RuntimeException("FIXME: NOT IMPLEMENTED YET");
    }

    @Override
    public boolean getState(String tierName, String serviceName) {
        throw new RuntimeException("FIXME: NOT IMPLEMENTED YET");
    }

    static {
        s_logger = Logger.getLogger("oracle.supercluster");
    }

    private class MessageProcessor
    implements Runnable {
        private Subscriber m_subscriber = this.initialize();
        private boolean m_gotState = false;

        MessageProcessor() {
        }

        @Override
        public void run() {
            boolean done = false;
            while (!done) {
                BaseNotification notification = this.m_subscriber.receive(true);
                if (notification == null) {
                    done = true;
                    s_logger.info("Subscriber closed already, notification=" + notification);
                    continue;
                }
                if (notification instanceof MembershipDeltaNotification) {
                    MembershipDeltaNotification deltaMsg = (MembershipDeltaNotification)notification;
                    List mbrList = deltaMsg.getMembersAdded();
                    if (mbrList.size() > 0) {
                        SCClientImpl.this.m_memberList.addAll(mbrList);
                    }
                    mbrList = deltaMsg.getMembersRemoved();
                    for (LogicalAddress mbr : mbrList) {
                        SCClientImpl.this.m_memberList.remove(mbr);
                    }
                } else if (notification instanceof StateGetNotification) {
                    StateGetNotification stateGetNotification = (StateGetNotification)notification;
                    byte[] bodyBytes = SCClientImpl.this.m_stateImpl.getState(SCClientImpl.this.m_ons.getHorizontalTierInfo().getTierId());
                    this.m_subscriber.returnState(bodyBytes);
                } else if (notification instanceof StateSetNotification) {
                    StateSetNotification stateSetNotification = (StateSetNotification)notification;
                    SCClientImpl.this.m_stateImpl.setInitialState(ONSFactory.generateBodyBlock((byte[])stateSetNotification.getArgBytes()));
                    this.m_gotState = true;
                } else if (notification instanceof MessageNotification) {
                    if (this.m_gotState) {
                        MessageNotification msgNotification = (MessageNotification)notification;
                        SCClientImpl.this.m_stateImpl.process(msgNotification);
                    }
                } else if (notification instanceof LeaveGroupNotification) {
                    this.m_subscriber.close();
                    SCClientImpl.this.m_stateImpl.clearState(SCClientImpl.this.m_ons.getHorizontalTierInfo().getTierId());
                    this.m_gotState = false;
                    this.m_subscriber = this.initialize();
                    notification = null;
                }
                if (notification == null) continue;
                this.m_subscriber.relinquish(notification);
            }
            this.m_subscriber.close();
        }

        public void stop() {
            this.m_subscriber.close();
        }

        private Subscriber initialize() {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("SCInterest", "SCClient");
            s_logger.info("props=" + ((Object)props).toString());
            Subscriber subscriber = SCClientImpl.this.m_ons.createSubscriber(SCClientImpl.this.m_subscription, SCClientImpl.this.m_component, SCClientImpl.this.m_interest, props);
            boolean stateExists = subscriber.getState(30000L);
            if (!stateExists) {
                SCClientImpl.this.m_stateImpl.clearState();
                this.m_gotState = true;
            }
            return subscriber;
        }
    }
}

