/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.common;

import java.net.InetAddress;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.eons.BodyElement;
import oracle.eons.BodySegment;
import oracle.eons.ONS;
import oracle.eons.TierDiscoveryInfo;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCClient;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCRepresentative;
import oracle.supercluster.common.SuperClusterException;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.common.SCClientImpl;
import oracle.supercluster.impl.common.SCDiscoveryServerImpl;
import oracle.supercluster.impl.common.SCRepresentativeImpl;

public class CommonFactoryImpl {
    private static CommonFactoryImpl s_instance;

    private CommonFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized CommonFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new CommonFactoryImpl();
        }
        return s_instance;
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts, List<String> verificationList, int verificationTimeout) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts, verificationList, verificationTimeout);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, List<String> preferredHosts, List<String> verificationList, int verificationTimeout, String subscription, String interest, String component) throws SCRException {
        return SCRepresentativeImpl.createInstance(htierInfo, vtierInfo, tierName, port, repCount, version, preferredHosts, verificationList, verificationTimeout, subscription, interest, component);
    }

    public SCRepresentative getSCRepresentative() throws SCRException {
        return SCRepresentativeImpl.getInstance();
    }

    public SCDiscoveryServer createDiscoveryServer(InetAddress bindAddr, int port) throws DiscoveryServerException {
        return SCDiscoveryServerImpl.createInstance(bindAddr, port);
    }

    public SCDiscoveryServer getDiscoveryServer() throws DiscoveryServerException {
        return SCDiscoveryServerImpl.getInstance();
    }

    public SCClient createSCClient(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version) throws SuperClusterException {
        return SCClientImpl.createInstance(htierInfo, tierName, version);
    }

    public SCClient createSCClient(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version, String subscription, String interest, String component) throws SuperClusterException {
        return SCClientImpl.createInstance(htierInfo, tierName, version, subscription, interest, component);
    }

    public SCClient getSCClient() throws SuperClusterException {
        return SCClientImpl.getInstance();
    }

    static void copyRecurse(BodySegment inSeg, BodySegment outSeg) {
        BodySegment curSeg = outSeg;
        curSeg = curSeg.addNewSegment(inSeg.getName());
        for (BodyElement be : inSeg.getElements()) {
            curSeg.addNewElement(be.getName(), be.getValue());
        }
        for (BodySegment bs : inSeg.getSegments()) {
            CommonFactoryImpl.copyRecurse(bs, curSeg);
        }
    }
}

