/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.common;

import java.net.InetAddress;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.eons.ONS;
import oracle.eons.TierDiscoveryInfo;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCClient;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCRepresentative;
import oracle.supercluster.common.SuperClusterException;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.common.CommonFactoryImpl;

public class CommonFactory {
    public static final String JGROUPS_LOG_NAMESPACE = "org.jgroups";
    public static final String EONS_LOG_NAMESPACE = "oracle.eons";
    public static final String SC_LOG_NAMESPACE = "oracle.supercluster";
    public static final String SC_STATE_OP_NAME = "SC_STATE";
    public static final String SC_STATE_OP_SAVE = "SAVE";
    public static final String SC_STATE_OP_REMOVE = "REMOVE";
    private static CommonFactory s_instance;
    private CommonFactoryImpl s_factoryImpl = CommonFactoryImpl.getInstance();
    private Version m_version = Version.getVersion();

    private CommonFactory() throws SoftwareModuleException {
    }

    public static synchronized CommonFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new CommonFactory();
        }
        return s_instance;
    }

    public SCDiscoveryServer createDiscoveryServer(InetAddress bindAddr, int port) throws DiscoveryServerException {
        return this.s_factoryImpl.createDiscoveryServer(bindAddr, port);
    }

    public SCDiscoveryServer getDiscoveryServer() throws DiscoveryServerException {
        return this.s_factoryImpl.getDiscoveryServer();
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount) throws SCRException {
        return this.s_factoryImpl.createSCRepresentative(htierInfo, vtierInfo, tierName, port, repCount, this.m_version);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, List<String> preferredHosts) throws SCRException {
        return this.s_factoryImpl.createSCRepresentative(htierInfo, vtierInfo, tierName, port, repCount, this.m_version, preferredHosts);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, List<String> preferredHosts, List<String> verificationList, int verificationTimeout) throws SCRException {
        return this.s_factoryImpl.createSCRepresentative(htierInfo, vtierInfo, tierName, port, repCount, this.m_version, preferredHosts, verificationList, verificationTimeout);
    }

    public SCRepresentative createSCRepresentative(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, List<String> preferredHosts, List<String> verificationList, int verificationTimeout, String subscription, String interest, String component) throws SCRException {
        return this.s_factoryImpl.createSCRepresentative(htierInfo, vtierInfo, tierName, port, repCount, this.m_version, preferredHosts, verificationList, verificationTimeout, subscription, interest, component);
    }

    public SCRepresentative getSCRepresentative() throws SCRException {
        return this.s_factoryImpl.getSCRepresentative();
    }

    public SCClient createSCClient(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version) throws SuperClusterException {
        return this.s_factoryImpl.createSCClient(htierInfo, tierName, version);
    }

    public SCClient createSCClient(TierDiscoveryInfo htierInfo, ONS.TierName tierName, Version version, String subscription, String interest, String component) throws SuperClusterException {
        return this.s_factoryImpl.createSCClient(htierInfo, tierName, version, subscription, interest, component);
    }

    public SCClient getSCClient() throws SuperClusterException {
        return this.s_factoryImpl.getSCClient();
    }
}

