/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.ClusterUtil;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;
import oracle.ops.util.Utils;

public class ClusterFileUtil {
    public static final String OPT = "-";
    public static final String SOURCENODE = "sourcenode";
    public static final String SRCNODELISTFILE = "fromnodesfile";
    public static final String SOURCEFILE = "sourcefile";
    public static final String DESTFILE = "destfile";
    public static final String NODELIST = "nodelist";
    public static final String NODELISTFILE = "nodelistfile";
    public static final String OPT_COPY = "copy";
    public static final String ORACLEHOME = "oraclehome";
    public static final String OPT_RM_FILE = "rmfile";
    static final String COMMA = ",";
    private static final int TIMEOUT = 600;
    private String m_srcFileLocation = null;
    private String m_destFileLocation = null;
    private String[] m_destNodeList = null;
    private String[] m_srcNodeList = null;
    private String m_oracleHome = null;

    private void parseCopyArgs(String[] args) throws ClusterException {
        Trace.out("args = " + Utils.getString(args, COMMA));
        String[] flags = new String[]{OPT_COPY};
        String[] params = new String[]{SOURCEFILE, DESTFILE};
        String[] optional = new String[]{OPT_COPY, SOURCENODE, SRCNODELISTFILE, NODELIST, NODELISTFILE, ORACLEHOME};
        CmdLineParser cmdParser = new CmdLineParser(OPT, flags, params, optional);
        try {
            cmdParser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new ClusterException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new ClusterException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new ClusterException(uae.getMessage());
        }
        this.m_srcFileLocation = cmdParser.getParam(SOURCEFILE);
        this.m_destFileLocation = cmdParser.getParam(DESTFILE);
        this.m_oracleHome = cmdParser.getParam(ORACLEHOME);
        String nodeList = cmdParser.getParam(NODELIST);
        if (nodeList == null) {
            String nodeListFile = cmdParser.getParam(NODELISTFILE);
            if (nodeListFile != null) {
                try {
                    nodeList = Utils.getPropertyValue(nodeListFile, "NODE_NAME_LIST", true);
                }
                catch (FileNotFoundException fnfe) {
                    throw new ClusterException(fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new ClusterException(ioe.getMessage());
                }
            } else {
                MissingArgumentException mae = new MissingArgumentException(NODELISTFILE);
                throw new ClusterException(mae.getMessage());
            }
        }
        this.m_destNodeList = nodeList.split(COMMA);
        Trace.out("destination node list = " + nodeList);
        String srcNodeListFile = cmdParser.getParam(SRCNODELISTFILE);
        String srcNode = cmdParser.getParam(SOURCENODE);
        String srcNodeList = null;
        if (srcNodeListFile != null) {
            try {
                srcNodeList = Utils.getPropertyValue(srcNodeListFile, "NODE_NAME_LIST", true);
            }
            catch (FileNotFoundException fnfe) {
                throw new ClusterException(fnfe.getMessage());
            }
            catch (IOException ioe) {
                throw new ClusterException(ioe.getMessage());
            }
        }
        if (srcNodeList != null) {
            this.m_srcNodeList = srcNodeList.split(COMMA);
        } else if (srcNode != null) {
            this.m_srcNodeList = new String[]{srcNode};
        }
        Trace.out("source nodelist = " + srcNodeList);
    }

    private void copyFile() throws ClusterException {
        ClusterCmd clusterCmd = new ClusterCmd();
        Trace.out("src file location is: " + this.m_srcFileLocation);
        Trace.out("src node list is: " + Utils.getString(this.m_srcNodeList, COMMA));
        Trace.out("dest file location is: " + this.m_destFileLocation);
        Trace.out("dest node list is: " + Utils.getString(this.m_destNodeList, COMMA));
        Trace.out("oracle home is: " + this.m_oracleHome);
        if (this.m_srcNodeList == null) {
            String[] remoteNodes = ClusterUtil.findLiveNodes(this.m_destNodeList);
            if (null != this.m_oracleHome) {
                remoteNodes = this.doesOracleHomeExist(remoteNodes);
            }
            if (remoteNodes != null) {
                clusterCmd.copyFileToNodes(this.m_srcFileLocation, remoteNodes, this.m_destFileLocation, Utils.isDevelopmentEnv());
            } else if (this.m_oracleHome == null) {
                Trace.out("No remote nodes have the given oracle home");
            } else {
                Trace.out("No remote nodes are alive");
            }
        } else {
            String[] sourceNodes = ClusterUtil.findLiveNodes(this.m_srcNodeList);
            if (sourceNodes == null) {
                throw new ClusterException("Cannot find a reachable node");
            }
            try {
                sourceNodes = Utils.getRemoteNodes(sourceNodes);
            }
            catch (UnknownHostException e) {
                throw new ClusterException(e.getMessage(), e);
            }
            if (sourceNodes == null || sourceNodes.length == 0) {
                throw new ClusterException("Cannot find a reachable node");
            }
            clusterCmd.copyFileFromNode(sourceNodes[0], this.m_srcFileLocation, this.m_destFileLocation);
        }
    }

    public int executeCopy(String[] args) {
        try {
            this.parseCopyArgs(args);
        }
        catch (ClusterException cex) {
            Trace.out(cex);
            System.out.println(cex.toString());
            ClusterFileUtil.usageCopyFile();
            return 1;
        }
        try {
            this.copyFile();
            return 0;
        }
        catch (ClusterException cex) {
            Trace.out(cex);
            System.out.println(cex.toString());
            return 1;
        }
    }

    public int executeRmFile(String[] args) {
        Trace.out("args = " + Utils.getString(args, COMMA));
        if (args == null || args.length != 3 || args[0] == null || args[1] == null || args[2] == null || !args[0].equals("-rmfile")) {
            ClusterFileUtil.usageRmFile();
            return 1;
        }
        this.m_destFileLocation = args[1];
        this.m_destNodeList = args[2].split(COMMA);
        Trace.out("Removing file " + this.m_destFileLocation + " from nodes " + Utils.getString(this.m_destNodeList, COMMA));
        boolean success = false;
        try {
            ClusterCmd clusterCmd = new ClusterCmd();
            success = clusterCmd.removeFileFromNodes(this.m_destNodeList, this.m_destFileLocation);
            Trace.out("removeFileFromNodes returned with value: " + success);
        }
        catch (ClusterException e) {
            Trace.out(e);
            System.out.println(e.toString());
        }
        if (success) {
            Trace.out("Successfully removed remote file.");
            return 0;
        }
        Trace.out("Failed to remove remote file.");
        return 1;
    }

    public static void usageCopyFile() {
        System.out.println("\ncopy args:\n\t-sourcefile <source_file_location>\n\t-destfile <destination_file_location>\n\t{-nodelist node1[,node2,...] | -nodelistfile <destination_nodelist_file>}\n\t[-fromnodesfile <source_nodelist_file>]\n\t[-oraclehome <oracle_home_path>]");
    }

    public static void usageRmFile() {
        System.out.println("rmfile args:\n \t<file to delete>\n\t<nodelist>");
    }

    private String[] doesOracleHomeExist(String[] nodeList) throws ClusterException {
        Trace.out("Checking the nodes on which oracle home exists");
        if (nodeList == null) {
            return null;
        }
        String[] oraclehomeExistNodeList = null;
        ClusterCmd clsCmd = new ClusterCmd();
        ArrayList<String> oraclehomeExistNodes = new ArrayList<String>();
        String crsctlFileName = "crsctl.bin";
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            crsctlFileName = "crsctl.exe";
        }
        String filePath = this.m_oracleHome + File.separator + "bin" + File.separator + crsctlFileName;
        for (String node : nodeList) {
            if (!clsCmd.fileExists(node, filePath)) continue;
            oraclehomeExistNodes.add(node);
            Trace.out("Oracle Home exists on node " + node);
        }
        if (oraclehomeExistNodes.size() > 0) {
            oraclehomeExistNodeList = new String[oraclehomeExistNodes.size()];
            oraclehomeExistNodes.toArray(oraclehomeExistNodeList);
        }
        return oraclehomeExistNodeList;
    }
}

