/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class ClusterExecUtil {
    public static final String OPT = "-";
    public static final String OPT_EXEC = "exec";
    public static final String KEYNAME = "key";
    public static final String KEYVALUE = "value";
    public static final String OPT_OCRCREATE = "ocrcreate";
    public static final String OPT_OCRCREATEANDSET = "ocrcreateandset";
    public static final String OPT_OCRSETVAL = "ocrsetval";
    public static final String OPT_OCRGETVAL = "ocrgetval";
    public static final String OPT_OCRDELETE = "ocrdelete";
    public static final String OPT_KEYEXISTS = "keyexists";
    public static final String OPT_NODEALIVE = "nodealive";
    public static final String NODE = "node";
    public static final String OPT_UPGRADEDBSERVICES = "upgradeDBServices";
    public static final String OPT_DOWNGRADEDBSERVICES = "downgradeDBServices";
    private final String SYSTEM_KEY = "SYSTEM";
    private static final String[] FLAGS = new String[]{"exec", "ocrcreate", "ocrdelete", "ocrsetval", "ocrgetval", "keyexists", "upgradeDBServices", "downgradeDBServices", "nodealive", "ocrcreateandset"};
    private static final String[] PARAMS = new String[0];
    private static final String[] OPTIONAL = new String[]{"exec", "ocrcreate", "ocrdelete", "ocrsetval", "ocrgetval", "keyexists", "nodealive", "key", "value", "node", "ocrcreateandset", "upgradeDBServices", "downgradeDBServices"};
    private String m_keyName = null;
    private String m_keyValue = null;
    private String m_node = null;

    public void parseArgs(String[] args) throws ClusterException, OCRException, WindowsSecurityException {
        CmdLineParser parser = new CmdLineParser(OPT, FLAGS, PARAMS, OPTIONAL);
        try {
            parser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new ClusterException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new ClusterException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new ClusterException(uae.getMessage());
        }
        this.m_keyName = parser.getParam(KEYNAME);
        this.m_keyValue = parser.getParam(KEYVALUE);
        this.m_node = parser.getParam(NODE);
        Trace.out("Keyname = " + this.m_keyName);
        if (parser.getFlag(OPT_OCRCREATE)) {
            Trace.out("ocrcreate flag");
            this.createOCRKey();
        } else if (parser.getFlag(OPT_OCRCREATEANDSET)) {
            Trace.out("ocrcreateandset flag");
            this.createAndSetOCRKey();
        } else if (parser.getFlag(OPT_OCRSETVAL)) {
            Trace.out("ocrsetval flag");
            this.setOCRKeyValue();
        } else if (parser.getFlag(OPT_OCRGETVAL)) {
            Trace.out("ocrgetval flag");
            this.getOCRKeyValue();
        } else if (parser.getFlag(OPT_KEYEXISTS)) {
            Trace.out("keyexists flag");
            boolean keyExists = this.keyExists();
            System.out.println(keyExists ? "TRUE" : "FALSE");
        } else if (parser.getFlag(OPT_OCRDELETE)) {
            Trace.out("ocrdelete flag");
            this.deleteOCRKey();
        } else if (parser.getFlag(OPT_NODEALIVE)) {
            Trace.out("nodealive flag");
            this.getNodeAlive();
        } else if (parser.getFlag(OPT_UPGRADEDBSERVICES)) {
            Trace.out("upgrade db services");
            this.upgradeDBServices();
        } else if (parser.getFlag(OPT_DOWNGRADEDBSERVICES)) {
            Trace.out("downgrade db services");
            this.downgradeDBServices();
        }
    }

    public int executeCmd(String[] args) {
        ClusterExecUtil clusterExecUtil = new ClusterExecUtil();
        try {
            clusterExecUtil.parseArgs(args);
        }
        catch (ClusterException cex) {
            Trace.out(cex);
            System.out.println(cex.toString());
            clusterExecUtil.usage();
            return 1;
        }
        catch (OCRException ocx) {
            Trace.out("Exception caught: " + ocx.getMessage());
            System.out.println(ocx.toString());
            if (ocx.getMessage().equals("OCR_KEY_ALREADY_EXISTS")) {
                Trace.out("The OCR Key already exists, so returning as a warning");
                return 2;
            }
            if (ocx.getMessage().equals("OCR_KEY_NONEXISTENCE")) {
                Trace.out("The OCR key to be deleted doesn't exist");
                return 2;
            }
            return 1;
        }
        catch (WindowsSecurityException wsx) {
            Trace.out("Exception caught: " + wsx.getMessage());
            System.out.println(wsx.toString());
            return 1;
        }
        return 0;
    }

    public void getNodeAlive() throws ClusterException {
        ClusterCmd cmd = new ClusterCmd();
        if (cmd.isNodeAlive(this.m_node, 10)) {
            System.out.println(this.m_node + " : ALIVE");
        } else {
            System.out.println(this.m_node + " : NOTALIVE");
        }
    }

    public void createOCRKey() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        Trace.out("Creating OCR key " + key);
        ocr.createKey(key, 6, "SYSTEM", null);
    }

    public void setOCRKeyValue() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        Trace.out("Writing key " + key + " with value " + this.m_keyValue);
        ocr.setKeyValue(key, this.m_keyValue, 3, 6, "SYSTEM", null);
    }

    public void createAndSetOCRKey() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        Trace.out("Writing key " + key + " with value " + this.m_keyValue);
        ocr.createAndSetKeyValue(key, this.m_keyValue, 3, 6, "SYSTEM", null);
    }

    public void deleteOCRKey() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        if (!this.keyExists()) {
            Trace.out("key does not exist: " + key);
            throw new OCRException("OCR_KEY_NONEXISTENCE");
        }
        Trace.out("key exists: " + key);
        ocr.deleteKey(key, true);
    }

    public boolean keyExists() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        boolean keyExists = ocr.keyExists(key);
        return keyExists;
    }

    public void getOCRKeyValue() throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM." + this.m_keyName;
        System.out.println(ocr.getKeyValue(key));
    }

    public void upgradeDBServices() throws WindowsSecurityException {
        WinSecurityFactory winSec = WinSecurityFactory.getInstance();
        Version ver = new Version();
        winSec.migrateDBServiceSidsForUpgrade(ver);
    }

    public void downgradeDBServices() throws WindowsSecurityException {
        WinSecurityFactory winSec = WinSecurityFactory.getInstance();
        Version ver = new Version();
        winSec.migrateDBServiceSidsForDowngrade(ver);
    }

    public static void usage() {
        System.out.println("\nexec args:\n\t[-ocrcreate -key <keyname>] |\n\t[-ocrsetval -key <keyname> -value <keyvalue>] |\n\t[-ocrcreateandset -key <keyname> -value <keyvalue>] |\n\t[-ocrdelete -key <keyname>] |\n\t[-ocrgetval -key <keyname>] |\n\t[-keyexists -key <keyname>] |\n\t[-nodealive -node <node>] |\n\t[-upgradeDBServices] |\n\t[-downgradeDBServices]");
    }
}

