/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.viprange;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.operation.AddVIPRangeConfigurationOperation;
import oracle.ops.mgmt.operation.GetVIPRangeConfigurationOperation;
import oracle.ops.mgmt.operation.GetVIPRangeConfigurationResult;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.RemoveVIPRangeConfigurationOperation;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;
import oracle.ops.mgmt.viprange.DottedDecimalBinaryConverter;
import oracle.ops.mgmt.viprange.VIPAddressRange;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

class VIPRange
implements Constants {
    private static MessageBundle m_rawMesgBdle = MessageBundle.getMessageBundle("Prka");
    private Version m_version = null;
    private static final String LOCK_VIPRANGE = "srvm_lock_oracle.ops.mgmt.nodeapps.VIPRange";

    public VIPRange() {
        Trace.out("creating viprange");
        this.m_version = new Version();
    }

    public void add(VIPAddress startAddr, VIPAddress endAddr) throws VirtualIPException {
        VIPAddressRange range = new VIPAddressRange(startAddr, endAddr);
        Binary[] ipAddrs = range.getBinaryIPAddresses();
        if (ipAddrs == null || ipAddrs.length == 0) {
            Trace.out("nothing to add");
            throw new VirtualIPException(m_rawMesgBdle.getMessage("2007", true));
        }
        VIPRangeConfiguration[] vrangeArray = this.get();
        int vrArrayIndex = this.findVIPRange(range.getBinaryNetmask(), vrangeArray);
        if (vrArrayIndex == -1) {
            Trace.out("adding configurations");
            if (vrangeArray == null) {
                vrangeArray = new VIPRangeConfiguration[]{new VIPRangeConfiguration(range.getBinaryNetmask(), ipAddrs)};
            } else {
                VIPRangeConfiguration[] newVRangeArray = new VIPRangeConfiguration[vrangeArray.length + 1];
                for (int i = 0; i < vrangeArray.length; ++i) {
                    newVRangeArray[i] = vrangeArray[i];
                }
                newVRangeArray[vrangeArray.length] = new VIPRangeConfiguration(range.getBinaryNetmask(), ipAddrs);
                vrangeArray = newVRangeArray;
            }
        } else {
            Trace.out("merging configurations");
            for (int i = 0; i < ipAddrs.length; ++i) {
                vrangeArray[vrArrayIndex].addVIP(ipAddrs[i]);
            }
        }
        this.set(vrangeArray);
    }

    public void remove() throws VirtualIPException {
        Trace.out("removing vip range config from OCR");
        RemoveVIPRangeConfigurationOperation removeVIPRangeConfigOp = new RemoveVIPRangeConfigurationOperation(this.m_version);
        LocalCommand lCommand = new LocalCommand(removeVIPRangeConfigOp);
        lCommand.execute();
        OperationResult result = lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("remote operation failed");
            throw new VirtualIPException(m_rawMesgBdle.getMessage("2014", true));
        }
    }

    public VIPRangeConfiguration[] get() throws VirtualIPException {
        Trace.out("Getting vip range config for all netmasks from OCR");
        GetVIPRangeConfigurationOperation getVIPRangeConfigOp = new GetVIPRangeConfigurationOperation(this.m_version);
        LocalCommand lCommand = new LocalCommand(getVIPRangeConfigOp);
        lCommand.execute();
        GetVIPRangeConfigurationResult result = (GetVIPRangeConfigurationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("remote operation failed");
            throw new VirtualIPException(m_rawMesgBdle.getMessage("2012", true));
        }
        return result.getResult();
    }

    public void set(VIPRangeConfiguration[] vrangeArray) throws VirtualIPException {
        AddVIPRangeConfigurationOperation addVIPRangeConfigOp = new AddVIPRangeConfigurationOperation(vrangeArray, this.m_version);
        LocalCommand lCommand = new LocalCommand(addVIPRangeConfigOp);
        lCommand.execute();
        OperationResult result = lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("remote operation failed");
            throw new VirtualIPException(m_rawMesgBdle.getMessage("2013", true));
        }
    }

    public VIPAddress getVIP() throws VirtualIPException {
        VirtualIPException vexception = new VirtualIPException(m_rawMesgBdle.getMessage("2008", true));
        VIPRangeConfiguration[] vrangeArray = this.get();
        if (vrangeArray == null || vrangeArray.length == 0) {
            Trace.out("no viprange found in ocr");
            throw vexception;
        }
        for (int i = 0; i < vrangeArray.length; ++i) {
            InetAddress addr;
            Binary[] ipAddrs = vrangeArray[i].getIPAddresses();
            if (ipAddrs == null || ipAddrs.length <= 0) continue;
            Binary ipBinary = ipAddrs[0];
            String ip = new DottedDecimalBinaryConverter(ipBinary).getDottedDecimal();
            Binary netmaskBinary = vrangeArray[i].getNetmask();
            String netmask = new DottedDecimalBinaryConverter(netmaskBinary).getDottedDecimal();
            try {
                addr = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                Trace.out("this should not happen: " + e.getMessage());
                throw new VirtualIPException(e.getMessage());
            }
            String name = addr.getHostName();
            Trace.out("vipAddr name    =" + name);
            Trace.out("vipAddr ip      =" + ip);
            Trace.out("vipAddr netmask =" + netmask);
            VIPAddress result = new VIPAddress(name, ip, netmask, null);
            vrangeArray[i].deleteVIP(ipBinary);
            this.set(vrangeArray);
            return result;
        }
        Trace.out("no viprange found in ocr");
        throw vexception;
    }

    public void removeVIP(VIPAddress vip) throws VirtualIPException {
        Binary[] ipAddrs;
        String inputVIPBinary = new DottedDecimalBinaryConverter(vip.getIPAddress().getHostAddress()).getBinary().toString();
        VirtualIPException vexception = new VirtualIPException(m_rawMesgBdle.getMessage("2008", true));
        VIPRangeConfiguration[] vrangeArray = this.get();
        if (vrangeArray == null || vrangeArray.length == 0) {
            throw vexception;
        }
        DottedDecimalBinaryConverter netmaskConverter = new DottedDecimalBinaryConverter(vip.getIPAddress().getHostAddress());
        Binary binNetmask = netmaskConverter.getBinary();
        int index = this.findVIPRange(binNetmask, vrangeArray);
        if (index > 0 && (ipAddrs = vrangeArray[index].getIPAddresses()) != null && ipAddrs.length > 0) {
            for (int j = 0; j < ipAddrs.length; ++j) {
                if (!inputVIPBinary.equals(ipAddrs[j].toString())) continue;
                vrangeArray[index].deleteVIP(ipAddrs[j]);
                this.set(vrangeArray);
                return;
            }
        }
        throw vexception;
    }

    private int findVIPRange(Binary netmask, VIPRangeConfiguration[] vrangeArray) {
        if (vrangeArray == null) {
            return -1;
        }
        for (int i = 0; i < vrangeArray.length; ++i) {
            if (vrangeArray[i] == null || !netmask.equals(vrangeArray[i].getNetmask())) continue;
            return i;
        }
        return -1;
    }
}

