/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.viprange;

import java.util.StringTokenizer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;

public class DottedDecimalBinaryConverter {
    private String m_dottedDecimalVal;
    private Binary m_binaryVal;

    public DottedDecimalBinaryConverter(String dottedDecimalVal) {
        this.m_dottedDecimalVal = dottedDecimalVal;
        StringTokenizer toks = new StringTokenizer(dottedDecimalVal, ".");
        Trace.out("#tokens = " + toks.countTokens());
        int[] field = new int[4];
        for (int index = 0; toks.hasMoreTokens() && index < 4; ++index) {
            field[index] = new Integer(toks.nextToken());
        }
        String binaryStr = new Binary(field[0], 8).toString() + new Binary(field[1], 8).toString() + new Binary(field[2], 8).toString() + new Binary(field[3], 8).toString();
        this.m_binaryVal = new Binary(binaryStr);
    }

    public DottedDecimalBinaryConverter(Binary binaryVal) {
        this.m_binaryVal = binaryVal;
        Trace.out("binaryVal is " + binaryVal.length() + "-bit");
        String binaryStr = binaryVal.toString();
        long field1 = new Binary(binaryStr.substring(0, 8)).intValue();
        long field2 = new Binary(binaryStr.substring(8, 16)).intValue();
        long field3 = new Binary(binaryStr.substring(16, 24)).intValue();
        long field4 = new Binary(binaryStr.substring(24, 32)).intValue();
        this.m_dottedDecimalVal = field1 + "." + field2 + "." + field3 + "." + field4;
    }

    public String getDottedDecimal() {
        return this.m_dottedDecimalVal;
    }

    public Binary getBinary() {
        return this.m_binaryVal;
    }

    public boolean isValidNetmask() {
        try {
            StringTokenizer toks = new StringTokenizer(this.m_dottedDecimalVal, ".");
            if (toks.countTokens() != 4) {
                return false;
            }
            String binaryStr = this.m_binaryVal.toString();
            int leftIndexOfZero = binaryStr.indexOf("0");
            int rightIndexOfOne = binaryStr.lastIndexOf("1");
            if (leftIndexOfZero == -1 || rightIndexOfOne == -1) {
                return true;
            }
            return leftIndexOfZero == rightIndexOfOne + 1;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

