/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.viprange;

import oracle.ops.mgmt.trace.Trace;

public class Binary
implements Comparable {
    private boolean[] digit;

    public Binary() {
        this.digit = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            this.digit[i] = false;
        }
    }

    public Binary(long x, int length) {
        this.digit = new boolean[length];
        for (int f = this.digit.length - 1; f >= 0; --f) {
            this.digit[f] = x % 2L == 1L || x % 2L == -1L;
            x /= 2L;
        }
        if (x > 0L) {
            Trace.out("int " + x + " is truncated!");
        }
    }

    public Binary(String str) {
        this.digit = new boolean[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            this.digit[i] = str.charAt(i) == '1';
        }
    }

    public int length() {
        return this.digit.length;
    }

    public long intValue() {
        long value = 0L;
        int power = 0;
        for (int i = this.digit.length - 1; i >= 0; --i) {
            if (this.digit[i]) {
                value += (long)Math.pow(2.0, power);
            }
            ++power;
        }
        return value;
    }

    public boolean equals(Object a) {
        if (a == null) {
            return false;
        }
        return this.intValue() == ((Binary)a).intValue();
    }

    public String toString() {
        String str = new String();
        for (int i = 0; i < this.digit.length; ++i) {
            str = this.digit[i] ? str + "1" : str + "0";
        }
        return str;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        return Binary.compare(this, (Binary)other);
    }

    public static int compare(Binary a, Binary b) {
        long ia = a.intValue();
        long ib = b.intValue();
        Binary.debugPrint("a", a);
        Binary.debugPrint("b", b);
        if (ia < ib) {
            return -1;
        }
        if (ia > ib) {
            return 1;
        }
        return 0;
    }

    public static Binary add(Binary a, Binary b) {
        int len = a.length() > b.length() ? a.length() : b.length();
        long ia = a.intValue();
        long ib = b.intValue();
        Binary result = new Binary(ia + ib, len);
        return result;
    }

    public static Binary subtract(Binary a, Binary b) {
        int len = a.length() > b.length() ? a.length() : b.length();
        long ia = a.intValue();
        long ib = b.intValue();
        Binary result = new Binary(ia - ib, len);
        return result;
    }

    private static void debugPrint(String name, Binary a) {
        Trace.out(name + " = (" + a.length() + "-bit)" + a.toString() + " (decimal)" + a.intValue());
    }
}

