/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.trace;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.cluster.logger.FileOutput;
import oracle.cluster.logger.SRVLevel;
import oracle.cluster.logger.TraceLogger;
import oracle.cluster.logger.TraceLoggerFactory;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.trace.LoggerStream;

public class Trace {
    public static final String TRACE_ENABLED_PROPERTY = "TRACING.ENABLED";
    public static final String TRACE_NATIVE_ENABLED_PROPERTY = "NATIVETRACING.ENABLED";
    public static final String TRACE_JNI_ENABLED_PROPERTY = "JNITRACING.ENABLED";
    public static final String TRACE_LEVEL_PROPERTY = "TRACING.LEVEL";
    public static final String TRACE_STDOUT_PROPERTY = "TRACING.STDOUT";
    public static final String TRACE_PACKAGE_PROPERTY = "TRACING.PACKAGE";
    public static final String SRVM_TRACE_ENV_VAR = "SRVM_TRACE";
    public static final int MINIMUM_LOGGING_FILE_CNT = 2;
    public static final int CODE_TRACE = 1;
    public static final int ENTRY_EXIT = 2;
    public static final int DEVELOPER_LEVEL = 3;
    public static final int ADMIN_LEVEL = 4;
    public static final int DEBUG_LEVEL = 5;
    public static final int INFORMATION_LEVEL = 8;
    public static final int WARNING_LEVEL = 12;
    public static final int ERROR_LEVEL = 15;
    public static final int CRITICAL_LEVEL = 16;
    private static boolean s_bTraceEnabled = false;
    private static boolean s_bTraceThreads = true;
    private static boolean s_bFullTrace = false;
    private static int s_CurrentTraceLevel = 0;
    private static boolean s_packageTraceEnabled = true;
    private static Hashtable s_packageTraceTable = new Hashtable();
    private static boolean s_bTraceProcess = false;
    private static String s_currentProcessID = ManagementFactory.getRuntimeMXBean().getName();
    private static String[] s_packageNames = new String[]{"oracle.ops.mgmt.asm", "oracle.ops.mgmt.cluster", "oracle.ops.mgmt.daemon", "oracle.ops.mgmt.command", "oracle.ops.mgmt.command.db", "oracle.ops.mgmt.command.file", "oracle.ops.mgmt.command.listener", "oracle.ops.mgmt.command.service", "oracle.ops.mgmt.command.registry", "oracle.ops.mgmt.command.daemon", "oracle.ops.mgmt.command.util", "oracle.ops.mgmt.synchronize", "oracle.ops.mgmt.database", "oracle.ops.mgmt.nativesystem", "oracle.ops.mgmt.nodeapps", "oracle.ops.mgmt.rawdevice", "oracle.ops.mgmt.operation", "oracle.ops.mgmt.operation.ha"};
    private static boolean s_bTraceToStdOut;
    private static String s_strTraceFileName;
    private static boolean s_bTraceToFile;
    private static PrintStream s_psOut;
    private static DataOutputStream s_dsOut;
    private static boolean s_bPrintDate;
    private static boolean s_bPrintLineInfo;
    private static String s_strJavaNewLine;
    private static String s_strFinalizer;
    private static Throwable s_thTrace;
    protected static PrintStream s_stdout;
    protected static PrintStream s_stderr;
    protected static String s_traceFilePerm;
    private static int s_maxLogOutputSize;
    private static int s_maxLogOutputFiles;
    private static boolean s_bSavePreviousLog;
    private static TraceLoggerFactory tf;
    private static TraceLogger s_tlogger;
    private static boolean s_winsecNativeTrace;

    public static boolean isNativeDebug() {
        return s_tlogger.isNativeTraceEnabled();
    }

    public static boolean isJNIDebug() {
        return s_tlogger.isJNITraceEnabled();
    }

    public static boolean isCRSNativeDebug() {
        return s_tlogger.isCRSNativeTraceEnabled();
    }

    public static void traceEnabled(boolean bState) {
        s_bTraceEnabled = bState;
        s_tlogger.traceLoggerEnabled(s_bTraceEnabled);
        s_tlogger.traceLoggerSetLevel(Trace.convertLogLevel(s_CurrentTraceLevel));
    }

    public static void nativeTraceEnabled(boolean bState) {
        s_tlogger.nativeTraceEnabled(bState);
    }

    public static void JNITraceEnabled(boolean bState) {
        s_tlogger.JNITraceEnabled(bState);
    }

    public static void nativeCSSTraceEnabled(boolean bState) {
        s_tlogger.CSSTraceEnabled(bState);
    }

    public static void nativeCRSTraceEnabled(boolean bState) {
        s_tlogger.CRSTraceEnabled(bState);
    }

    public static void internalTraceEnabled(boolean bState) {
        s_bTraceEnabled = bState;
    }

    public static void setTraceLevel(int nTraceLevel) {
        s_CurrentTraceLevel = nTraceLevel;
        s_tlogger.traceLoggerSetLevel(Trace.convertLogLevel(s_CurrentTraceLevel));
    }

    public static void setUID(int uid) {
        s_tlogger.setUID(uid);
    }

    public static void setHelperUID(int uid) {
        s_tlogger.setHelperUID(uid);
    }

    public static int getUID() {
        return s_tlogger.getUID();
    }

    public static void internalSetTraceLevel(int nTraceLevel) {
        s_CurrentTraceLevel = nTraceLevel;
    }

    public static void setTraceFilePerm(String traceFilePerm) {
        s_traceFilePerm = traceFilePerm;
    }

    public static void setTraceLogger() {
        if (s_tlogger == null) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
        }
    }

    public static void setTraceLogger(TraceLogger stLogger) {
        s_tlogger = stLogger;
    }

    public static void setPackageTracing(String packageNames, boolean packageTracing) {
        s_packageTraceEnabled = packageTracing;
        if (packageNames != null && packageNames.length() != 0) {
            s_packageTraceEnabled = true;
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageTraceEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageTraceTable.get(singlePackageName);
                if (integer == null) {
                    s_packageTraceEnabled = false;
                    break;
                }
                s_packageTraceTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageTraceEnabled = false;
        }
    }

    public static boolean configure(boolean traceToWindow, boolean traceToStdOut, boolean printDate, boolean traceToFile, String traceFileName, boolean printLineInfo) {
        return Trace.configure(traceToWindow, traceToStdOut, printDate, traceToFile, traceFileName, printLineInfo, false);
    }

    public static boolean configure(boolean traceToWindow, boolean traceToStdOut, boolean printDate, boolean traceToFile, String traceFileName, boolean printLineInfo, boolean append) {
        boolean retVal = true;
        if (!s_bFullTrace && !s_bTraceEnabled) {
            return retVal;
        }
        s_bTraceEnabled = true;
        s_tlogger.traceLoggerEnabled(s_bTraceEnabled);
        s_bTraceToStdOut = traceToStdOut;
        s_bPrintDate = printDate;
        s_bPrintLineInfo = printLineInfo;
        if (traceToFile) {
            retVal = Trace.enableLogging(traceFileName, append);
        }
        return retVal;
    }

    public static void setMaxLogOutputSize(int sizeInMeg) {
        s_maxLogOutputSize = sizeInMeg;
    }

    public static void setMaxLogOutputFiles(int nFiles) {
        s_maxLogOutputFiles = nFiles;
    }

    public static void setSavePreviousLog(boolean bSave) {
        s_bSavePreviousLog = bSave;
    }

    public static void setTraceThreadsOption(boolean tt) {
        s_bTraceThreads = tt;
    }

    public static void setTraceProcessOption(boolean bState) {
        s_bTraceProcess = bState;
    }

    public static void enableDebugTracing() {
        s_CurrentTraceLevel = 5;
        s_bFullTrace = true;
        s_tlogger.traceLoggerSetLevel(Trace.convertLogLevel(s_CurrentTraceLevel));
    }

    public static void enableTracing() {
        s_bFullTrace = true;
    }

    public static void addClassToSkip(String className) {
        s_tlogger.addClassToSkip(className);
    }

    public static void out(Object obj) {
        if (obj != null) {
            Trace.out(obj.toString());
        } else {
            Trace.out("null");
        }
    }

    private static SRVLevel convertLogLevel(int level) {
        switch (level) {
            case 1: {
                return SRVLevel.CODE_TRACE;
            }
            case 2: {
                return SRVLevel.ENTRY_EXIT;
            }
            case 3: {
                return SRVLevel.DEVELOPER_LEVEL;
            }
            case 4: {
                return SRVLevel.ADMIN_LEVEL;
            }
            case 5: {
                return SRVLevel.DEBUG_LEVEL;
            }
            case 8: {
                return SRVLevel.INFORMATION_LEVEL;
            }
            case 12: {
                return SRVLevel.WARNING_LEVEL;
            }
            case 15: {
                return SRVLevel.ERROR_LEVEL;
            }
            case 16: {
                return SRVLevel.CRITICAL_LEVEL;
            }
        }
        return SRVLevel.DEBUG_LEVEL;
    }

    public static void out(boolean isMajor, String strText) {
        if (s_tlogger == null) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
        }
        s_tlogger.write(isMajor, strText);
    }

    public static void out(boolean isMajor, String format, Object ... args) {
        String line = String.format(format, args);
        Trace.out(isMajor, line);
    }

    public static void out(int level, String strText) {
        if (s_tlogger == null) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
        }
        s_tlogger.write(Trace.convertLogLevel(level), strText);
    }

    public static boolean isTraceEnabled() {
        return s_bTraceEnabled;
    }

    public static boolean isLevelEnabled(int level) {
        return s_bTraceEnabled && level >= s_CurrentTraceLevel || level == 16;
    }

    public static int getCurrentTraceLevel() {
        return s_CurrentTraceLevel;
    }

    public static void out(String strText) {
        if (s_tlogger == null) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
        }
        s_tlogger.write(SRVLevel.DEBUG_LEVEL, strText);
    }

    static void nativeOut(String strText) {
        String osGroup = DeterminePlatform.getOSGroup();
        if (s_winsecNativeTrace && "WINDOWS".equalsIgnoreCase(osGroup) || Trace.isJNIDebug() || Trace.isNativeDebug()) {
            Trace.out(16, strText);
        }
    }

    public static void out(Object obj, String strText) {
        if (obj instanceof String) {
            Trace.out(5, (String)obj, strText);
        } else {
            String className = obj.getClass().getName();
            Integer integer = (Integer)s_packageTraceTable.get(className);
            if (integer != null && integer == 1) {
                Trace.out(className + ": " + strText);
            }
        }
    }

    public static void out(int level, String format, Object ... args) {
        String line = String.format(format, args);
        Trace.out(level, line);
    }

    public static void out(String format, Object ... args) {
        Trace.out(5, format, args);
    }

    private static String extractPackageName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int count = st.countTokens();
        StringBuffer buf = new StringBuffer();
        String packagename = null;
        for (int i = 0; i < count - 4; ++i) {
            String newtoken = st.nextToken();
            buf.append(newtoken + ".");
        }
        buf.append(st.nextToken());
        packagename = buf.toString();
        return packagename;
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(s_strJavaNewLine + elements[i].toString());
                continue;
            }
            sb.append(elements[i].toString());
        }
        return sb.toString();
    }

    private static void internalOut(String strText, int level) {
        String tracePrefix = "";
        if (!s_bTraceEnabled) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss.SSS z ");
        SimpleDateFormat sdf1 = new SimpleDateFormat(" HH:mm:ss.SSS z ");
        if (s_bTraceProcess) {
            tracePrefix = "[" + s_currentProcessID + "] ";
        }
        if (s_bTraceThreads) {
            tracePrefix = s_bPrintDate ? tracePrefix + "[" + Thread.currentThread().getName() + "] [" + sdf.format(new Date()) + "] " : tracePrefix + "[" + Thread.currentThread().getName() + "] [" + sdf1.format(new Date()) + "] ";
        }
        if (s_bPrintLineInfo) {
            int numFramesToSkip;
            s_thTrace = new Throwable();
            StackTraceElement[] elements = s_thTrace.getStackTrace();
            if (elements.length == 0) {
                return;
            }
            for (numFramesToSkip = 0; numFramesToSkip < elements.length && elements[numFramesToSkip].getClassName().endsWith("Trace"); ++numFramesToSkip) {
            }
            StackTraceElement stElem = elements[numFramesToSkip];
            String trace_info_line = stElem.toString();
            String packageName = Trace.extractPackageName(trace_info_line);
            if (s_packageTraceEnabled) {
                Integer integer = (Integer)s_packageTraceTable.get(packageName);
                if (integer == null) {
                    return;
                }
                if (integer != 1) {
                    return;
                }
            }
            String className = stElem.getClassName();
            tracePrefix = tracePrefix + "[" + (className.length() > packageName.length() ? className.substring(packageName.length() + 1) : className) + "." + (stElem.isNativeMethod() ? "Native" : stElem.getMethodName() + ":" + stElem.getLineNumber()) + "]  ";
        }
        strText = tracePrefix + strText;
        if (s_bTraceToStdOut || level == 16 || !s_bTraceToFile) {
            Trace.traceToStdOut(strText);
            Trace.traceToStdOut(s_strJavaNewLine);
        }
        if (s_bTraceToFile && s_psOut != null) {
            s_psOut.println(strText);
        }
    }

    public static void out(Exception e) {
        if (s_tlogger == null) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
        }
        s_tlogger.write(e);
    }

    public static void finalizerOut(String strText, int level) {
        if (s_bTraceEnabled || level >= 16) {
            if (s_bTraceThreads) {
                System.out.print(s_strFinalizer);
            }
            System.out.println(strText);
        } else if (s_bTraceEnabled) {
            if (s_bTraceToStdOut) {
                if (s_bTraceThreads) {
                    Trace.traceToStdOut(s_strFinalizer);
                }
                Trace.traceToStdOut(strText);
                Trace.traceToStdOut(s_strJavaNewLine);
            }
            if (s_bTraceToFile) {
                try {
                    if (s_bTraceThreads && s_psOut != null) {
                        s_psOut.print(s_strFinalizer);
                    }
                    if (s_psOut != null) {
                        s_psOut.println(s_strFinalizer);
                    }
                }
                catch (Exception e) {
                    System.out.print("Trace: error writing to file ");
                    System.out.print(s_strTraceFileName);
                    System.out.print(".  All further file output is terminated");
                    System.out.println(e);
                    s_bTraceToFile = false;
                }
            }
        }
    }

    public static void adjustTraceSize(int newSize) {
        if (s_strTraceFileName == null) {
            return;
        }
        s_maxLogOutputSize = newSize;
        Trace.close();
        long eachFileSize = LoggerStream.convertMegToBytes(s_maxLogOutputSize);
        if (s_maxLogOutputFiles > 0) {
            eachFileSize /= (long)s_maxLogOutputFiles;
        }
        FileOutput fout = new FileOutput(s_strTraceFileName, new Long(eachFileSize).intValue(), s_maxLogOutputFiles, true, false, s_traceFilePerm);
        s_psOut = fout;
        s_tlogger.addOutput(fout);
    }

    private static void openTraceFile(boolean append) throws IOException {
        if (s_maxLogOutputSize <= 0) {
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
            FileOutput fout = new FileOutput(s_strTraceFileName, append, s_bSavePreviousLog, s_traceFilePerm);
            s_psOut = fout;
            s_tlogger.addOutput(fout);
        } else {
            s_maxLogOutputFiles = Math.max(s_maxLogOutputFiles, 2);
            long eachFileSize = LoggerStream.convertMegToBytes(s_maxLogOutputSize) / (long)s_maxLogOutputFiles;
            tf = TraceLoggerFactory.getInstance();
            s_tlogger = tf.getTraceLogger();
            FileOutput fout = new FileOutput(s_strTraceFileName, new Long(eachFileSize).intValue(), s_maxLogOutputFiles, append, s_bSavePreviousLog, s_traceFilePerm);
            s_psOut = fout;
            s_tlogger.addOutput(fout);
        }
    }

    public static void stackTrace(Throwable th) {
        if (!s_bFullTrace) {
            return;
        }
        s_thTrace = th == null ? new Throwable() : th;
        String temp = Trace.getStackTrace(s_thTrace);
        if (s_bTraceToStdOut) {
            Trace.traceToStdOut(temp + s_strJavaNewLine);
        }
        if (s_bTraceToFile) {
            try {
                if (s_psOut != null) {
                    s_psOut.println(temp);
                }
            }
            catch (Exception e) {
                System.out.println("Trace: error writing to file " + s_strTraceFileName + " All further file output is terminated");
                System.out.println(e);
                s_bTraceToFile = false;
            }
        }
    }

    public static void stackTrace() {
        Trace.stackTrace(null);
    }

    public static void close() {
        s_tlogger.close();
    }

    public static boolean enableLogging(String traceFileName) {
        return Trace.enableLogging(traceFileName, false);
    }

    public static boolean enableLogging(String traceFileName, boolean append) {
        s_bTraceToFile = true;
        String oldTraceFileName = s_strTraceFileName;
        s_strTraceFileName = traceFileName;
        if (s_stdout == null) {
            s_stdout = System.out;
        }
        if (s_stderr == null) {
            s_stderr = System.err;
        }
        try {
            if (s_psOut != null && !traceFileName.equals(oldTraceFileName)) {
                s_psOut.close();
            }
            if (oldTraceFileName == null || new File(traceFileName).compareTo(new File(oldTraceFileName)) != 0) {
                Trace.openTraceFile(append);
                System.setErr(s_psOut);
            }
        }
        catch (IOException e) {
            s_bTraceToFile = false;
            Trace.out("Trace: error creating file " + s_strTraceFileName + ". All further file output is terminated");
            return false;
        }
        return true;
    }

    public static void traceToStdOut(String str) {
        if (s_stdout != null) {
            s_stdout.print(str);
        } else {
            System.out.print(str);
        }
    }

    public static void assertFunc(boolean condition, String mesg) {
        if (!s_bTraceEnabled) {
            return;
        }
        if (!condition) {
            System.err.println("Assertion failed: " + mesg);
            System.exit(2);
        }
    }

    public static String getTraceFile() {
        return s_bTraceToFile ? s_strTraceFileName : null;
    }

    public static void pStack(Exception e) {
        StackTraceElement[] stElem;
        for (StackTraceElement ste : stElem = e.getStackTrace()) {
            Trace.out("STACK:" + ste.toString());
        }
    }

    static {
        s_psOut = null;
        s_dsOut = null;
        s_bPrintDate = true;
        s_bPrintLineInfo = true;
        s_strJavaNewLine = System.getProperty("line.separator");
        s_strFinalizer = "[* Finalizer *] ";
        s_traceFilePerm = null;
        s_maxLogOutputSize = 0;
        s_maxLogOutputFiles = 0;
        s_bSavePreviousLog = false;
        s_tlogger = null;
        s_winsecNativeTrace = false;
        Trace.setTraceLogger();
        s_bTraceEnabled = Boolean.getBoolean("DEBUG") || Boolean.getBoolean(TRACE_ENABLED_PROPERTY);
        s_bFullTrace = Boolean.getBoolean("FULLTRACE");
        s_CurrentTraceLevel = System.getProperty(TRACE_LEVEL_PROPERTY) != null ? Integer.getInteger(TRACE_LEVEL_PROPERTY, 16).intValue() : Integer.getInteger("TRACE_LEVEL", 16).intValue();
        if (s_CurrentTraceLevel <= 3) {
            s_winsecNativeTrace = true;
        }
        if (s_bTraceEnabled) {
            s_tlogger.traceLoggerEnabled(s_bTraceEnabled);
            s_tlogger.setLevel(Trace.convertLogLevel(s_CurrentTraceLevel));
        }
        for (int i = 0; i < s_packageNames.length; ++i) {
            s_packageTraceTable.put(s_packageNames[i], new Integer(0));
        }
        String packageNames = System.getProperty(TRACE_PACKAGE_PROPERTY);
        if (packageNames != null && packageNames.length() != 0) {
            StringTokenizer st = new StringTokenizer(packageNames, ",");
            while (st.hasMoreTokens()) {
                String singlePackageName = st.nextToken();
                if (singlePackageName == null || singlePackageName.length() == 0) {
                    s_packageTraceEnabled = false;
                    break;
                }
                Integer integer = (Integer)s_packageTraceTable.get(singlePackageName);
                if (integer == null) {
                    s_packageTraceEnabled = false;
                    break;
                }
                s_packageTraceTable.put(singlePackageName, new Integer(1));
            }
        } else {
            s_packageTraceEnabled = false;
        }
    }
}

