/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

class LoggerStream
extends PrintStream {
    String m_prefix = "";
    int m_maxFiles = 0;
    long m_maxSize = 0L;
    File[] m_files = null;
    private int currentIndex = 0;
    private long currentSize = 0L;
    static final String LSEP = System.getProperty("line.separator");
    private boolean m_multiFile = false;

    public LoggerStream(String strLogFile, boolean bSavePrevious, boolean append) throws IOException {
        super(System.out, true);
        if (!append) {
            LoggerStream.updateOldFiles(strLogFile, bSavePrevious);
        } else {
            File logFile = new File(strLogFile);
            if (logFile.exists()) {
                this.currentSize = logFile.length();
            }
        }
        boolean toSetFilePerm = !new File(strLogFile).exists() && Trace.s_traceFilePerm != null;
        this.out = new FileOutputStream(strLogFile, append);
        if (toSetFilePerm) {
            this.modifyTraceFilePerm(strLogFile);
        }
    }

    public LoggerStream(String prefix, int maxFiles, long maxSize, boolean bSavePrevious, boolean append) throws IOException {
        super(System.out, true);
        this.m_multiFile = true;
        this.m_prefix = prefix;
        this.m_maxFiles = Math.max(maxFiles, 2);
        this.m_maxSize = maxSize;
        this.m_files = new File[this.m_maxFiles];
        String filename = this.getNewFileName(this.currentIndex);
        if (!append) {
            LoggerStream.updateOldFiles(prefix, bSavePrevious);
        } else {
            for (int i = 0; i < this.m_maxFiles; ++i) {
                String fileNameTmp = this.getNewFileName(i);
                File logFile = new File(fileNameTmp);
                if (!logFile.exists()) continue;
                filename = fileNameTmp;
                this.currentIndex = i;
                this.currentSize = logFile.length();
                this.m_files[i] = logFile;
                if ((double)this.currentSize * 1.1 < (double)this.m_maxSize) break;
            }
        }
        this.m_files[this.currentIndex] = new File(filename);
        boolean toSetFilePerm = !new File(filename).exists() && Trace.s_traceFilePerm != null;
        this.out = new FileOutputStream(filename, append);
        if (toSetFilePerm) {
            this.modifyTraceFilePerm(filename);
        }
    }

    private void modifyTraceFilePerm(String tracefileName) {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        if (tracefileName == null || tracefileName.length() == 0 || Trace.s_traceFilePerm == null) {
            return;
        }
        String cmdToRun = "/usr/bin/chmod " + Trace.s_traceFilePerm + " " + tracefileName;
        StringBuilder errMsg = new StringBuilder();
        boolean toReportPermFailure = false;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmdToRun);
            int ret = proc.waitFor();
            if (proc.exitValue() != 0) {
                toReportPermFailure = true;
                String s = null;
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    errMsg.append(s);
                }
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((s = stdErr.readLine()) != null) {
                    errMsg.append(s);
                }
            }
        }
        catch (IOException e) {
            toReportPermFailure = true;
            errMsg.append(e.getMessage());
        }
        catch (InterruptedException e) {
            toReportPermFailure = true;
            errMsg.append(e.getMessage());
        }
        if (toReportPermFailure && this.out != null) {
            new PrintStream(this.out).println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" + LSEP + "Trace(ERROR): Failure in setting the permissions for this file." + LSEP + errMsg.toString() + LSEP + "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
    }

    private static void updateOldFiles(String filePath, boolean bSave) {
        File f = new File(filePath);
        String name = f.getName();
        String path = f.getParent();
        if (path == null) {
            path = ".";
        }
        File dir = new File(path);
        String[] list = dir.list();
        String separator = System.getProperty("file.separator");
        String strTimeStamp = LoggerStream.getTimeStamp();
        if (list == null) {
            Trace.out("trace: dir does not exist: " + dir);
            return;
        }
        for (int idx = 0; idx < list.length; ++idx) {
            String strTmp;
            if (list[idx].equals(name)) {
                File oldFile = new File(path + separator + list[idx]);
                if (bSave) {
                    File newFile = new File(path + separator + list[idx] + "_" + strTimeStamp);
                    if (!oldFile.exists()) continue;
                    oldFile.renameTo(newFile);
                    continue;
                }
                if (!oldFile.isFile()) continue;
                oldFile.delete();
                continue;
            }
            if (!list[idx].startsWith(name) || list[idx].length() <= name.length() || list[idx].charAt(name.length()) != '.' || (strTmp = list[idx].substring(name.length() + 1)) == null || strTmp.length() <= 0 || strTmp.indexOf(95) != -1) continue;
            boolean bValid = true;
            try {
                int n = new Integer(strTmp);
            }
            catch (NumberFormatException nfe) {
                bValid = false;
            }
            catch (Exception e) {
                bValid = false;
            }
            if (!bValid) continue;
            File oldFile = new File(path + separator + list[idx]);
            if (bSave) {
                File newFile = new File(path + separator + list[idx] + "_" + strTimeStamp);
                if (!oldFile.exists()) continue;
                oldFile.renameTo(newFile);
                continue;
            }
            if (!oldFile.isFile()) continue;
            oldFile.delete();
        }
    }

    static long convertMegToBytes(int n) {
        return n * 1024 * 1024;
    }

    private String getNewFileName(int index) {
        String strFilename = this.m_prefix + "." + index;
        return strFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSwitch(long attemptedSize) throws IOException {
        this.currentSize += attemptedSize;
        if (this.currentSize > this.m_maxSize) {
            LoggerStream loggerStream = this;
            synchronized (loggerStream) {
                if (this.currentSize > this.m_maxSize) {
                    this.out.flush();
                    this.out.close();
                    this.currentIndex = (this.currentIndex + 1) % this.m_maxFiles;
                    if (this.m_files[this.currentIndex] != null) {
                        this.m_files[this.currentIndex].delete();
                    }
                    String filename = this.getNewFileName(this.currentIndex);
                    this.m_files[this.currentIndex] = new File(filename);
                    boolean toSetFilePerm = !new File(filename).exists() && Trace.s_traceFilePerm != null;
                    this.out = new FileOutputStream(filename, false);
                    if (toSetFilePerm) {
                        this.modifyTraceFilePerm(filename);
                    }
                    this.currentSize = attemptedSize;
                }
            }
        }
    }

    private static String getTimeStamp() {
        String strTimeStamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        strTimeStamp = sdf.format(new Date());
        return strTimeStamp;
    }

    @Override
    public void print(String x) {
        if (this.m_multiFile) {
            try {
                this.checkAndSwitch(x.length());
            }
            catch (IOException ex) {
                ex.printStackTrace(Trace.s_stderr);
            }
        }
        super.print(x);
    }

    @Override
    public void println(String x) {
        if (this.m_multiFile) {
            this.currentSize += 2L;
        }
        super.println(x);
    }
}

